/*
 * Decompiled with CFR 0.152.
 */
package com.service.bluetooth;

import android.util.Log;

public class WLog {
    private static final int DUMP_LENGTH = 4000;
    public static final int LEVEL_VERBOSE = 0;
    public static final int LEVEL_DEBUG = 1;
    public static final int LEVEL_INFO = 2;
    public static final int LEVEL_WARNING = 3;
    public static final int LEVEL_ERROR = 4;
    public static final int LEVEL_NONE = 5;
    private static String mTag = "bt_service";
    private static String mRemoteUrl;
    private static int mLevel;

    public static String getMethodName() {
        StackTraceElement[] stacks = Thread.getAllStackTraces().get(Thread.currentThread());
        return stacks[4].getMethodName();
    }

    private static String generateTag(StackTraceElement caller) {
        String tag = "%s.%s(Line:%d)";
        String callerClazzName = caller.getClassName();
        callerClazzName = callerClazzName.substring(callerClazzName.lastIndexOf(".") + 1);
        tag = String.format(tag, callerClazzName, caller.getMethodName(), caller.getLineNumber());
        return tag;
    }

    public static String getNameAndLine(StackTraceElement[] stacks, String msg) {
        String clz = stacks[4].getFileName();
        int line = stacks[4].getLineNumber();
        StringBuffer sb = new StringBuffer();
        sb.append("[").append(clz).append("]").append("<").append(line).append(">").append(":").append(msg);
        return sb.toString();
    }

    public static void initialize(String tag, int level) {
        mLevel = level;
        mTag = tag;
    }

    public static int v(String msg) {
        if (mLevel <= 0) {
            StackTraceElement[] stacks = Thread.getAllStackTraces().get(Thread.currentThread());
            return Log.v((String)mTag, (String)WLog.getNameAndLine(stacks, msg));
        }
        return 0;
    }

    public static int v(String tag, String msg) {
        if (mLevel <= 0) {
            StackTraceElement[] stacks = Thread.getAllStackTraces().get(Thread.currentThread());
            return Log.v((String)mTag, (String)WLog.getNameAndLine(stacks, msg));
        }
        return 0;
    }

    public static int v(String msg, Throwable tr) {
        if (mLevel <= 0) {
            StackTraceElement[] stacks = Thread.getAllStackTraces().get(Thread.currentThread());
            return Log.v((String)mTag, (String)WLog.getNameAndLine(stacks, msg), (Throwable)tr);
        }
        return 0;
    }

    public static int v(String tag, String msg, Throwable tr) {
        if (mLevel <= 0) {
            StackTraceElement[] stacks = Thread.getAllStackTraces().get(Thread.currentThread());
            return Log.v((String)mTag, (String)WLog.getNameAndLine(stacks, msg), (Throwable)tr);
        }
        return 0;
    }

    public static int d(String msg) {
        if (mLevel <= 1) {
            StackTraceElement[] stacks = Thread.getAllStackTraces().get(Thread.currentThread());
            return Log.d((String)mTag, (String)WLog.getNameAndLine(stacks, msg));
        }
        return 0;
    }

    public static int d(String tag, String msg) {
        if (mLevel <= 1) {
            StackTraceElement[] stacks = Thread.getAllStackTraces().get(Thread.currentThread());
            return Log.d((String)mTag, (String)WLog.getNameAndLine(stacks, msg));
        }
        return 0;
    }

    public static int d(String msg, Throwable tr) {
        if (mLevel <= 1) {
            StackTraceElement[] stacks = Thread.getAllStackTraces().get(Thread.currentThread());
            return Log.d((String)mTag, (String)WLog.getNameAndLine(stacks, msg), (Throwable)tr);
        }
        return 0;
    }

    public static int d(String tag, String msg, Throwable tr) {
        if (mLevel <= 1) {
            StackTraceElement[] stacks = Thread.getAllStackTraces().get(Thread.currentThread());
            return Log.d((String)mTag, (String)WLog.getNameAndLine(stacks, msg), (Throwable)tr);
        }
        return 0;
    }

    public static int i(String msg) {
        if (mLevel <= 2) {
            StackTraceElement[] stacks = Thread.getAllStackTraces().get(Thread.currentThread());
            return Log.i((String)mTag, (String)WLog.getNameAndLine(stacks, msg));
        }
        return 0;
    }

    public static int i(String tag, String msg) {
        if (mLevel <= 2) {
            StackTraceElement[] stacks = Thread.getAllStackTraces().get(Thread.currentThread());
            return Log.i((String)mTag, (String)WLog.getNameAndLine(stacks, msg));
        }
        return 0;
    }

    public static int i(String msg, Throwable tr) {
        if (mLevel <= 2) {
            StackTraceElement[] stacks = Thread.getAllStackTraces().get(Thread.currentThread());
            return Log.i((String)mTag, (String)WLog.getNameAndLine(stacks, msg), (Throwable)tr);
        }
        return 0;
    }

    public static int i(String tag, String msg, Throwable tr) {
        if (mLevel <= 2) {
            StackTraceElement[] stacks = Thread.getAllStackTraces().get(Thread.currentThread());
            return Log.i((String)mTag, (String)WLog.getNameAndLine(stacks, msg), (Throwable)tr);
        }
        return 0;
    }

    public static int w(String msg) {
        if (mLevel <= 3) {
            StackTraceElement[] stacks = Thread.getAllStackTraces().get(Thread.currentThread());
            return Log.w((String)mTag, (String)WLog.getNameAndLine(stacks, msg));
        }
        return 0;
    }

    public static int w(String tag, String msg) {
        if (mLevel <= 3) {
            StackTraceElement[] stacks = Thread.getAllStackTraces().get(Thread.currentThread());
            return Log.w((String)mTag, (String)WLog.getNameAndLine(stacks, msg));
        }
        return 0;
    }

    public static int w(String msg, Throwable tr) {
        if (mLevel <= 3) {
            StackTraceElement[] stacks = Thread.getAllStackTraces().get(Thread.currentThread());
            return Log.w((String)mTag, (String)WLog.getNameAndLine(stacks, msg), (Throwable)tr);
        }
        return 0;
    }

    public static int w(String tag, String msg, Throwable tr) {
        if (mLevel <= 3) {
            StackTraceElement[] stacks = Thread.getAllStackTraces().get(Thread.currentThread());
            return Log.w((String)mTag, (String)WLog.getNameAndLine(stacks, msg), (Throwable)tr);
        }
        return 0;
    }

    public static int e(String msg) {
        if (mLevel <= 4) {
            StackTraceElement[] stacks = Thread.getAllStackTraces().get(Thread.currentThread());
            return Log.e((String)mTag, (String)WLog.getNameAndLine(stacks, msg));
        }
        return 0;
    }

    public static int e(String tag, String msg) {
        if (mLevel <= 4) {
            StackTraceElement[] stacks = Thread.getAllStackTraces().get(Thread.currentThread());
            return Log.e((String)mTag, (String)WLog.getNameAndLine(stacks, msg));
        }
        return 0;
    }

    public static int e(String msg, Throwable tr) {
        if (mLevel <= 4) {
            StackTraceElement[] stacks = Thread.getAllStackTraces().get(Thread.currentThread());
            return Log.e((String)mTag, (String)WLog.getNameAndLine(stacks, msg), (Throwable)tr);
        }
        return 0;
    }

    public static int e(String tag, String msg, Throwable tr) {
        if (mLevel <= 4) {
            StackTraceElement[] stacks = Thread.getAllStackTraces().get(Thread.currentThread());
            return Log.e((String)mTag, (String)WLog.getNameAndLine(stacks, msg), (Throwable)tr);
        }
        return 0;
    }

    public static int t(String msg, Object ... args) {
        return Log.v((String)"test", (String)String.format(msg, args));
    }

    public static void remote(String msg) {
        if (mRemoteUrl == null) {
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
            }
        }).start();
    }

    public static void dump(String longMsg) {
        WLog.dump(mTag, longMsg, 2);
    }

    public static void dump(String longMsg, int level) {
        WLog.dump(mTag, longMsg, level);
    }

    public static void dump(String tag, String longMsg) {
        WLog.dump(mTag, "[" + tag + "]" + longMsg, 2);
    }

    public static void dump(String tag, String longMsg, int level) {
        int len = longMsg.length();
        block6: for (int a = 0; a < len; a += 4000) {
            String curr = a + 4000 < len ? longMsg.substring(a, a + 4000) : longMsg.substring(a);
            switch (level) {
                case 4: {
                    WLog.e(tag, curr);
                    continue block6;
                }
                case 3: {
                    WLog.w(tag, curr);
                    continue block6;
                }
                case 2: {
                    WLog.i(tag, curr);
                    continue block6;
                }
                case 1: {
                    WLog.d(tag, curr);
                    continue block6;
                }
                default: {
                    WLog.v(tag, curr);
                }
            }
        }
    }
}

