/*
 * Decompiled with CFR 0.152.
 */
package com.service.bluetooth;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import com.service.bluetooth.BluetoothDevice;
import com.service.bluetooth.BluetoothListener;
import com.service.bluetooth.BluetoothMessage;
import com.service.bluetooth.IBluetoothManager;
import com.service.bluetooth.WLog;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class BluetoothManager {
    private static final String TAG = "BTManager";
    private static final boolean DBG = true;
    private static final int CALL_STATE_INCOMING = 1;
    private static final int CALL_STATE_INCALL = 2;
    private static final int CALL_STATE_OUTGOING = 3;
    public static final int ERROR = Integer.MIN_VALUE;
    public static final String ACTION_STATE_CHANGED = "chleon.android.bluetooth.adapter.action.STATE_CHANGED";
    public static final String EXTRA_STATE = "android.bluetooth.adapter.extra.STATE";
    public static final String EXTRA_PREVIOUS_STATE = "android.bluetooth.adapter.extra.PREVIOUS_STATE";
    public static final int STATE_OFF = 10;
    public static final int STATE_TURNING_ON = 11;
    public static final int STATE_ON = 12;
    public static final int STATE_TURNING_OFF = 13;
    public static final String ACTION_REQUEST_DISCOVERABLE = "android.bluetooth.adapter.action.REQUEST_DISCOVERABLE";
    public static final String EXTRA_DISCOVERABLE_DURATION = "android.bluetooth.adapter.extra.DISCOVERABLE_DURATION";
    public static final String ACTION_REQUEST_ENABLE = "android.bluetooth.adapter.action.REQUEST_ENABLE";
    public static final String ACTION_SCAN_MODE_CHANGED = "android.bluetooth.adapter.action.SCAN_MODE_CHANGED";
    public static final String EXTRA_SCAN_MODE = "android.bluetooth.adapter.extra.SCAN_MODE";
    public static final String EXTRA_PREVIOUS_SCAN_MODE = "android.bluetooth.adapter.extra.PREVIOUS_SCAN_MODE";
    public static final int SCAN_MODE_NONE = 20;
    public static final int SCAN_MODE_CONNECTABLE = 21;
    public static final int SCAN_MODE_CONNECTABLE_DISCOVERABLE = 23;
    public static final String ACTION_DISCOVERY_STARTED = "android.bluetooth.adapter.action.DISCOVERY_STARTED";
    public static final String ACTION_DISCOVERY_FINISHED = "android.bluetooth.adapter.action.DISCOVERY_FINISHED";
    public static final String ACTION_LOCAL_NAME_CHANGED = "android.bluetooth.adapter.action.LOCAL_NAME_CHANGED";
    public static final String EXTRA_LOCAL_NAME = "android.bluetooth.adapter.extra.LOCAL_NAME";
    public static final String BLUETOOTH_SERVICE = "bluetooth";
    private static final int ADDRESS_LENGTH = 17;
    private static BluetoothManager sManager;
    public static IBluetoothManager mService;
    private static final String SERVICE_FILTER = "com.service.bluetooth.ATService";
    private static ConnectListener listener;
    private static ServiceConnection serviceConnection;

    public static synchronized BluetoothManager getDefault(Context context) {
        if (sManager == null) {
            if (null != context) {
                Intent serviceIntent = new Intent(SERVICE_FILTER);
                WLog.d(TAG, "bindService is called");
                boolean isBind = context.bindService(serviceIntent, serviceConnection, 1);
                WLog.d(TAG, "isBind = " + isBind);
                if (!isBind) {
                    WLog.d(TAG, "can not bind to AT Service..");
                }
            }
            sManager = new BluetoothManager();
        }
        return sManager;
    }

    public void registerListener(ConnectListener listener) {
        BluetoothManager.listener = listener;
    }

    private BluetoothManager() {
    }

    private BluetoothManager(IBluetoothManager service) {
        if (service == null) {
            throw new IllegalArgumentException("service is null");
        }
        mService = service;
    }

    public IBluetoothManager getService() {
        return mService;
    }

    public BluetoothDevice getRemoteDevice(String address) {
        return new BluetoothDevice(address);
    }

    public boolean isEnabled() {
        try {
            return mService.isEnabled();
        }
        catch (RemoteException e) {
            WLog.e(TAG, "", e);
            return false;
        }
    }

    public boolean bluetooth_enable(boolean on) {
        try {
            return mService.bluetooth_enable(on);
        }
        catch (RemoteException e) {
            WLog.e(TAG, "", e);
            return false;
        }
    }

    public boolean enable() {
        try {
            return mService.enable();
        }
        catch (RemoteException e) {
            WLog.e(TAG, "", e);
            return false;
        }
    }

    public boolean disable(boolean persistSetting) {
        try {
            return mService.disable(true);
        }
        catch (RemoteException e) {
            WLog.e(TAG, "", e);
            return false;
        }
    }

    public int getState() {
        try {
            return mService.getBluetoothState();
        }
        catch (RemoteException e) {
            WLog.e(TAG, "", e);
            return 10;
        }
    }

    public String getName() {
        try {
            return mService.getName();
        }
        catch (RemoteException e) {
            WLog.e(TAG, "", e);
            return null;
        }
    }

    public boolean setName(String name) {
        if (this.getState() != 12) {
            return false;
        }
        try {
            return mService.setName(name);
        }
        catch (RemoteException e) {
            WLog.e(TAG, "", e);
            return false;
        }
    }

    public String getAddress() {
        try {
            return mService.getAddress();
        }
        catch (RemoteException e) {
            WLog.e(TAG, "", e);
            return null;
        }
    }

    public int getScanMode() {
        if (this.getState() != 12) {
            return 20;
        }
        try {
            return mService.getScanMode();
        }
        catch (RemoteException e) {
            WLog.e(TAG, "", e);
            return 20;
        }
    }

    public boolean setScanMode(int mode, int duration) {
        if (this.getState() != 12) {
            return false;
        }
        try {
            return mService.setScanMode(mode, duration);
        }
        catch (RemoteException e) {
            WLog.e(TAG, "", e);
            return false;
        }
    }

    public boolean startDiscovery() {
        if (this.getState() != 12) {
            return false;
        }
        try {
            return mService.startDiscovery();
        }
        catch (RemoteException e) {
            WLog.e(TAG, "", e);
            return false;
        }
    }

    public boolean cancelDiscovery() {
        if (this.getState() != 12) {
            return false;
        }
        try {
            mService.cancelDiscovery();
        }
        catch (RemoteException e) {
            WLog.e(TAG, "", e);
        }
        return false;
    }

    public boolean isDiscovering() {
        if (this.getState() != 12) {
            return false;
        }
        try {
            return mService.isDiscovering();
        }
        catch (RemoteException e) {
            WLog.e(TAG, "", e);
            return false;
        }
    }

    public Set<BluetoothDevice> getBondedDevices() {
        if (this.getState() != 12) {
            return this.toDeviceSet(new String[0]);
        }
        try {
            return this.toDeviceSet(mService.getBondedDevices());
        }
        catch (RemoteException e) {
            WLog.e(TAG, "", e);
        }
        catch (IllegalArgumentException ie) {
            WLog.e(TAG, "", ie);
        }
        return null;
    }

    public int getMaxBondedDeviceCount() {
        try {
            return mService.getMaxBondedDeviceCount();
        }
        catch (RemoteException remoteException) {
            return 0;
        }
    }

    private Set<BluetoothDevice> toDeviceSet(String[] addresses) {
        HashSet<BluetoothDevice> devices = new HashSet<BluetoothDevice>(addresses.length);
        for (int i = 0; i < addresses.length; ++i) {
            devices.add(this.getRemoteDevice(addresses[i]));
        }
        return Collections.unmodifiableSet(devices);
    }

    public static boolean checkBluetoothAddress(String address) {
        if (address == null || address.length() != 17) {
            return false;
        }
        block4: for (int i = 0; i < 17; ++i) {
            char c = address.charAt(i);
            switch (i % 3) {
                case 0: 
                case 1: {
                    if (c >= '0' && c <= '9' || c >= 'A' && c <= 'F') continue block4;
                    return false;
                }
                case 2: {
                    if (c == ':') continue block4;
                    return false;
                }
            }
        }
        return true;
    }

    public int getPhonebookSize(String address) {
        try {
            return mService.getPhonebookSize(address);
        }
        catch (RemoteException e) {
            WLog.e(TAG, "", e);
            return -1;
        }
    }

    public int getPhonePrivateMode() {
        try {
            return mService.getPhonePrivateMode();
        }
        catch (RemoteException e) {
            WLog.e(TAG, "", e);
            return 1;
        }
    }

    public boolean setPhonePrivateMode(int mode) {
        try {
            return mService.setPhonePrivateMode(mode);
        }
        catch (RemoteException e) {
            WLog.e(TAG, "", e);
            return false;
        }
    }

    public int getAutoConnMode() {
        try {
            return mService.getAutoConnMode();
        }
        catch (RemoteException e) {
            WLog.e(TAG, "", e);
            return 1;
        }
    }

    public boolean setAutoConnMode(int mode) {
        try {
            return mService.setAutoConnMode(mode);
        }
        catch (RemoteException e) {
            WLog.e(TAG, "", e);
            return false;
        }
    }

    public int getMicMuteState() {
        try {
            return mService.getMicMuteState();
        }
        catch (RemoteException e) {
            WLog.e(TAG, "", e);
            return 1;
        }
    }

    public boolean setMicMuteState(int unMuted) {
        try {
            return mService.setMicMuteState(unMuted);
        }
        catch (RemoteException e) {
            WLog.e(TAG, "", e);
            return false;
        }
    }

    public boolean generateDTMF(char value) {
        try {
            return mService.generateDTMF(value);
        }
        catch (RemoteException e) {
            WLog.e(TAG, "", e);
            return false;
        }
    }

    public boolean switchCalls() {
        try {
            return mService.switchCalls();
        }
        catch (RemoteException e) {
            WLog.e(TAG, "", e);
            return false;
        }
    }

    public boolean setStartPBSyncManual(String address) {
        try {
            return mService.setStartPBSyncManual(address);
        }
        catch (RemoteException e) {
            WLog.e(TAG, "", e);
            return false;
        }
    }

    public boolean setADCConfiguration(int type, int value) {
        try {
            return mService.setADCConfiguration(type, value);
        }
        catch (RemoteException e) {
            WLog.e(TAG, "", e);
            return false;
        }
    }

    public boolean setAudioVolume(int type, int value) {
        try {
            return mService.setAudioVolume(type, value);
        }
        catch (RemoteException e) {
            WLog.e(TAG, "", e);
            return false;
        }
    }

    public int getAudioVolume(int type) {
        try {
            return mService.getAudioVolume(type);
        }
        catch (RemoteException e) {
            WLog.e(TAG, "", e);
            return 0;
        }
    }

    public int[] getAudioVolumeRange(int type) {
        try {
            return mService.getAudioVolumeRange(type);
        }
        catch (RemoteException e) {
            WLog.e(TAG, "", e);
            return null;
        }
    }

    public void sendCommand(String cmd) {
        try {
            mService.sendCommand(cmd);
        }
        catch (RemoteException e) {
            WLog.e(TAG, "", e);
        }
    }

    public List<BluetoothMessage> getBtMessage(String address) {
        try {
            return mService.getBtMessage(address);
        }
        catch (RemoteException e) {
            WLog.e(TAG, "", e);
            return null;
        }
    }

    public int getMapSvcState(String address) {
        try {
            return mService.getMapSvcState(address);
        }
        catch (RemoteException e) {
            WLog.e(TAG, "", e);
            return -1;
        }
    }

    public int getPhoneSvcState(String address) {
        try {
            return mService.getPhoneSvcState(address);
        }
        catch (RemoteException e) {
            WLog.e(TAG, "", e);
            return -1;
        }
    }

    public int getA2DPSinkSvcState(String address) {
        try {
            return mService.getA2DPSinkSvcState(address);
        }
        catch (RemoteException e) {
            WLog.e(TAG, "", e);
            return -1;
        }
    }

    public boolean isMapMsgDownloading(String address) {
        try {
            return mService.isMapMsgDownloading(address);
        }
        catch (RemoteException e) {
            WLog.e(TAG, "", e);
            return false;
        }
    }

    public boolean retriveMapMessage(String address, int accountId, int msgId) {
        try {
            return mService.retriveMapMessage(address, accountId, msgId);
        }
        catch (RemoteException e) {
            WLog.e(TAG, "", e);
            return false;
        }
    }

    public boolean sendMapMessage(String address, BluetoothMessage msg) {
        try {
            return mService.sendMapMessage(address, msg);
        }
        catch (RemoteException e) {
            WLog.e(TAG, "", e);
            return false;
        }
    }

    public String GetConnectDeviceAddr(int profile) {
        try {
            return mService.GetConnectDeviceAddr(profile);
        }
        catch (RemoteException e) {
            WLog.e(TAG, "", e);
            return null;
        }
    }

    public String getConnectDeviceAddr(int profile) {
        try {
            return mService.getConnectDeviceAddr(profile);
        }
        catch (RemoteException e) {
            WLog.e(TAG, "", e);
            return null;
        }
    }

    public boolean deviceConnect(String address, int profile, boolean state) {
        try {
            return mService.deviceConnect(address, profile, state);
        }
        catch (RemoteException e) {
            WLog.e(TAG, "", e);
            return false;
        }
    }

    public int getDeviceServiceState(String address, int profile) {
        try {
            return mService.getDeviceServiceState(address, profile);
        }
        catch (RemoteException e) {
            WLog.e(TAG, "", e);
            return 0;
        }
    }

    public String getSwVersion() {
        try {
            return mService.getSwVersion();
        }
        catch (RemoteException e) {
            WLog.e(TAG, "", e);
            return null;
        }
    }

    public boolean enableUpdateMode() {
        try {
            return mService.enableUpdateMode();
        }
        catch (RemoteException e) {
            WLog.e(TAG, "", e);
            return false;
        }
    }

    public void ttsSpeak(String text) {
        try {
            mService.ttsSpeak(text);
        }
        catch (RemoteException e) {
            WLog.e(TAG, "", e);
        }
    }

    public void listen(BluetoothListener listener, int events) {
        String pkgForDebug = "<unknown>";
        try {
            boolean notifyNow = true;
            mService.listen(pkgForDebug, listener.callback, events, notifyNow);
        }
        catch (RemoteException ex) {
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
    }

    public boolean isIdle() {
        BluetoothDevice dev;
        Set<BluetoothDevice> sBluetoothDevices = this.getBondedDevices();
        if (sBluetoothDevices == null || sBluetoothDevices.size() <= 0) {
            WLog.d(TAG, "reloadBondedDevices, get no device");
            return true;
        }
        BluetoothDevice device = null;
        Iterator<BluetoothDevice> i$ = sBluetoothDevices.iterator();
        while (i$.hasNext() && (device = (dev = i$.next())).getState() != 31) {
        }
        if (device == null) {
            return true;
        }
        int callState = device.getCallState();
        switch (callState) {
            case 1: 
            case 2: 
            case 3: {
                return false;
            }
        }
        return true;
    }

    static {
        serviceConnection = new ServiceConnection(){

            public void onServiceConnected(ComponentName name, IBinder iBinder) {
                WLog.d(BluetoothManager.TAG, "onServiceConnected...");
                mService = IBluetoothManager.Stub.asInterface(iBinder);
                if (null != listener) {
                    listener.onServiceConnected();
                }
            }

            public void onServiceDisconnected(ComponentName name) {
                WLog.d(BluetoothManager.TAG, "onServiceDisconnected...");
                sManager = null;
                if (null != listener) {
                    listener.onServiceDisConnected();
                }
            }
        };
    }

    public static interface ConnectListener {
        public void onServiceConnected();

        public void onServiceDisConnected();
    }
}

