/*
 * Decompiled with CFR 0.152.
 */
package small.databinding;

import android.databinding.DataBindingComponent;
import android.databinding.ViewDataBinding;
import android.util.Log;
import android.view.View;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import net.wequick.small.Small;
import small.databinding.DataBinderMappable;

public class DataBinderMapper {
    private static final String TAG = "SmallDataBinding";
    private static final int PASSING_LAYOUT_ID = 1;
    private HashMap<String, DataBinderMappable> dataBinderMappers;
    private ArrayList<String> unresolvedPackages;
    private String bindingPackageName;

    private String getPackageName(int resId) {
        try {
            return Small.getContext().getResources().getResourcePackageName(resId);
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)("Failed to get package name from resource id: " + String.format("0x%08x", resId)));
            return null;
        }
    }

    private DataBinderMappable getSubMapper(int layoutId) {
        return this.getSubMapper(this.getPackageName(layoutId));
    }

    private DataBinderMappable getSubMapper(String pkg) {
        if (pkg == null) {
            return null;
        }
        if (this.unresolvedPackages != null && this.unresolvedPackages.contains(pkg)) {
            return null;
        }
        DataBinderMappable subMapper = null;
        if (this.dataBinderMappers != null) {
            subMapper = this.dataBinderMappers.get(pkg);
        }
        if (subMapper == null) {
            try {
                Class<?> bindingClass = Class.forName(pkg + ".databinding.DataBinderMapper");
                Constructor<?> constructor = bindingClass.getConstructor(new Class[0]);
                constructor.setAccessible(true);
                subMapper = (DataBinderMappable)constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                if (this.unresolvedPackages == null) {
                    this.unresolvedPackages = new ArrayList();
                }
                this.unresolvedPackages.add(pkg);
                throw new RuntimeException("Failed to get DataBinderMapper for package '" + pkg + "'.", e);
            }
        }
        if (this.dataBinderMappers == null) {
            this.dataBinderMappers = new HashMap();
        }
        this.dataBinderMappers.put(pkg, subMapper);
        this.bindingPackageName = pkg;
        return subMapper;
    }

    public ViewDataBinding getDataBinder(DataBindingComponent bindingComponent, View view, int layoutId) {
        DataBinderMappable subMapper = this.getSubMapper(layoutId);
        if (subMapper == null) {
            return null;
        }
        layoutId = subMapper.getLayoutId((String)view.getTag());
        if (layoutId == 0) {
            this.bindingPackageName = null;
            throw new IllegalArgumentException("View is not a binding layout");
        }
        return subMapper.getDataBinder(bindingComponent, view, layoutId);
    }

    ViewDataBinding getDataBinder(DataBindingComponent bindingComponent, View[] views, int layoutId) {
        DataBinderMappable subMapper = this.getSubMapper(layoutId);
        if (subMapper == null) {
            return null;
        }
        layoutId = subMapper.getLayoutId((String)views[0].getTag());
        if (layoutId == 0) {
            this.bindingPackageName = null;
            throw new IllegalArgumentException("View is not a binding layout");
        }
        return subMapper.getDataBinder(bindingComponent, views, layoutId);
    }

    int getLayoutId(String tag) {
        return 1;
    }

    String convertBrIdToString(int id) {
        if (this.bindingPackageName == null) {
            return null;
        }
        DataBinderMappable subMapper = this.getSubMapper(this.bindingPackageName);
        if (subMapper == null) {
            return null;
        }
        return subMapper.convertBrIdToString(id);
    }
}

