/*
 * Decompiled with CFR 0.152.
 */
package site.ycsb.workloads;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import site.ycsb.ByteIterator;
import site.ycsb.DB;
import site.ycsb.NumericByteIterator;
import site.ycsb.Status;
import site.ycsb.StringByteIterator;
import site.ycsb.Utils;
import site.ycsb.Workload;
import site.ycsb.WorkloadException;
import site.ycsb.generator.DiscreteGenerator;
import site.ycsb.generator.Generator;
import site.ycsb.generator.HotspotIntegerGenerator;
import site.ycsb.generator.IncrementingPrintableStringGenerator;
import site.ycsb.generator.NumberGenerator;
import site.ycsb.generator.RandomDiscreteTimestampGenerator;
import site.ycsb.generator.ScrambledZipfianGenerator;
import site.ycsb.generator.SequentialGenerator;
import site.ycsb.generator.UniformLongGenerator;
import site.ycsb.generator.UnixEpochTimestampGenerator;
import site.ycsb.generator.ZipfianGenerator;
import site.ycsb.measurements.Measurements;
import site.ycsb.workloads.CoreWorkload;

public class TimeSeriesWorkload
extends Workload {
    public static final String TIMESTAMP_KEY_PROPERTY = "timestampkey";
    public static final String TIMESTAMP_KEY_PROPERTY_DEFAULT = "YCSBTS";
    public static final String VALUE_KEY_PROPERTY = "valuekey";
    public static final String VALUE_KEY_PROPERTY_DEFAULT = "YCSBV";
    public static final String TIMESTAMP_INTERVAL_PROPERTY = "timestampinterval";
    public static final String TIMESTAMP_INTERVAL_PROPERTY_DEFAULT = "60";
    public static final String TIMESTAMP_UNITS_PROPERTY = "timestampunits";
    public static final String TIMESTAMP_UNITS_PROPERTY_DEFAULT = "SECONDS";
    public static final String TAG_COUNT_PROPERTY = "tagcount";
    public static final String TAG_COUNT_PROPERTY_DEFAULT = "4";
    public static final String TAG_CARDINALITY_PROPERTY = "tagcardinality";
    public static final String TAG_CARDINALITY_PROPERTY_DEFAULT = "1, 2, 4, 8";
    public static final String TAG_KEY_LENGTH_PROPERTY = "tagkeylength";
    public static final String TAG_KEY_LENGTH_PROPERTY_DEFAULT = "8";
    public static final String TAG_VALUE_LENGTH_PROPERTY = "tagvaluelength";
    public static final String TAG_VALUE_LENGTH_PROPERTY_DEFAULT = "8";
    public static final String PAIR_DELIMITER_PROPERTY = "tagpairdelimiter";
    public static final String PAIR_DELIMITER_PROPERTY_DEFAULT = "=";
    public static final String DELETE_DELIMITER_PROPERTY = "deletedelimiter";
    public static final String DELETE_DELIMITER_PROPERTY_DEFAULT = ":";
    public static final String RANDOMIZE_TIMESTAMP_ORDER_PROPERTY = "randomwritetimestamporder";
    public static final String RANDOMIZE_TIMESTAMP_ORDER_PROPERTY_DEFAULT = "false";
    public static final String RANDOMIZE_TIMESERIES_ORDER_PROPERTY = "randomtimeseriesorder";
    public static final String RANDOMIZE_TIMESERIES_ORDER_PROPERTY_DEFAULT = "true";
    public static final String VALUE_TYPE_PROPERTY = "valuetype";
    public static final String VALUE_TYPE_PROPERTY_DEFAULT = "floats";
    public static final String SPARSITY_PROPERTY = "sparsity";
    public static final String SPARSITY_PROPERTY_DEFAULT = "0.00";
    public static final String DELAYED_SERIES_PROPERTY = "delayedseries";
    public static final String DELAYED_SERIES_PROPERTY_DEFAULT = "0.10";
    public static final String DELAYED_INTERVALS_PROPERTY = "delayedintervals";
    public static final String DELAYED_INTERVALS_PROPERTY_DEFAULT = "5";
    public static final String QUERY_TIMESPAN_PROPERTY = "querytimespan";
    public static final String QUERY_TIMESPAN_PROPERTY_DEFAULT = "0";
    public static final String QUERY_RANDOM_TIMESPAN_PROPERTY = "queryrandomtimespan";
    public static final String QUERY_RANDOM_TIMESPAN_PROPERTY_DEFAULT = "false";
    public static final String QUERY_TIMESPAN_DELIMITER_PROPERTY = "querytimespandelimiter";
    public static final String QUERY_TIMESPAN_DELIMITER_PROPERTY_DEFAULT = ",";
    public static final String GROUPBY_KEY_PROPERTY = "groupbykey";
    public static final String GROUPBY_KEY_PROPERTY_DEFAULT = "YCSBGB";
    public static final String GROUPBY_PROPERTY = "groupbyfunction";
    public static final String GROUPBY_KEYS_PROPERTY = "groupbykeys";
    public static final String DOWNSAMPLING_KEY_PROPERTY = "downsamplingkey";
    public static final String DOWNSAMPLING_KEY_PROPERTY_DEFAULT = "YCSBDS";
    public static final String DOWNSAMPLING_FUNCTION_PROPERTY = "downsamplingfunction";
    public static final String DOWNSAMPLING_INTERVAL_PROPERTY = "downsamplinginterval";
    protected Properties properties;
    protected Generator<String> keyGenerator;
    protected Generator<String> tagKeyGenerator;
    protected Generator<String> tagValueGenerator;
    protected String timestampKey;
    protected String valueKey;
    protected int timestampInterval;
    protected TimeUnit timeUnits;
    protected boolean randomizeTimestampOrder;
    protected boolean randomizeTimeseriesOrder;
    protected ValueType valueType;
    protected int[] cumulativeCardinality;
    protected int totalCardinality;
    protected int perKeyCardinality;
    protected NumberGenerator scanlength;
    protected NumberGenerator keychooser;
    protected DiscreteGenerator operationchooser;
    protected int maxOffsets;
    protected int recordcount;
    protected int tagPairs;
    protected String table;
    protected int numKeys;
    protected String[] keys;
    protected String[] tagKeys;
    protected String[] tagValues;
    protected int[] tagCardinality;
    protected int firstIncrementableCardinality;
    protected double sparsity;
    protected double delayedSeries;
    protected int delayedIntervals;
    protected int queryTimeSpan;
    protected boolean queryRandomTimeSpan;
    protected String tagPairDelimiter;
    protected String deleteDelimiter;
    protected String queryTimeSpanDelimiter;
    protected boolean groupBy;
    protected String groupByKey;
    protected String groupByFunction;
    protected boolean[] groupBys;
    protected boolean downsample;
    protected String downsampleKey;
    protected String downsampleFunction;
    protected int downsampleInterval;
    protected boolean dataintegrity;
    protected Measurements measurements = Measurements.getMeasurements();

    @Override
    public void init(Properties p) throws WorkloadException {
        this.properties = p;
        this.recordcount = Integer.parseInt(p.getProperty("recordcount", QUERY_TIMESPAN_PROPERTY_DEFAULT));
        if (this.recordcount == 0) {
            this.recordcount = Integer.MAX_VALUE;
        }
        this.timestampKey = p.getProperty(TIMESTAMP_KEY_PROPERTY, TIMESTAMP_KEY_PROPERTY_DEFAULT);
        this.valueKey = p.getProperty(VALUE_KEY_PROPERTY, VALUE_KEY_PROPERTY_DEFAULT);
        this.operationchooser = CoreWorkload.createOperationGenerator(this.properties);
        int maxscanlength = Integer.parseInt(p.getProperty("maxscanlength", "1000"));
        String scanlengthdistrib = p.getProperty("scanlengthdistribution", "uniform");
        if (scanlengthdistrib.compareTo("uniform") == 0) {
            this.scanlength = new UniformLongGenerator(1L, maxscanlength);
        } else if (scanlengthdistrib.compareTo("zipfian") == 0) {
            this.scanlength = new ZipfianGenerator(1L, maxscanlength);
        } else {
            throw new WorkloadException("Distribution \"" + scanlengthdistrib + "\" not allowed for scan length");
        }
        this.randomizeTimestampOrder = Boolean.parseBoolean(p.getProperty(RANDOMIZE_TIMESTAMP_ORDER_PROPERTY, "false"));
        this.randomizeTimeseriesOrder = Boolean.parseBoolean(p.getProperty(RANDOMIZE_TIMESERIES_ORDER_PROPERTY, RANDOMIZE_TIMESERIES_ORDER_PROPERTY_DEFAULT));
        this.numKeys = Integer.parseInt(p.getProperty("fieldcount", "10"));
        this.tagPairs = Integer.parseInt(p.getProperty(TAG_COUNT_PROPERTY, TAG_COUNT_PROPERTY_DEFAULT));
        this.sparsity = Double.parseDouble(p.getProperty(SPARSITY_PROPERTY, SPARSITY_PROPERTY_DEFAULT));
        this.tagCardinality = new int[this.tagPairs];
        String requestdistrib = p.getProperty("requestdistribution", "uniform");
        if (requestdistrib.compareTo("uniform") == 0) {
            this.keychooser = new UniformLongGenerator(0L, this.numKeys - 1);
        } else if (requestdistrib.compareTo("sequential") == 0) {
            this.keychooser = new SequentialGenerator(0L, this.numKeys - 1);
        } else if (requestdistrib.compareTo("zipfian") == 0) {
            this.keychooser = new ScrambledZipfianGenerator(0L, this.numKeys - 1);
        } else if (requestdistrib.equals("hotspot")) {
            double hotsetfraction = Double.parseDouble(p.getProperty("hotspotdatafraction", "0.2"));
            double hotopnfraction = Double.parseDouble(p.getProperty("hotspotopnfraction", "0.8"));
            this.keychooser = new HotspotIntegerGenerator(0L, this.numKeys - 1, hotsetfraction, hotopnfraction);
        } else {
            throw new WorkloadException("Unknown request distribution \"" + requestdistrib + "\"");
        }
        try {
            this.timestampInterval = Integer.parseInt(p.getProperty(TIMESTAMP_INTERVAL_PROPERTY, TIMESTAMP_INTERVAL_PROPERTY_DEFAULT));
        }
        catch (NumberFormatException nfe) {
            throw new WorkloadException("Unable to parse the timestampinterval", nfe);
        }
        try {
            this.timeUnits = TimeUnit.valueOf(p.getProperty(TIMESTAMP_UNITS_PROPERTY, TIMESTAMP_UNITS_PROPERTY_DEFAULT).toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new WorkloadException("Unknown time unit type", e);
        }
        if (this.timeUnits == TimeUnit.NANOSECONDS || this.timeUnits == TimeUnit.MICROSECONDS) {
            throw new WorkloadException("YCSB doesn't support " + (Object)((Object)this.timeUnits) + " at this time.");
        }
        this.tagPairDelimiter = p.getProperty(PAIR_DELIMITER_PROPERTY, PAIR_DELIMITER_PROPERTY_DEFAULT);
        this.deleteDelimiter = p.getProperty(DELETE_DELIMITER_PROPERTY, DELETE_DELIMITER_PROPERTY_DEFAULT);
        this.dataintegrity = Boolean.parseBoolean(p.getProperty("dataintegrity", "false"));
        this.queryTimeSpan = Integer.parseInt(p.getProperty(QUERY_TIMESPAN_PROPERTY, QUERY_TIMESPAN_PROPERTY_DEFAULT));
        this.queryRandomTimeSpan = Boolean.parseBoolean(p.getProperty(QUERY_RANDOM_TIMESPAN_PROPERTY, "false"));
        this.queryTimeSpanDelimiter = p.getProperty(QUERY_TIMESPAN_DELIMITER_PROPERTY, QUERY_TIMESPAN_DELIMITER_PROPERTY_DEFAULT);
        this.groupByKey = p.getProperty(GROUPBY_KEY_PROPERTY, GROUPBY_KEY_PROPERTY_DEFAULT);
        this.groupByFunction = p.getProperty(GROUPBY_PROPERTY);
        if (this.groupByFunction != null && !this.groupByFunction.isEmpty()) {
            String groupByKeys = p.getProperty(GROUPBY_KEYS_PROPERTY);
            if (groupByKeys == null || groupByKeys.isEmpty()) {
                throw new WorkloadException("Group by was enabled but no keys were specified.");
            }
            String[] gbKeys = groupByKeys.split(QUERY_TIMESPAN_DELIMITER_PROPERTY_DEFAULT);
            if (gbKeys.length != this.tagKeys.length) {
                throw new WorkloadException("Only " + gbKeys.length + " group by keys were specified but there were " + this.tagKeys.length + " tag keys given.");
            }
            this.groupBys = new boolean[gbKeys.length];
            for (int i = 0; i < gbKeys.length; ++i) {
                this.groupBys[i] = Integer.parseInt(gbKeys[i].trim()) != 0;
            }
            this.groupBy = true;
        }
        this.downsampleKey = p.getProperty(DOWNSAMPLING_KEY_PROPERTY, DOWNSAMPLING_KEY_PROPERTY_DEFAULT);
        this.downsampleFunction = p.getProperty(DOWNSAMPLING_FUNCTION_PROPERTY);
        if (this.downsampleFunction != null && !this.downsampleFunction.isEmpty()) {
            String interval = p.getProperty(DOWNSAMPLING_INTERVAL_PROPERTY);
            if (interval == null || interval.isEmpty()) {
                throw new WorkloadException("'downsamplinginterval' was missing despite 'downsamplingfunction' being set.");
            }
            this.downsampleInterval = Integer.parseInt(interval);
            this.downsample = true;
        }
        this.delayedSeries = Double.parseDouble(p.getProperty(DELAYED_SERIES_PROPERTY, DELAYED_SERIES_PROPERTY_DEFAULT));
        this.delayedIntervals = Integer.parseInt(p.getProperty(DELAYED_INTERVALS_PROPERTY, DELAYED_INTERVALS_PROPERTY_DEFAULT));
        this.valueType = ValueType.fromString(p.getProperty(VALUE_TYPE_PROPERTY, VALUE_TYPE_PROPERTY_DEFAULT));
        this.table = p.getProperty("table", "usertable");
        this.initKeysAndTags();
        this.validateSettings();
    }

    @Override
    public Object initThread(Properties p, int mythreadid, int threadcount) throws WorkloadException {
        if (this.properties == null) {
            throw new WorkloadException("Workload has not been initialized.");
        }
        return new ThreadState(mythreadid, threadcount);
    }

    @Override
    public boolean doInsert(DB db, Object threadstate) {
        if (threadstate == null) {
            throw new IllegalStateException("Missing thread state.");
        }
        TreeMap<String, ByteIterator> tags = new TreeMap<String, ByteIterator>();
        String key = ((ThreadState)threadstate).nextDataPoint(tags, true);
        return db.insert(this.table, key, tags) == Status.OK;
    }

    @Override
    public boolean doTransaction(DB db, Object threadstate) {
        if (threadstate == null) {
            throw new IllegalStateException("Missing thread state.");
        }
        switch (this.operationchooser.nextString()) {
            case "READ": {
                this.doTransactionRead(db, threadstate);
                break;
            }
            case "UPDATE": {
                this.doTransactionUpdate(db, threadstate);
                break;
            }
            case "INSERT": {
                this.doTransactionInsert(db, threadstate);
                break;
            }
            case "SCAN": {
                this.doTransactionScan(db, threadstate);
                break;
            }
            case "DELETE": {
                this.doTransactionDelete(db, threadstate);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    protected void doTransactionRead(DB db, Object threadstate) {
        ThreadState state = (ThreadState)threadstate;
        String keyname = this.keys[((Number)this.keychooser.nextValue()).intValue()];
        ThreadLocalRandom random = ThreadLocalRandom.current();
        int offsets = ((Number)state.queryOffsetGenerator.nextValue()).intValue();
        long startTimestamp = offsets > 0 ? state.startTimestamp + state.timestampGenerator.getOffset(offsets) : state.startTimestamp;
        HashSet<String> fields = new HashSet<String>();
        for (int i = 0; i < this.tagPairs; ++i) {
            if (this.groupBy && this.groupBys[i]) {
                fields.add(this.tagKeys[i]);
                continue;
            }
            fields.add(this.tagKeys[i] + this.tagPairDelimiter + this.tagValues[((Random)random).nextInt(this.tagCardinality[i])]);
        }
        if (this.queryTimeSpan > 0) {
            long endTimestamp = this.queryRandomTimeSpan ? startTimestamp + (long)(this.timestampInterval * ((Random)random).nextInt(this.queryTimeSpan / this.timestampInterval)) : startTimestamp + (long)this.queryTimeSpan;
            fields.add(this.timestampKey + this.tagPairDelimiter + startTimestamp + this.queryTimeSpanDelimiter + endTimestamp);
        } else {
            fields.add(this.timestampKey + this.tagPairDelimiter + startTimestamp);
        }
        if (this.groupBy) {
            fields.add(this.groupByKey + this.tagPairDelimiter + this.groupByFunction);
        }
        if (this.downsample) {
            fields.add(this.downsampleKey + this.tagPairDelimiter + this.downsampleFunction + this.downsampleInterval);
        }
        HashMap<String, ByteIterator> cells = new HashMap<String, ByteIterator>();
        Status status = db.read(this.table, keyname, fields, cells);
        if (this.dataintegrity && status == Status.OK) {
            this.verifyRow(keyname, cells);
        }
    }

    protected void doTransactionUpdate(DB db, Object threadstate) {
        if (threadstate == null) {
            throw new IllegalStateException("Missing thread state.");
        }
        TreeMap<String, ByteIterator> tags = new TreeMap<String, ByteIterator>();
        String key = ((ThreadState)threadstate).nextDataPoint(tags, false);
        db.update(this.table, key, tags);
    }

    protected void doTransactionInsert(DB db, Object threadstate) {
        this.doInsert(db, threadstate);
    }

    protected void doTransactionScan(DB db, Object threadstate) {
        ThreadState state = (ThreadState)threadstate;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        String keyname = this.keys[((Random)random).nextInt(this.keys.length)];
        int len = ((Number)this.scanlength.nextValue()).intValue();
        int offsets = ((Random)random).nextInt(this.maxOffsets - 1);
        long startTimestamp = offsets > 0 ? state.startTimestamp + state.timestampGenerator.getOffset(offsets) : state.startTimestamp;
        HashSet<String> fields = new HashSet<String>();
        for (int i = 0; i < this.tagPairs; ++i) {
            if (this.groupBy && this.groupBys[i]) {
                fields.add(this.tagKeys[i]);
                continue;
            }
            fields.add(this.tagKeys[i] + this.tagPairDelimiter + this.tagValues[((Random)random).nextInt(this.tagCardinality[i])]);
        }
        if (this.queryTimeSpan > 0) {
            long endTimestamp = this.queryRandomTimeSpan ? startTimestamp + (long)(this.timestampInterval * ((Random)random).nextInt(this.queryTimeSpan / this.timestampInterval)) : startTimestamp + (long)this.queryTimeSpan;
            fields.add(this.timestampKey + this.tagPairDelimiter + startTimestamp + this.queryTimeSpanDelimiter + endTimestamp);
        } else {
            fields.add(this.timestampKey + this.tagPairDelimiter + startTimestamp);
        }
        if (this.groupBy) {
            fields.add(this.groupByKey + this.tagPairDelimiter + this.groupByFunction);
        }
        if (this.downsample) {
            fields.add(this.downsampleKey + this.tagPairDelimiter + this.downsampleFunction + this.tagPairDelimiter + this.downsampleInterval);
        }
        Vector<HashMap<String, ByteIterator>> results = new Vector<HashMap<String, ByteIterator>>();
        db.scan(this.table, keyname, len, fields, results);
    }

    protected void doTransactionDelete(DB db, Object threadstate) {
        ThreadState state = (ThreadState)threadstate;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        StringBuilder buf = new StringBuilder().append(this.keys[((Random)random).nextInt(this.keys.length)]);
        int offsets = ((Random)random).nextInt(this.maxOffsets - 1);
        long startTimestamp = offsets > 0 ? state.startTimestamp + state.timestampGenerator.getOffset(offsets) : state.startTimestamp;
        for (int i = 0; i < this.tagPairs; ++i) {
            if (this.groupBy && this.groupBys[i]) {
                buf.append(this.deleteDelimiter).append(this.tagKeys[i]);
                continue;
            }
            buf.append(this.deleteDelimiter).append(this.tagKeys[i] + this.tagPairDelimiter + this.tagValues[((Random)random).nextInt(this.tagCardinality[i])]);
        }
        if (this.queryTimeSpan > 0) {
            long endTimestamp = this.queryRandomTimeSpan ? startTimestamp + (long)(this.timestampInterval * ((Random)random).nextInt(this.queryTimeSpan / this.timestampInterval)) : startTimestamp + (long)this.queryTimeSpan;
            buf.append(this.deleteDelimiter).append(this.timestampKey + this.tagPairDelimiter + startTimestamp + this.queryTimeSpanDelimiter + endTimestamp);
        } else {
            buf.append(this.deleteDelimiter).append(this.timestampKey + this.tagPairDelimiter + startTimestamp);
        }
        db.delete(this.table, buf.toString());
    }

    protected Status verifyRow(String key, Map<String, ByteIterator> cells) {
        Status verifyStatus = Status.UNEXPECTED_STATE;
        long startTime = System.nanoTime();
        double value = 0.0;
        long timestamp = 0L;
        TreeMap<String, String> validationTags = new TreeMap<String, String>();
        for (Map.Entry<String, ByteIterator> entry : cells.entrySet()) {
            NumericByteIterator it;
            if (entry.getKey().equals(this.timestampKey)) {
                it = (NumericByteIterator)entry.getValue();
                timestamp = it.getLong();
                continue;
            }
            if (entry.getKey().equals(this.valueKey)) {
                it = (NumericByteIterator)entry.getValue();
                value = it.isFloatingPoint() ? it.getDouble() : (double)it.getLong();
                continue;
            }
            validationTags.put(entry.getKey(), entry.getValue().toString());
        }
        if ((double)this.validationFunction(key, timestamp, validationTags) == value) {
            verifyStatus = Status.OK;
        }
        long endTime = System.nanoTime();
        this.measurements.measure("VERIFY", (int)(endTime - startTime) / 1000);
        this.measurements.reportStatus("VERIFY", verifyStatus);
        return verifyStatus;
    }

    protected long validationFunction(String key, long timestamp, TreeMap<String, String> tags) {
        StringBuilder validationBuffer = new StringBuilder(this.keys[0].length() + this.tagPairs * this.tagKeys[0].length() + this.tagPairs * this.tagCardinality[1]);
        for (Map.Entry<String, String> pair : tags.entrySet()) {
            validationBuffer.append(pair.getKey()).append(pair.getValue());
        }
        return (long)validationBuffer.toString().hashCode() ^ timestamp;
    }

    protected void initKeysAndTags() throws WorkloadException {
        int i;
        int i2;
        int keyLength = Integer.parseInt(this.properties.getProperty("fieldlength", "100"));
        int tagKeyLength = Integer.parseInt(this.properties.getProperty(TAG_KEY_LENGTH_PROPERTY, "8"));
        int tagValueLength = Integer.parseInt(this.properties.getProperty(TAG_VALUE_LENGTH_PROPERTY, "8"));
        this.keyGenerator = new IncrementingPrintableStringGenerator(keyLength);
        this.tagKeyGenerator = new IncrementingPrintableStringGenerator(tagKeyLength);
        this.tagValueGenerator = new IncrementingPrintableStringGenerator(tagValueLength);
        int threads = Integer.parseInt(this.properties.getProperty("threadcount", "1"));
        String tagCardinalityString = this.properties.getProperty(TAG_CARDINALITY_PROPERTY, TAG_CARDINALITY_PROPERTY_DEFAULT);
        String[] tagCardinalityParts = tagCardinalityString.split(QUERY_TIMESPAN_DELIMITER_PROPERTY_DEFAULT);
        int idx = 0;
        this.totalCardinality = this.numKeys;
        this.perKeyCardinality = 1;
        int maxCardinality = 0;
        for (String card : tagCardinalityParts) {
            try {
                this.tagCardinality[idx] = Integer.parseInt(card.trim());
            }
            catch (NumberFormatException nfe) {
                throw new WorkloadException("Unable to parse cardinality: " + card, nfe);
            }
            if (this.tagCardinality[idx] < 1) {
                throw new WorkloadException("Cardinality must be greater than zero: " + this.tagCardinality[idx]);
            }
            this.totalCardinality *= this.tagCardinality[idx];
            this.perKeyCardinality *= this.tagCardinality[idx];
            if (this.tagCardinality[idx] > maxCardinality) {
                maxCardinality = this.tagCardinality[idx];
            }
            if (++idx >= this.tagPairs) break;
        }
        if (this.numKeys < threads) {
            throw new WorkloadException("Field count " + this.numKeys + " (keys for time series workloads) must be greater or equal to the number of threads " + threads);
        }
        if (idx < this.tagPairs) {
            this.tagCardinality[idx++] = 1;
        }
        for (i2 = 0; i2 < this.tagCardinality.length; ++i2) {
            if (this.tagCardinality[i2] <= 1) continue;
            this.firstIncrementableCardinality = i2;
            break;
        }
        this.keys = new String[this.numKeys];
        this.tagKeys = new String[this.tagPairs];
        this.tagValues = new String[maxCardinality];
        for (i2 = 0; i2 < this.numKeys; ++i2) {
            this.keys[i2] = this.keyGenerator.nextString();
        }
        for (i2 = 0; i2 < this.tagPairs; ++i2) {
            this.tagKeys[i2] = this.tagKeyGenerator.nextString();
        }
        for (i2 = 0; i2 < maxCardinality; ++i2) {
            this.tagValues[i2] = this.tagValueGenerator.nextString();
        }
        if (this.randomizeTimeseriesOrder) {
            Utils.shuffleArray(this.keys);
            Utils.shuffleArray(this.tagValues);
        }
        this.maxOffsets = this.recordcount / this.totalCardinality + 1;
        int[] keyAndTagCardinality = new int[this.tagPairs + 1];
        keyAndTagCardinality[0] = this.numKeys;
        for (i = 0; i < this.tagPairs; ++i) {
            keyAndTagCardinality[i + 1] = this.tagCardinality[i];
        }
        this.cumulativeCardinality = new int[keyAndTagCardinality.length];
        for (i = 0; i < keyAndTagCardinality.length; ++i) {
            int cumulation = 1;
            for (int x = i; x <= keyAndTagCardinality.length - 1; ++x) {
                cumulation *= keyAndTagCardinality[x];
            }
            if (i <= 0) continue;
            this.cumulativeCardinality[i - 1] = cumulation;
        }
        this.cumulativeCardinality[this.cumulativeCardinality.length - 1] = 1;
    }

    protected void validateSettings() throws WorkloadException {
        if (this.dataintegrity) {
            if (this.valueType != ValueType.INTEGERS) {
                throw new WorkloadException("Data integrity was enabled. 'valuetype' must be set to 'integers'.");
            }
            if (this.groupBy) {
                throw new WorkloadException("Data integrity was enabled. 'groupbyfunction' must be empty or null.");
            }
            if (this.downsample) {
                throw new WorkloadException("Data integrity was enabled. 'downsamplingfunction' must be empty or null.");
            }
            if (this.queryTimeSpan > 0) {
                throw new WorkloadException("Data integrity was enabled. 'querytimespan' must be empty or 0.");
            }
            if (this.randomizeTimeseriesOrder) {
                throw new WorkloadException("Data integrity was enabled. 'randomizetimeseriesorder' must be false.");
            }
            String startTimestamp = this.properties.getProperty("insertstart");
            if (startTimestamp == null || startTimestamp.isEmpty()) {
                throw new WorkloadException("Data integrity was enabled. 'insertstart' must be set to a Unix Epoch timestamp.");
            }
        }
    }

    protected class ThreadState {
        protected final UnixEpochTimestampGenerator timestampGenerator;
        protected final NumberGenerator queryOffsetGenerator;
        protected int keyIdx;
        protected int keyIdxStart;
        protected int keyIdxEnd;
        protected int[] tagValueIdxs;
        protected boolean rollover;
        protected long startTimestamp;

        protected ThreadState(int threadID, int threadCount) throws WorkloadException {
            int totalThreads;
            int n = totalThreads = threadCount > 0 ? threadCount : 1;
            if (threadID >= totalThreads) {
                throw new IllegalStateException("Thread ID " + threadID + " cannot be greater than or equal than the thread count " + totalThreads);
            }
            if (TimeSeriesWorkload.this.keys.length < threadCount) {
                throw new WorkloadException("Thread count " + totalThreads + " must be greater than or equal to key count " + TimeSeriesWorkload.this.keys.length);
            }
            int keysPerThread = TimeSeriesWorkload.this.keys.length / totalThreads;
            this.keyIdxStart = this.keyIdx = keysPerThread * threadID;
            this.keyIdxEnd = totalThreads - 1 == threadID ? TimeSeriesWorkload.this.keys.length : this.keyIdxStart + keysPerThread;
            this.tagValueIdxs = new int[TimeSeriesWorkload.this.tagPairs];
            String startingTimestamp = TimeSeriesWorkload.this.properties.getProperty("insertstart");
            if (startingTimestamp == null || startingTimestamp.isEmpty()) {
                this.timestampGenerator = TimeSeriesWorkload.this.randomizeTimestampOrder ? new RandomDiscreteTimestampGenerator((long)TimeSeriesWorkload.this.timestampInterval, TimeSeriesWorkload.this.timeUnits, TimeSeriesWorkload.this.maxOffsets) : new UnixEpochTimestampGenerator(TimeSeriesWorkload.this.timestampInterval, TimeSeriesWorkload.this.timeUnits);
            } else {
                try {
                    this.timestampGenerator = TimeSeriesWorkload.this.randomizeTimestampOrder ? new RandomDiscreteTimestampGenerator(TimeSeriesWorkload.this.timestampInterval, TimeSeriesWorkload.this.timeUnits, Long.parseLong(startingTimestamp), TimeSeriesWorkload.this.maxOffsets) : new UnixEpochTimestampGenerator(TimeSeriesWorkload.this.timestampInterval, TimeSeriesWorkload.this.timeUnits, Long.parseLong(startingTimestamp));
                }
                catch (NumberFormatException nfe) {
                    throw new WorkloadException("Unable to parse the insertstart", nfe);
                }
            }
            this.startTimestamp = this.timestampGenerator.nextValue();
            this.queryOffsetGenerator = new UniformLongGenerator(0L, TimeSeriesWorkload.this.maxOffsets - 2);
        }

        protected String nextDataPoint(Map<String, ByteIterator> map, boolean isInsert) {
            String key;
            int iterations;
            ThreadLocalRandom random = ThreadLocalRandom.current();
            int n = iterations = TimeSeriesWorkload.this.sparsity <= 0.0 ? 1 : ((Random)random).nextInt((int)((double)TimeSeriesWorkload.this.perKeyCardinality * TimeSeriesWorkload.this.sparsity));
            if (iterations < 1) {
                iterations = 1;
            }
            do {
                --iterations;
                if (this.rollover) {
                    this.timestampGenerator.nextValue();
                    this.rollover = false;
                }
                key = null;
                if (iterations <= 0) {
                    TreeMap<String, String> validationTags = TimeSeriesWorkload.this.dataintegrity ? new TreeMap<String, String>() : null;
                    key = TimeSeriesWorkload.this.keys[this.keyIdx];
                    int overallIdx = this.keyIdx * TimeSeriesWorkload.this.cumulativeCardinality[0];
                    for (int i = 0; i < TimeSeriesWorkload.this.tagPairs; ++i) {
                        int tvidx = this.tagValueIdxs[i];
                        map.put(TimeSeriesWorkload.this.tagKeys[i], new StringByteIterator(TimeSeriesWorkload.this.tagValues[tvidx]));
                        if (TimeSeriesWorkload.this.dataintegrity) {
                            validationTags.put(TimeSeriesWorkload.this.tagKeys[i], TimeSeriesWorkload.this.tagValues[tvidx]);
                        }
                        if (!(TimeSeriesWorkload.this.delayedSeries > 0.0)) continue;
                        overallIdx += tvidx * TimeSeriesWorkload.this.cumulativeCardinality[i + 1];
                    }
                    if (!isInsert) {
                        long delta = (this.timestampGenerator.currentValue() - this.startTimestamp) / (long)TimeSeriesWorkload.this.timestampInterval;
                        int intervals = ((Random)random).nextInt((int)delta);
                        map.put(TimeSeriesWorkload.this.timestampKey, new NumericByteIterator(this.startTimestamp + (long)(intervals * TimeSeriesWorkload.this.timestampInterval)));
                    } else if (TimeSeriesWorkload.this.delayedSeries > 0.0) {
                        double pct = (double)overallIdx / (double)TimeSeriesWorkload.this.totalCardinality;
                        if (pct < TimeSeriesWorkload.this.delayedSeries) {
                            int modulo = overallIdx % TimeSeriesWorkload.this.delayedIntervals;
                            if (modulo < 0) {
                                modulo *= -1;
                            }
                            map.put(TimeSeriesWorkload.this.timestampKey, new NumericByteIterator(this.timestampGenerator.currentValue() - (long)(TimeSeriesWorkload.this.timestampInterval * modulo)));
                        } else {
                            map.put(TimeSeriesWorkload.this.timestampKey, new NumericByteIterator(this.timestampGenerator.currentValue()));
                        }
                    } else {
                        map.put(TimeSeriesWorkload.this.timestampKey, new NumericByteIterator(this.timestampGenerator.currentValue()));
                    }
                    if (TimeSeriesWorkload.this.dataintegrity) {
                        map.put(TimeSeriesWorkload.this.valueKey, new NumericByteIterator(TimeSeriesWorkload.this.validationFunction(key, this.timestampGenerator.currentValue(), validationTags)));
                    } else {
                        switch (TimeSeriesWorkload.this.valueType) {
                            case INTEGERS: {
                                map.put(TimeSeriesWorkload.this.valueKey, new NumericByteIterator(((Random)random).nextInt()));
                                break;
                            }
                            case FLOATS: {
                                map.put(TimeSeriesWorkload.this.valueKey, new NumericByteIterator(((Random)random).nextDouble() * 100000.0));
                                break;
                            }
                            case MIXED: {
                                if (((Random)random).nextBoolean()) {
                                    map.put(TimeSeriesWorkload.this.valueKey, new NumericByteIterator(((Random)random).nextInt()));
                                    break;
                                }
                                map.put(TimeSeriesWorkload.this.valueKey, new NumericByteIterator(((Random)random).nextDouble() * 100000.0));
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Somehow we didn't have a value type configured that we support: " + (Object)((Object)TimeSeriesWorkload.this.valueType));
                            }
                        }
                    }
                }
                boolean tagRollover = false;
                for (int i = TimeSeriesWorkload.this.tagCardinality.length - 1; i >= 0; --i) {
                    if (TimeSeriesWorkload.this.tagCardinality[i] <= 1) {
                        tagRollover = true;
                        continue;
                    }
                    if (this.tagValueIdxs[i] + 1 >= TimeSeriesWorkload.this.tagCardinality[i]) {
                        this.tagValueIdxs[i] = 0;
                        if (i != TimeSeriesWorkload.this.firstIncrementableCardinality) continue;
                        tagRollover = true;
                        continue;
                    }
                    int n2 = i;
                    this.tagValueIdxs[n2] = this.tagValueIdxs[n2] + 1;
                    break;
                }
                if (!tagRollover) continue;
                if (this.keyIdx + 1 >= this.keyIdxEnd) {
                    this.keyIdx = this.keyIdxStart;
                    this.rollover = true;
                    continue;
                }
                ++this.keyIdx;
            } while (iterations > 0);
            return key;
        }
    }

    public static enum ValueType {
        INTEGERS("integers"),
        FLOATS("floats"),
        MIXED("mixednumbers");

        protected final String name;

        private ValueType(String name) {
            this.name = name;
        }

        public static ValueType fromString(String name) {
            for (ValueType type : ValueType.values()) {
                if (!type.name.equalsIgnoreCase(name)) continue;
                return type;
            }
            throw new IllegalArgumentException("Unrecognized type: " + name);
        }
    }
}

