/*
 * Decompiled with CFR 0.152.
 */
package site.ycsb.workloads;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import site.ycsb.ByteIterator;
import site.ycsb.DB;
import site.ycsb.RandomByteIterator;
import site.ycsb.WorkloadException;
import site.ycsb.generator.DiscreteGenerator;
import site.ycsb.generator.ExponentialGenerator;
import site.ycsb.generator.HotspotIntegerGenerator;
import site.ycsb.generator.NumberGenerator;
import site.ycsb.generator.UniformLongGenerator;
import site.ycsb.generator.ZipfianGenerator;
import site.ycsb.workloads.CoreWorkload;

public class RestWorkload
extends CoreWorkload {
    public static final String DELETE_PROPORTION_PROPERTY = "deleteproportion";
    public static final String DELETE_PROPORTION_PROPERTY_DEFAULT = "0.00";
    public static final String FIELD_LENGTH_DISTRIBUTION_FILE_PROPERTY = "fieldlengthdistfile";
    public static final String FIELD_LENGTH_DISTRIBUTION_FILE_PROPERTY_DEFAULT = "fieldLengthDistFile.txt";
    private static final String READ_TRACE_FILE = "url.trace.read";
    private static final String READ_TRACE_FILE_DEFAULT = "readtrace.txt";
    private static final String READ_ZIPFIAN_CONSTANT = "readzipfconstant";
    private static final String READ_ZIPFIAN_CONSTANT_DEAFULT = "0.99";
    private static final String READ_RECORD_COUNT_PROPERTY = "readrecordcount";
    private static final String INSERT_TRACE_FILE = "url.trace.insert";
    private static final String INSERT_TRACE_FILE_DEFAULT = "inserttrace.txt";
    private static final String INSERT_ZIPFIAN_CONSTANT = "insertzipfconstant";
    private static final String INSERT_ZIPFIAN_CONSTANT_DEAFULT = "0.99";
    private static final String INSERT_SIZE_ZIPFIAN_CONSTANT = "insertsizezipfconstant";
    private static final String INSERT_SIZE_ZIPFIAN_CONSTANT_DEAFULT = "0.99";
    private static final String INSERT_RECORD_COUNT_PROPERTY = "insertrecordcount";
    private static final String DELETE_TRACE_FILE = "url.trace.delete";
    private static final String DELETE_TRACE_FILE_DEFAULT = "deletetrace.txt";
    private static final String DELETE_ZIPFIAN_CONSTANT = "deletezipfconstant";
    private static final String DELETE_ZIPFIAN_CONSTANT_DEAFULT = "0.99";
    private static final String DELETE_RECORD_COUNT_PROPERTY = "deleterecordcount";
    private static final String UPDATE_TRACE_FILE = "url.trace.update";
    private static final String UPDATE_TRACE_FILE_DEFAULT = "updatetrace.txt";
    private static final String UPDATE_ZIPFIAN_CONSTANT = "updatezipfconstant";
    private static final String UPDATE_ZIPFIAN_CONSTANT_DEAFULT = "0.99";
    private static final String UPDATE_RECORD_COUNT_PROPERTY = "updaterecordcount";
    private Map<Integer, String> readUrlMap;
    private Map<Integer, String> insertUrlMap;
    private Map<Integer, String> deleteUrlMap;
    private Map<Integer, String> updateUrlMap;
    private int readRecordCount;
    private int insertRecordCount;
    private int deleteRecordCount;
    private int updateRecordCount;
    private NumberGenerator readKeyChooser;
    private NumberGenerator insertKeyChooser;
    private NumberGenerator deleteKeyChooser;
    private NumberGenerator updateKeyChooser;
    private NumberGenerator fieldlengthgenerator;
    private DiscreteGenerator operationchooser;

    @Override
    public void init(Properties p) throws WorkloadException {
        this.readRecordCount = Integer.parseInt(p.getProperty(READ_RECORD_COUNT_PROPERTY, String.valueOf(Integer.MAX_VALUE)));
        this.insertRecordCount = Integer.parseInt(p.getProperty(INSERT_RECORD_COUNT_PROPERTY, String.valueOf(Integer.MAX_VALUE)));
        this.deleteRecordCount = Integer.parseInt(p.getProperty(DELETE_RECORD_COUNT_PROPERTY, String.valueOf(Integer.MAX_VALUE)));
        this.updateRecordCount = Integer.parseInt(p.getProperty(UPDATE_RECORD_COUNT_PROPERTY, String.valueOf(Integer.MAX_VALUE)));
        this.readUrlMap = RestWorkload.getTrace(p.getProperty(READ_TRACE_FILE, READ_TRACE_FILE_DEFAULT), this.readRecordCount);
        this.insertUrlMap = RestWorkload.getTrace(p.getProperty(INSERT_TRACE_FILE, INSERT_TRACE_FILE_DEFAULT), this.insertRecordCount);
        this.deleteUrlMap = RestWorkload.getTrace(p.getProperty(DELETE_TRACE_FILE, DELETE_TRACE_FILE_DEFAULT), this.deleteRecordCount);
        this.updateUrlMap = RestWorkload.getTrace(p.getProperty(UPDATE_TRACE_FILE, UPDATE_TRACE_FILE_DEFAULT), this.updateRecordCount);
        this.operationchooser = RestWorkload.createOperationGenerator(p);
        String requestDistrib = p.getProperty("requestdistribution", "uniform");
        double readZipfconstant = Double.parseDouble(p.getProperty(READ_ZIPFIAN_CONSTANT, "0.99"));
        this.readKeyChooser = RestWorkload.getKeyChooser(requestDistrib, this.readUrlMap.size(), readZipfconstant, p);
        double updateZipfconstant = Double.parseDouble(p.getProperty(UPDATE_ZIPFIAN_CONSTANT, "0.99"));
        this.updateKeyChooser = RestWorkload.getKeyChooser(requestDistrib, this.updateUrlMap.size(), updateZipfconstant, p);
        double insertZipfconstant = Double.parseDouble(p.getProperty(INSERT_ZIPFIAN_CONSTANT, "0.99"));
        this.insertKeyChooser = RestWorkload.getKeyChooser(requestDistrib, this.insertUrlMap.size(), insertZipfconstant, p);
        double deleteZipfconstant = Double.parseDouble(p.getProperty(DELETE_ZIPFIAN_CONSTANT, "0.99"));
        this.deleteKeyChooser = RestWorkload.getKeyChooser(requestDistrib, this.deleteUrlMap.size(), deleteZipfconstant, p);
        this.fieldlengthgenerator = RestWorkload.getFieldLengthGenerator(p);
    }

    public static DiscreteGenerator createOperationGenerator(Properties p) {
        DiscreteGenerator operationChooser = CoreWorkload.createOperationGenerator(p);
        double deleteproportion = Double.parseDouble(p.getProperty(DELETE_PROPORTION_PROPERTY, DELETE_PROPORTION_PROPERTY_DEFAULT));
        if (deleteproportion > 0.0) {
            operationChooser.addValue(deleteproportion, "DELETE");
        }
        return operationChooser;
    }

    private static NumberGenerator getKeyChooser(String requestDistrib, int recordCount, double zipfContant, Properties p) throws WorkloadException {
        NumberGenerator keychooser;
        switch (requestDistrib) {
            case "exponential": {
                double percentile = Double.parseDouble(p.getProperty("exponential.percentile", "95"));
                double frac = Double.parseDouble(p.getProperty("exponential.frac", "0.8571428571"));
                keychooser = new ExponentialGenerator(percentile, (double)recordCount * frac);
                break;
            }
            case "uniform": {
                keychooser = new UniformLongGenerator(0L, recordCount - 1);
                break;
            }
            case "zipfian": {
                keychooser = new ZipfianGenerator((long)recordCount, zipfContant);
                break;
            }
            case "latest": {
                throw new WorkloadException("Latest request distribution is not supported for RestWorkload.");
            }
            case "hotspot": {
                double hotsetfraction = Double.parseDouble(p.getProperty("hotspotdatafraction", "0.2"));
                double hotopnfraction = Double.parseDouble(p.getProperty("hotspotopnfraction", "0.8"));
                keychooser = new HotspotIntegerGenerator(0L, recordCount - 1, hotsetfraction, hotopnfraction);
                break;
            }
            default: {
                throw new WorkloadException("Unknown request distribution \"" + requestDistrib + "\"");
            }
        }
        return keychooser;
    }

    protected static NumberGenerator getFieldLengthGenerator(Properties p) throws WorkloadException {
        NumberGenerator fieldLengthGenerator = CoreWorkload.getFieldLengthGenerator(p);
        String fieldlengthdistribution = p.getProperty("fieldlengthdistribution", "constant");
        if (fieldlengthdistribution.compareTo("zipfian") == 0) {
            int fieldlength = Integer.parseInt(p.getProperty("fieldlength", "100"));
            double insertsizezipfconstant = Double.parseDouble(p.getProperty(INSERT_SIZE_ZIPFIAN_CONSTANT, "0.99"));
            fieldLengthGenerator = new ZipfianGenerator(1L, fieldlength, insertsizezipfconstant);
        }
        return fieldLengthGenerator;
    }

    private static Map<Integer, String> getTrace(String filePath, int recordCount) throws WorkloadException {
        HashMap<Integer, String> urlMap = new HashMap<Integer, String>();
        int count = 0;
        try {
            String line;
            FileReader inputFile = new FileReader(filePath);
            BufferedReader bufferReader = new BufferedReader(inputFile);
            while ((line = bufferReader.readLine()) != null) {
                urlMap.put(count++, line.trim());
                if (count < recordCount) continue;
            }
            bufferReader.close();
        }
        catch (IOException e) {
            throw new WorkloadException("Error while reading the trace. Please make sure the trace file path is correct. " + e.getLocalizedMessage());
        }
        return urlMap;
    }

    @Override
    public boolean doInsert(DB db, Object threadstate) {
        return false;
    }

    @Override
    public boolean doTransaction(DB db, Object threadstate) {
        String operation = this.operationchooser.nextString();
        if (operation == null) {
            return false;
        }
        switch (operation) {
            case "UPDATE": {
                this.doTransactionUpdate(db);
                break;
            }
            case "INSERT": {
                this.doTransactionInsert(db);
                break;
            }
            case "DELETE": {
                this.doTransactionDelete(db);
                break;
            }
            default: {
                this.doTransactionRead(db);
            }
        }
        return true;
    }

    private String getNextURL(int opType) {
        if (opType == 1) {
            return this.readUrlMap.get(((Number)this.readKeyChooser.nextValue()).intValue());
        }
        if (opType == 2) {
            return this.insertUrlMap.get(((Number)this.insertKeyChooser.nextValue()).intValue());
        }
        if (opType == 3) {
            return this.deleteUrlMap.get(((Number)this.deleteKeyChooser.nextValue()).intValue());
        }
        return this.updateUrlMap.get(((Number)this.updateKeyChooser.nextValue()).intValue());
    }

    @Override
    public void doTransactionRead(DB db) {
        HashMap<String, ByteIterator> result = new HashMap<String, ByteIterator>();
        db.read(null, this.getNextURL(1), null, result);
    }

    @Override
    public void doTransactionInsert(DB db) {
        HashMap<String, ByteIterator> value = new HashMap<String, ByteIterator>();
        value.put("data", new RandomByteIterator(((Number)this.fieldlengthgenerator.nextValue()).longValue()));
        db.insert(null, this.getNextURL(2), value);
    }

    public void doTransactionDelete(DB db) {
        db.delete(null, this.getNextURL(3));
    }

    @Override
    public void doTransactionUpdate(DB db) {
        HashMap<String, ByteIterator> value = new HashMap<String, ByteIterator>();
        value.put("data", new RandomByteIterator(((Number)this.fieldlengthgenerator.nextValue()).longValue()));
        db.update(null, this.getNextURL(4), value);
    }
}

