/*
 * Decompiled with CFR 0.152.
 */
package site.ycsb.workloads;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import site.ycsb.ByteIterator;
import site.ycsb.DB;
import site.ycsb.RandomByteIterator;
import site.ycsb.Status;
import site.ycsb.StringByteIterator;
import site.ycsb.Utils;
import site.ycsb.Workload;
import site.ycsb.WorkloadException;
import site.ycsb.generator.AcknowledgedCounterGenerator;
import site.ycsb.generator.ConstantIntegerGenerator;
import site.ycsb.generator.CounterGenerator;
import site.ycsb.generator.DiscreteGenerator;
import site.ycsb.generator.ExponentialGenerator;
import site.ycsb.generator.HistogramGenerator;
import site.ycsb.generator.HotspotIntegerGenerator;
import site.ycsb.generator.NumberGenerator;
import site.ycsb.generator.ScrambledZipfianGenerator;
import site.ycsb.generator.SequentialGenerator;
import site.ycsb.generator.SkewedLatestGenerator;
import site.ycsb.generator.UniformLongGenerator;
import site.ycsb.generator.ZipfianGenerator;
import site.ycsb.measurements.Measurements;

public class CoreWorkload
extends Workload {
    public static final String TABLENAME_PROPERTY = "table";
    public static final String TABLENAME_PROPERTY_DEFAULT = "usertable";
    protected String table;
    public static final String FIELD_COUNT_PROPERTY = "fieldcount";
    public static final String FIELD_COUNT_PROPERTY_DEFAULT = "10";
    private List<String> fieldnames;
    public static final String FIELD_LENGTH_DISTRIBUTION_PROPERTY = "fieldlengthdistribution";
    public static final String FIELD_LENGTH_DISTRIBUTION_PROPERTY_DEFAULT = "constant";
    public static final String FIELD_LENGTH_PROPERTY = "fieldlength";
    public static final String FIELD_LENGTH_PROPERTY_DEFAULT = "100";
    public static final String MIN_FIELD_LENGTH_PROPERTY = "minfieldlength";
    public static final String MIN_FIELD_LENGTH_PROPERTY_DEFAULT = "1";
    public static final String FIELD_LENGTH_HISTOGRAM_FILE_PROPERTY = "fieldlengthhistogram";
    public static final String FIELD_LENGTH_HISTOGRAM_FILE_PROPERTY_DEFAULT = "hist.txt";
    protected NumberGenerator fieldlengthgenerator;
    public static final String READ_ALL_FIELDS_PROPERTY = "readallfields";
    public static final String READ_ALL_FIELDS_PROPERTY_DEFAULT = "true";
    protected boolean readallfields;
    public static final String WRITE_ALL_FIELDS_PROPERTY = "writeallfields";
    public static final String WRITE_ALL_FIELDS_PROPERTY_DEFAULT = "false";
    protected boolean writeallfields;
    public static final String DATA_INTEGRITY_PROPERTY = "dataintegrity";
    public static final String DATA_INTEGRITY_PROPERTY_DEFAULT = "false";
    private boolean dataintegrity;
    public static final String READ_PROPORTION_PROPERTY = "readproportion";
    public static final String READ_PROPORTION_PROPERTY_DEFAULT = "0.95";
    public static final String UPDATE_PROPORTION_PROPERTY = "updateproportion";
    public static final String UPDATE_PROPORTION_PROPERTY_DEFAULT = "0.05";
    public static final String INSERT_PROPORTION_PROPERTY = "insertproportion";
    public static final String INSERT_PROPORTION_PROPERTY_DEFAULT = "0.0";
    public static final String SCAN_PROPORTION_PROPERTY = "scanproportion";
    public static final String SCAN_PROPORTION_PROPERTY_DEFAULT = "0.0";
    public static final String READMODIFYWRITE_PROPORTION_PROPERTY = "readmodifywriteproportion";
    public static final String READMODIFYWRITE_PROPORTION_PROPERTY_DEFAULT = "0.0";
    public static final String REQUEST_DISTRIBUTION_PROPERTY = "requestdistribution";
    public static final String REQUEST_DISTRIBUTION_PROPERTY_DEFAULT = "uniform";
    public static final String ZERO_PADDING_PROPERTY = "zeropadding";
    public static final String ZERO_PADDING_PROPERTY_DEFAULT = "1";
    public static final String MIN_SCAN_LENGTH_PROPERTY = "minscanlength";
    public static final String MIN_SCAN_LENGTH_PROPERTY_DEFAULT = "1";
    public static final String MAX_SCAN_LENGTH_PROPERTY = "maxscanlength";
    public static final String MAX_SCAN_LENGTH_PROPERTY_DEFAULT = "1000";
    public static final String SCAN_LENGTH_DISTRIBUTION_PROPERTY = "scanlengthdistribution";
    public static final String SCAN_LENGTH_DISTRIBUTION_PROPERTY_DEFAULT = "uniform";
    public static final String INSERT_ORDER_PROPERTY = "insertorder";
    public static final String INSERT_ORDER_PROPERTY_DEFAULT = "hashed";
    public static final String HOTSPOT_DATA_FRACTION = "hotspotdatafraction";
    public static final String HOTSPOT_DATA_FRACTION_DEFAULT = "0.2";
    public static final String HOTSPOT_OPN_FRACTION = "hotspotopnfraction";
    public static final String HOTSPOT_OPN_FRACTION_DEFAULT = "0.8";
    public static final String INSERTION_RETRY_LIMIT = "core_workload_insertion_retry_limit";
    public static final String INSERTION_RETRY_LIMIT_DEFAULT = "0";
    public static final String INSERTION_RETRY_INTERVAL = "core_workload_insertion_retry_interval";
    public static final String INSERTION_RETRY_INTERVAL_DEFAULT = "3";
    public static final String FIELD_NAME_PREFIX = "fieldnameprefix";
    public static final String FIELD_NAME_PREFIX_DEFAULT = "field";
    protected NumberGenerator keysequence;
    protected DiscreteGenerator operationchooser;
    protected NumberGenerator keychooser;
    protected NumberGenerator fieldchooser;
    protected AcknowledgedCounterGenerator transactioninsertkeysequence;
    protected NumberGenerator scanlength;
    protected boolean orderedinserts;
    protected long fieldcount;
    protected long recordcount;
    protected int zeropadding;
    protected int insertionRetryLimit;
    protected int insertionRetryInterval;
    private Measurements measurements = Measurements.getMeasurements();

    protected static NumberGenerator getFieldLengthGenerator(Properties p) throws WorkloadException {
        NumberGenerator fieldlengthgenerator;
        String fieldlengthdistribution = p.getProperty(FIELD_LENGTH_DISTRIBUTION_PROPERTY, FIELD_LENGTH_DISTRIBUTION_PROPERTY_DEFAULT);
        int fieldlength = Integer.parseInt(p.getProperty(FIELD_LENGTH_PROPERTY, FIELD_LENGTH_PROPERTY_DEFAULT));
        int minfieldlength = Integer.parseInt(p.getProperty(MIN_FIELD_LENGTH_PROPERTY, "1"));
        String fieldlengthhistogram = p.getProperty(FIELD_LENGTH_HISTOGRAM_FILE_PROPERTY, FIELD_LENGTH_HISTOGRAM_FILE_PROPERTY_DEFAULT);
        if (fieldlengthdistribution.compareTo(FIELD_LENGTH_DISTRIBUTION_PROPERTY_DEFAULT) == 0) {
            fieldlengthgenerator = new ConstantIntegerGenerator(fieldlength);
        } else if (fieldlengthdistribution.compareTo("uniform") == 0) {
            fieldlengthgenerator = new UniformLongGenerator(minfieldlength, fieldlength);
        } else if (fieldlengthdistribution.compareTo("zipfian") == 0) {
            fieldlengthgenerator = new ZipfianGenerator((long)minfieldlength, fieldlength);
        } else if (fieldlengthdistribution.compareTo("histogram") == 0) {
            try {
                fieldlengthgenerator = new HistogramGenerator(fieldlengthhistogram);
            }
            catch (IOException e) {
                throw new WorkloadException("Couldn't read field length histogram file: " + fieldlengthhistogram, e);
            }
        } else {
            throw new WorkloadException("Unknown field length distribution \"" + fieldlengthdistribution + "\"");
        }
        return fieldlengthgenerator;
    }

    @Override
    public void init(Properties p) throws WorkloadException {
        long insertcount;
        this.table = p.getProperty(TABLENAME_PROPERTY, TABLENAME_PROPERTY_DEFAULT);
        this.fieldcount = Long.parseLong(p.getProperty(FIELD_COUNT_PROPERTY, FIELD_COUNT_PROPERTY_DEFAULT));
        String fieldnameprefix = p.getProperty(FIELD_NAME_PREFIX, FIELD_NAME_PREFIX_DEFAULT);
        this.fieldnames = new ArrayList<String>();
        int i = 0;
        while ((long)i < this.fieldcount) {
            this.fieldnames.add(fieldnameprefix + i);
            ++i;
        }
        this.fieldlengthgenerator = CoreWorkload.getFieldLengthGenerator(p);
        this.recordcount = Long.parseLong(p.getProperty("recordcount", INSERTION_RETRY_LIMIT_DEFAULT));
        if (this.recordcount == 0L) {
            this.recordcount = Integer.MAX_VALUE;
        }
        String requestdistrib = p.getProperty(REQUEST_DISTRIBUTION_PROPERTY, "uniform");
        int minscanlength = Integer.parseInt(p.getProperty(MIN_SCAN_LENGTH_PROPERTY, "1"));
        int maxscanlength = Integer.parseInt(p.getProperty(MAX_SCAN_LENGTH_PROPERTY, MAX_SCAN_LENGTH_PROPERTY_DEFAULT));
        String scanlengthdistrib = p.getProperty(SCAN_LENGTH_DISTRIBUTION_PROPERTY, "uniform");
        long insertstart = Long.parseLong(p.getProperty("insertstart", INSERTION_RETRY_LIMIT_DEFAULT));
        if (this.recordcount < insertstart + (insertcount = (long)Integer.parseInt(p.getProperty("insertcount", String.valueOf(this.recordcount - insertstart))))) {
            System.err.println("Invalid combination of insertstart, insertcount and recordcount.");
            System.err.println("recordcount must be bigger than insertstart + insertcount.");
            System.exit(-1);
        }
        this.zeropadding = Integer.parseInt(p.getProperty(ZERO_PADDING_PROPERTY, "1"));
        this.readallfields = Boolean.parseBoolean(p.getProperty(READ_ALL_FIELDS_PROPERTY, READ_ALL_FIELDS_PROPERTY_DEFAULT));
        this.writeallfields = Boolean.parseBoolean(p.getProperty(WRITE_ALL_FIELDS_PROPERTY, "false"));
        this.dataintegrity = Boolean.parseBoolean(p.getProperty(DATA_INTEGRITY_PROPERTY, "false"));
        if (this.dataintegrity && !p.getProperty(FIELD_LENGTH_DISTRIBUTION_PROPERTY, FIELD_LENGTH_DISTRIBUTION_PROPERTY_DEFAULT).equals(FIELD_LENGTH_DISTRIBUTION_PROPERTY_DEFAULT)) {
            System.err.println("Must have constant field size to check data integrity.");
            System.exit(-1);
        }
        this.orderedinserts = p.getProperty(INSERT_ORDER_PROPERTY, INSERT_ORDER_PROPERTY_DEFAULT).compareTo(INSERT_ORDER_PROPERTY_DEFAULT) != 0;
        this.keysequence = new CounterGenerator(insertstart);
        this.operationchooser = CoreWorkload.createOperationGenerator(p);
        this.transactioninsertkeysequence = new AcknowledgedCounterGenerator(this.recordcount);
        if (requestdistrib.compareTo("uniform") == 0) {
            this.keychooser = new UniformLongGenerator(insertstart, insertstart + insertcount - 1L);
        } else if (requestdistrib.compareTo("exponential") == 0) {
            double percentile = Double.parseDouble(p.getProperty("exponential.percentile", "95"));
            double frac = Double.parseDouble(p.getProperty("exponential.frac", "0.8571428571"));
            this.keychooser = new ExponentialGenerator(percentile, (double)this.recordcount * frac);
        } else if (requestdistrib.compareTo("sequential") == 0) {
            this.keychooser = new SequentialGenerator(insertstart, insertstart + insertcount - 1L);
        } else if (requestdistrib.compareTo("zipfian") == 0) {
            double insertproportion = Double.parseDouble(p.getProperty(INSERT_PROPORTION_PROPERTY, "0.0"));
            int opcount = Integer.parseInt(p.getProperty("operationcount"));
            int expectednewkeys = (int)((double)opcount * insertproportion * 2.0);
            this.keychooser = new ScrambledZipfianGenerator(insertstart, insertstart + insertcount + (long)expectednewkeys);
        } else if (requestdistrib.compareTo("latest") == 0) {
            this.keychooser = new SkewedLatestGenerator(this.transactioninsertkeysequence);
        } else if (requestdistrib.equals("hotspot")) {
            double hotsetfraction = Double.parseDouble(p.getProperty(HOTSPOT_DATA_FRACTION, HOTSPOT_DATA_FRACTION_DEFAULT));
            double hotopnfraction = Double.parseDouble(p.getProperty(HOTSPOT_OPN_FRACTION, HOTSPOT_OPN_FRACTION_DEFAULT));
            this.keychooser = new HotspotIntegerGenerator(insertstart, insertstart + insertcount - 1L, hotsetfraction, hotopnfraction);
        } else {
            throw new WorkloadException("Unknown request distribution \"" + requestdistrib + "\"");
        }
        this.fieldchooser = new UniformLongGenerator(0L, this.fieldcount - 1L);
        if (scanlengthdistrib.compareTo("uniform") == 0) {
            this.scanlength = new UniformLongGenerator(minscanlength, maxscanlength);
        } else if (scanlengthdistrib.compareTo("zipfian") == 0) {
            this.scanlength = new ZipfianGenerator((long)minscanlength, maxscanlength);
        } else {
            throw new WorkloadException("Distribution \"" + scanlengthdistrib + "\" not allowed for scan length");
        }
        this.insertionRetryLimit = Integer.parseInt(p.getProperty(INSERTION_RETRY_LIMIT, INSERTION_RETRY_LIMIT_DEFAULT));
        this.insertionRetryInterval = Integer.parseInt(p.getProperty(INSERTION_RETRY_INTERVAL, INSERTION_RETRY_INTERVAL_DEFAULT));
    }

    protected String buildKeyName(long keynum) {
        if (!this.orderedinserts) {
            keynum = Utils.hash(keynum);
        }
        String value = Long.toString(keynum);
        int fill = this.zeropadding - value.length();
        String prekey = "user";
        for (int i = 0; i < fill; ++i) {
            prekey = prekey + '0';
        }
        return prekey + value;
    }

    private HashMap<String, ByteIterator> buildSingleValue(String key) {
        HashMap<String, ByteIterator> value = new HashMap<String, ByteIterator>();
        String fieldkey = this.fieldnames.get(((Number)this.fieldchooser.nextValue()).intValue());
        ByteIterator data = this.dataintegrity ? new StringByteIterator(this.buildDeterministicValue(key, fieldkey)) : new RandomByteIterator(((Number)this.fieldlengthgenerator.nextValue()).longValue());
        value.put(fieldkey, data);
        return value;
    }

    private HashMap<String, ByteIterator> buildValues(String key) {
        HashMap<String, ByteIterator> values = new HashMap<String, ByteIterator>();
        for (String fieldkey : this.fieldnames) {
            ByteIterator data = this.dataintegrity ? new StringByteIterator(this.buildDeterministicValue(key, fieldkey)) : new RandomByteIterator(((Number)this.fieldlengthgenerator.nextValue()).longValue());
            values.put(fieldkey, data);
        }
        return values;
    }

    private String buildDeterministicValue(String key, String fieldkey) {
        int size = ((Number)this.fieldlengthgenerator.nextValue()).intValue();
        StringBuilder sb = new StringBuilder(size);
        sb.append(key);
        sb.append(':');
        sb.append(fieldkey);
        while (sb.length() < size) {
            sb.append(':');
            sb.append(sb.toString().hashCode());
        }
        sb.setLength(size);
        return sb.toString();
    }

    @Override
    public boolean doInsert(DB db, Object threadstate) {
        Status status;
        int keynum = ((Number)this.keysequence.nextValue()).intValue();
        String dbkey = this.buildKeyName(keynum);
        HashMap<String, ByteIterator> values = this.buildValues(dbkey);
        int numOfRetries = 0;
        while (null == (status = db.insert(this.table, dbkey, values)) || !status.isOk()) {
            if (++numOfRetries <= this.insertionRetryLimit) {
                System.err.println("Retrying insertion, retry count: " + numOfRetries);
                try {
                    int sleepTime = (int)((double)(1000 * this.insertionRetryInterval) * (0.8 + 0.4 * Math.random()));
                    Thread.sleep(sleepTime);
                    continue;
                }
                catch (InterruptedException e) {
                    break;
                }
            }
            System.err.println("Error inserting, not retrying any more. number of attempts: " + numOfRetries + "Insertion Retry Limit: " + this.insertionRetryLimit);
            break;
        }
        return null != status && status.isOk();
    }

    @Override
    public boolean doTransaction(DB db, Object threadstate) {
        String operation = this.operationchooser.nextString();
        if (operation == null) {
            return false;
        }
        switch (operation) {
            case "READ": {
                this.doTransactionRead(db);
                break;
            }
            case "UPDATE": {
                this.doTransactionUpdate(db);
                break;
            }
            case "INSERT": {
                this.doTransactionInsert(db);
                break;
            }
            case "SCAN": {
                this.doTransactionScan(db);
                break;
            }
            default: {
                this.doTransactionReadModifyWrite(db);
            }
        }
        return true;
    }

    protected void verifyRow(String key, HashMap<String, ByteIterator> cells) {
        Status verifyStatus = Status.OK;
        long startTime = System.nanoTime();
        if (!cells.isEmpty()) {
            for (Map.Entry<String, ByteIterator> entry : cells.entrySet()) {
                if (entry.getValue().toString().equals(this.buildDeterministicValue(key, entry.getKey()))) continue;
                verifyStatus = Status.UNEXPECTED_STATE;
                break;
            }
        } else {
            verifyStatus = Status.ERROR;
        }
        long endTime = System.nanoTime();
        this.measurements.measure("VERIFY", (int)(endTime - startTime) / 1000);
        this.measurements.reportStatus("VERIFY", verifyStatus);
    }

    long nextKeynum() {
        long keynum;
        if (this.keychooser instanceof ExponentialGenerator) {
            while ((keynum = this.transactioninsertkeysequence.lastValue() - (long)((Number)this.keychooser.nextValue()).intValue()) < 0L) {
            }
        } else {
            while ((keynum = (long)((Number)this.keychooser.nextValue()).intValue()) > this.transactioninsertkeysequence.lastValue()) {
            }
        }
        return keynum;
    }

    public void doTransactionRead(DB db) {
        long keynum = this.nextKeynum();
        String keyname = this.buildKeyName(keynum);
        HashSet<String> fields = null;
        if (!this.readallfields) {
            String fieldname = this.fieldnames.get(((Number)this.fieldchooser.nextValue()).intValue());
            fields = new HashSet();
            fields.add(fieldname);
        } else if (this.dataintegrity) {
            fields = new HashSet<String>(this.fieldnames);
        }
        HashMap<String, ByteIterator> cells = new HashMap<String, ByteIterator>();
        db.read(this.table, keyname, fields, cells);
        if (this.dataintegrity) {
            this.verifyRow(keyname, cells);
        }
    }

    public void doTransactionReadModifyWrite(DB db) {
        long keynum = this.nextKeynum();
        String keyname = this.buildKeyName(keynum);
        HashSet<String> fields = null;
        if (!this.readallfields) {
            String fieldname = this.fieldnames.get(((Number)this.fieldchooser.nextValue()).intValue());
            fields = new HashSet<String>();
            fields.add(fieldname);
        }
        HashMap<String, ByteIterator> values = this.writeallfields ? this.buildValues(keyname) : this.buildSingleValue(keyname);
        HashMap<String, ByteIterator> cells = new HashMap<String, ByteIterator>();
        long ist = this.measurements.getIntendedtartTimeNs();
        long st = System.nanoTime();
        db.read(this.table, keyname, fields, cells);
        db.update(this.table, keyname, values);
        long en = System.nanoTime();
        if (this.dataintegrity) {
            this.verifyRow(keyname, cells);
        }
        this.measurements.measure("READ-MODIFY-WRITE", (int)((en - st) / 1000L));
        this.measurements.measureIntended("READ-MODIFY-WRITE", (int)((en - ist) / 1000L));
    }

    public void doTransactionScan(DB db) {
        long keynum = this.nextKeynum();
        String startkeyname = this.buildKeyName(keynum);
        int len = ((Number)this.scanlength.nextValue()).intValue();
        HashSet<String> fields = null;
        if (!this.readallfields) {
            String fieldname = this.fieldnames.get(((Number)this.fieldchooser.nextValue()).intValue());
            fields = new HashSet<String>();
            fields.add(fieldname);
        }
        db.scan(this.table, startkeyname, len, fields, new Vector<HashMap<String, ByteIterator>>());
    }

    public void doTransactionUpdate(DB db) {
        long keynum = this.nextKeynum();
        String keyname = this.buildKeyName(keynum);
        HashMap<String, ByteIterator> values = this.writeallfields ? this.buildValues(keyname) : this.buildSingleValue(keyname);
        db.update(this.table, keyname, values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTransactionInsert(DB db) {
        long keynum = this.transactioninsertkeysequence.nextValue();
        try {
            String dbkey = this.buildKeyName(keynum);
            HashMap<String, ByteIterator> values = this.buildValues(dbkey);
            db.insert(this.table, dbkey, values);
        }
        finally {
            this.transactioninsertkeysequence.acknowledge(keynum);
        }
    }

    protected static DiscreteGenerator createOperationGenerator(Properties p) {
        if (p == null) {
            throw new IllegalArgumentException("Properties object cannot be null");
        }
        double readproportion = Double.parseDouble(p.getProperty(READ_PROPORTION_PROPERTY, READ_PROPORTION_PROPERTY_DEFAULT));
        double updateproportion = Double.parseDouble(p.getProperty(UPDATE_PROPORTION_PROPERTY, UPDATE_PROPORTION_PROPERTY_DEFAULT));
        double insertproportion = Double.parseDouble(p.getProperty(INSERT_PROPORTION_PROPERTY, "0.0"));
        double scanproportion = Double.parseDouble(p.getProperty(SCAN_PROPORTION_PROPERTY, "0.0"));
        double readmodifywriteproportion = Double.parseDouble(p.getProperty(READMODIFYWRITE_PROPORTION_PROPERTY, "0.0"));
        DiscreteGenerator operationchooser = new DiscreteGenerator();
        if (readproportion > 0.0) {
            operationchooser.addValue(readproportion, "READ");
        }
        if (updateproportion > 0.0) {
            operationchooser.addValue(updateproportion, "UPDATE");
        }
        if (insertproportion > 0.0) {
            operationchooser.addValue(insertproportion, "INSERT");
        }
        if (scanproportion > 0.0) {
            operationchooser.addValue(scanproportion, "SCAN");
        }
        if (readmodifywriteproportion > 0.0) {
            operationchooser.addValue(readmodifywriteproportion, "READMODIFYWRITE");
        }
        return operationchooser;
    }
}

