/*
 * Decompiled with CFR 0.152.
 */
package site.ycsb.workloads;

import java.util.Properties;
import site.ycsb.WorkloadException;
import site.ycsb.generator.NumberGenerator;
import site.ycsb.workloads.CoreWorkload;

public class ConstantOccupancyWorkload
extends CoreWorkload {
    private long disksize;
    private long storageages;
    private double occupancy;
    private long objectCount;
    public static final String STORAGE_AGE_PROPERTY = "storageages";
    public static final long STORAGE_AGE_PROPERTY_DEFAULT = 10L;
    public static final String DISK_SIZE_PROPERTY = "disksize";
    public static final long DISK_SIZE_PROPERTY_DEFAULT = 100000000L;
    public static final String OCCUPANCY_PROPERTY = "occupancy";
    public static final double OCCUPANCY_PROPERTY_DEFAULT = 0.9;

    @Override
    public void init(Properties p) throws WorkloadException {
        this.disksize = Long.parseLong(p.getProperty(DISK_SIZE_PROPERTY, String.valueOf(100000000L)));
        this.storageages = Long.parseLong(p.getProperty(STORAGE_AGE_PROPERTY, String.valueOf(10L)));
        this.occupancy = Double.parseDouble(p.getProperty(OCCUPANCY_PROPERTY, String.valueOf(0.9)));
        if (p.getProperty("recordcount") != null || p.getProperty("insertcount") != null || p.getProperty("operationcount") != null) {
            System.err.println("Warning: record, insert or operation count was set prior to initting ConstantOccupancyWorkload.  Overriding old values.");
        }
        NumberGenerator g = CoreWorkload.getFieldLengthGenerator(p);
        double fieldsize = g.mean();
        int fieldcount = Integer.parseInt(p.getProperty("fieldcount", "10"));
        this.objectCount = (long)(this.occupancy * ((double)this.disksize / (fieldsize * (double)fieldcount)));
        if (this.objectCount == 0L) {
            throw new IllegalStateException("Object count was zero.  Perhaps disksize is too low?");
        }
        p.setProperty("recordcount", String.valueOf(this.objectCount));
        p.setProperty("operationcount", String.valueOf(this.storageages * this.objectCount));
        p.setProperty("insertcount", String.valueOf(this.objectCount));
        super.init(p);
    }
}

