/*
 * Decompiled with CFR 0.152.
 */
package site.ycsb.measurements;

import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Properties;
import java.util.Vector;
import site.ycsb.measurements.OneMeasurement;
import site.ycsb.measurements.SeriesUnit;
import site.ycsb.measurements.exporter.MeasurementsExporter;

public class OneMeasurementTimeSeries
extends OneMeasurement {
    public static final String GRANULARITY = "timeseries.granularity";
    public static final String GRANULARITY_DEFAULT = "1000";
    private final int granularity;
    private final Vector<SeriesUnit> measurements;
    private long start = -1L;
    private long currentunit = -1L;
    private long count = 0L;
    private long sum = 0L;
    private long operations = 0L;
    private long totallatency = 0L;
    private int windowoperations = 0;
    private long windowtotallatency = 0L;
    private int min = -1;
    private int max = -1;

    public OneMeasurementTimeSeries(String name, Properties props) {
        super(name);
        this.granularity = Integer.parseInt(props.getProperty(GRANULARITY, GRANULARITY_DEFAULT));
        this.measurements = new Vector();
    }

    private synchronized void checkEndOfUnit(boolean forceend) {
        long unit;
        long now = System.currentTimeMillis();
        if (this.start < 0L) {
            this.currentunit = 0L;
            this.start = now;
        }
        if ((unit = (now - this.start) / (long)this.granularity * (long)this.granularity) > this.currentunit || forceend) {
            double avg = (double)this.sum / (double)this.count;
            this.measurements.add(new SeriesUnit(this.currentunit, avg));
            this.currentunit = unit;
            this.count = 0L;
            this.sum = 0L;
        }
    }

    @Override
    public void measure(int latency) {
        this.checkEndOfUnit(false);
        ++this.count;
        this.sum += (long)latency;
        this.totallatency += (long)latency;
        ++this.operations;
        ++this.windowoperations;
        this.windowtotallatency += (long)latency;
        if (latency > this.max) {
            this.max = latency;
        }
        if (latency < this.min || this.min < 0) {
            this.min = latency;
        }
    }

    @Override
    public void exportMeasurements(MeasurementsExporter exporter) throws IOException {
        this.checkEndOfUnit(true);
        exporter.write(this.getName(), "Operations", this.operations);
        exporter.write(this.getName(), "AverageLatency(us)", (double)this.totallatency / (double)this.operations);
        exporter.write(this.getName(), "MinLatency(us)", this.min);
        exporter.write(this.getName(), "MaxLatency(us)", this.max);
        this.exportStatusCounts(exporter);
        for (SeriesUnit unit : this.measurements) {
            exporter.write(this.getName(), Long.toString(unit.time), unit.average);
        }
    }

    @Override
    public String getSummary() {
        if (this.windowoperations == 0) {
            return "";
        }
        DecimalFormat d = new DecimalFormat("#.##");
        double report = (double)this.windowtotallatency / (double)this.windowoperations;
        this.windowtotallatency = 0L;
        this.windowoperations = 0;
        return "[" + this.getName() + " AverageLatency(us)=" + d.format(report) + "]";
    }
}

