/*
 * Decompiled with CFR 0.152.
 */
package site.ycsb.measurements;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Properties;
import site.ycsb.measurements.OneMeasurement;
import site.ycsb.measurements.exporter.MeasurementsExporter;

public class OneMeasurementRaw
extends OneMeasurement {
    public static final String OUTPUT_FILE_PATH = "measurement.raw.output_file";
    public static final String OUTPUT_FILE_PATH_DEFAULT = "";
    public static final String NO_SUMMARY_STATS = "measurement.raw.no_summary";
    public static final String NO_SUMMARY_STATS_DEFAULT = "false";
    private final PrintStream outputStream;
    private boolean noSummaryStats = false;
    private LinkedList<RawDataPoint> measurements;
    private long totalLatency = 0L;
    private int windowOperations = 0;
    private long windowTotalLatency = 0L;

    public OneMeasurementRaw(String name, Properties props) {
        super(name);
        String outputFilePath = props.getProperty(OUTPUT_FILE_PATH, OUTPUT_FILE_PATH_DEFAULT);
        if (!outputFilePath.isEmpty()) {
            System.out.println("Raw data measurement: will output to result file: " + outputFilePath);
            try {
                this.outputStream = new PrintStream(new FileOutputStream(outputFilePath, true), true);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("Failed to open raw data output file", e);
            }
        } else {
            System.out.println("Raw data measurement: will output to stdout.");
            this.outputStream = System.out;
        }
        this.noSummaryStats = Boolean.parseBoolean(props.getProperty(NO_SUMMARY_STATS, NO_SUMMARY_STATS_DEFAULT));
        this.measurements = new LinkedList();
    }

    @Override
    public synchronized void measure(int latency) {
        this.totalLatency += (long)latency;
        this.windowTotalLatency += (long)latency;
        ++this.windowOperations;
        this.measurements.add(new RawDataPoint(latency));
    }

    @Override
    public void exportMeasurements(MeasurementsExporter exporter) throws IOException {
        this.outputStream.println(this.getName() + " latency raw data: op, timestamp(ms), latency(us)");
        for (RawDataPoint point : this.measurements) {
            this.outputStream.println(String.format("%s,%d,%d", this.getName(), point.timeStamp(), point.value()));
        }
        if (this.outputStream != System.out) {
            this.outputStream.close();
        }
        int totalOps = this.measurements.size();
        exporter.write(this.getName(), "Total Operations", totalOps);
        if (totalOps > 0 && !this.noSummaryStats) {
            exporter.write(this.getName(), "Below is a summary of latency in microseconds:", -1);
            exporter.write(this.getName(), "Average", (double)this.totalLatency / (double)totalOps);
            Collections.sort(this.measurements, new RawDataPointComparator());
            exporter.write(this.getName(), "Min", this.measurements.get(0).value());
            exporter.write(this.getName(), "Max", this.measurements.get(totalOps - 1).value());
            exporter.write(this.getName(), "p1", this.measurements.get((int)((double)totalOps * 0.01)).value());
            exporter.write(this.getName(), "p5", this.measurements.get((int)((double)totalOps * 0.05)).value());
            exporter.write(this.getName(), "p50", this.measurements.get((int)((double)totalOps * 0.5)).value());
            exporter.write(this.getName(), "p90", this.measurements.get((int)((double)totalOps * 0.9)).value());
            exporter.write(this.getName(), "p95", this.measurements.get((int)((double)totalOps * 0.95)).value());
            exporter.write(this.getName(), "p99", this.measurements.get((int)((double)totalOps * 0.99)).value());
            exporter.write(this.getName(), "p99.9", this.measurements.get((int)((double)totalOps * 0.999)).value());
            exporter.write(this.getName(), "p99.99", this.measurements.get((int)((double)totalOps * 0.9999)).value());
        }
        this.exportStatusCounts(exporter);
    }

    @Override
    public synchronized String getSummary() {
        if (this.windowOperations == 0) {
            return OUTPUT_FILE_PATH_DEFAULT;
        }
        String toReturn = String.format("%s count: %d, average latency(us): %.2f", this.getName(), this.windowOperations, (double)this.windowTotalLatency / (double)this.windowOperations);
        this.windowTotalLatency = 0L;
        this.windowOperations = 0;
        return toReturn;
    }

    class RawDataPointComparator
    implements Comparator<RawDataPoint> {
        RawDataPointComparator() {
        }

        @Override
        public int compare(RawDataPoint p1, RawDataPoint p2) {
            if (p1.value() < p2.value()) {
                return -1;
            }
            if (p1.value() == p2.value()) {
                return 0;
            }
            return 1;
        }
    }

    class RawDataPoint {
        private final long timestamp = System.currentTimeMillis();
        private final int value;

        public RawDataPoint(int value) {
            this.value = value;
        }

        public long timeStamp() {
            return this.timestamp;
        }

        public int value() {
            return this.value;
        }
    }
}

