/*
 * Decompiled with CFR 0.152.
 */
package site.ycsb.measurements;

import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Properties;
import site.ycsb.measurements.OneMeasurement;
import site.ycsb.measurements.exporter.MeasurementsExporter;

public class OneMeasurementHistogram
extends OneMeasurement {
    public static final String BUCKETS = "histogram.buckets";
    public static final String BUCKETS_DEFAULT = "1000";
    public static final String VERBOSE_PROPERTY = "measurement.histogram.verbose";
    private final int buckets;
    private long[] histogram;
    private long histogramoverflow;
    private long operations;
    private long totallatency;
    private double totalsquaredlatency;
    private final boolean verbose;
    private long windowoperations;
    private long windowtotallatency;
    private int min;
    private int max;

    public OneMeasurementHistogram(String name, Properties props) {
        super(name);
        this.buckets = Integer.parseInt(props.getProperty(BUCKETS, BUCKETS_DEFAULT));
        this.verbose = Boolean.valueOf(props.getProperty(VERBOSE_PROPERTY, String.valueOf(false)));
        this.histogram = new long[this.buckets];
        this.histogramoverflow = 0L;
        this.operations = 0L;
        this.totallatency = 0L;
        this.totalsquaredlatency = 0.0;
        this.windowoperations = 0L;
        this.windowtotallatency = 0L;
        this.min = -1;
        this.max = -1;
    }

    @Override
    public synchronized void measure(int latency) {
        if (latency / 1000 >= this.buckets) {
            ++this.histogramoverflow;
        } else {
            int n = latency / 1000;
            this.histogram[n] = this.histogram[n] + 1L;
        }
        ++this.operations;
        this.totallatency += (long)latency;
        this.totalsquaredlatency += (double)latency * (double)latency;
        ++this.windowoperations;
        this.windowtotallatency += (long)latency;
        if (this.min < 0 || latency < this.min) {
            this.min = latency;
        }
        if (this.max < 0 || latency > this.max) {
            this.max = latency;
        }
    }

    @Override
    public void exportMeasurements(MeasurementsExporter exporter) throws IOException {
        int i;
        double mean = (double)this.totallatency / (double)this.operations;
        double variance = this.totalsquaredlatency / (double)this.operations - mean * mean;
        exporter.write(this.getName(), "Operations", this.operations);
        exporter.write(this.getName(), "AverageLatency(us)", mean);
        exporter.write(this.getName(), "LatencyVariance(us)", variance);
        exporter.write(this.getName(), "MinLatency(us)", this.min);
        exporter.write(this.getName(), "MaxLatency(us)", this.max);
        long opcounter = 0L;
        boolean done95th = false;
        for (i = 0; i < this.buckets; ++i) {
            opcounter += this.histogram[i];
            if (!done95th && (double)opcounter / (double)this.operations >= 0.95) {
                exporter.write(this.getName(), "95thPercentileLatency(us)", i * 1000);
                done95th = true;
            }
            if (!((double)opcounter / (double)this.operations >= 0.99)) continue;
            exporter.write(this.getName(), "99thPercentileLatency(us)", i * 1000);
            break;
        }
        this.exportStatusCounts(exporter);
        if (this.verbose) {
            for (i = 0; i < this.buckets; ++i) {
                exporter.write(this.getName(), Integer.toString(i), this.histogram[i]);
            }
            exporter.write(this.getName(), ">" + this.buckets, this.histogramoverflow);
        }
    }

    @Override
    public String getSummary() {
        if (this.windowoperations == 0L) {
            return "";
        }
        DecimalFormat d = new DecimalFormat("#.##");
        double report = (double)this.windowtotallatency / (double)this.windowoperations;
        this.windowtotallatency = 0L;
        this.windowoperations = 0L;
        return "[" + this.getName() + " AverageLatency(us)=" + d.format(report) + "]";
    }
}

