/*
 * Decompiled with CFR 0.152.
 */
package site.ycsb.measurements;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.HdrHistogram.AbstractHistogram;
import org.HdrHistogram.EncodableHistogram;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.HistogramIterationValue;
import org.HdrHistogram.HistogramLogWriter;
import org.HdrHistogram.Recorder;
import site.ycsb.measurements.OneMeasurement;
import site.ycsb.measurements.exporter.MeasurementsExporter;

public class OneMeasurementHdrHistogram
extends OneMeasurement {
    private final PrintStream log;
    private final HistogramLogWriter histogramLogWriter;
    private final Recorder histogram;
    private Histogram totalHistogram;
    public static final String PERCENTILES_PROPERTY = "hdrhistogram.percentiles";
    public static final String PERCENTILES_PROPERTY_DEFAULT = "95,99";
    public static final String VERBOSE_PROPERTY = "measurement.histogram.verbose";
    private final boolean verbose;
    private final List<Double> percentiles;

    public OneMeasurementHdrHistogram(String name, Properties props) {
        super(name);
        this.percentiles = this.getPercentileValues(props.getProperty(PERCENTILES_PROPERTY, PERCENTILES_PROPERTY_DEFAULT));
        this.verbose = Boolean.valueOf(props.getProperty(VERBOSE_PROPERTY, String.valueOf(false)));
        boolean shouldLog = Boolean.parseBoolean(props.getProperty("hdrhistogram.fileoutput", "false"));
        if (!shouldLog) {
            this.log = null;
            this.histogramLogWriter = null;
        } else {
            try {
                String hdrOutputFilename = props.getProperty("hdrhistogram.output.path", "") + name + ".hdr";
                this.log = new PrintStream(new FileOutputStream(hdrOutputFilename), false);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("Failed to open hdr histogram output file", e);
            }
            this.histogramLogWriter = new HistogramLogWriter(this.log);
            this.histogramLogWriter.outputComment("[Logging for: " + name + "]");
            this.histogramLogWriter.outputLogFormatVersion();
            long now = System.currentTimeMillis();
            this.histogramLogWriter.outputStartTime(now);
            this.histogramLogWriter.setBaseTime(now);
            this.histogramLogWriter.outputLegend();
        }
        this.histogram = new Recorder(3);
    }

    @Override
    public void measure(int latencyInMicros) {
        this.histogram.recordValue((long)latencyInMicros);
    }

    @Override
    public void exportMeasurements(MeasurementsExporter exporter) throws IOException {
        Histogram intervalHistogram = this.getIntervalHistogramAndAccumulate();
        if (this.histogramLogWriter != null) {
            this.histogramLogWriter.outputIntervalHistogram((EncodableHistogram)intervalHistogram);
            this.log.close();
        }
        exporter.write(this.getName(), "Operations", this.totalHistogram.getTotalCount());
        exporter.write(this.getName(), "AverageLatency(us)", this.totalHistogram.getMean());
        exporter.write(this.getName(), "MinLatency(us)", this.totalHistogram.getMinValue());
        exporter.write(this.getName(), "MaxLatency(us)", this.totalHistogram.getMaxValue());
        for (Double percentile : this.percentiles) {
            exporter.write(this.getName(), this.ordinal(percentile) + "PercentileLatency(us)", this.totalHistogram.getValueAtPercentile(percentile.doubleValue()));
        }
        this.exportStatusCounts(exporter);
        if (this.verbose) {
            for (HistogramIterationValue v : this.totalHistogram.recordedValues()) {
                int value = v.getValueIteratedTo() > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)v.getValueIteratedTo();
                exporter.write(this.getName(), Integer.toString(value), (double)v.getCountAtValueIteratedTo());
            }
        }
    }

    @Override
    public String getSummary() {
        Histogram intervalHistogram = this.getIntervalHistogramAndAccumulate();
        if (this.histogramLogWriter != null) {
            this.histogramLogWriter.outputIntervalHistogram((EncodableHistogram)intervalHistogram);
        }
        DecimalFormat d = new DecimalFormat("#.##");
        return "[" + this.getName() + ": Count=" + intervalHistogram.getTotalCount() + ", Max=" + intervalHistogram.getMaxValue() + ", Min=" + intervalHistogram.getMinValue() + ", Avg=" + d.format(intervalHistogram.getMean()) + ", 90=" + d.format(intervalHistogram.getValueAtPercentile(90.0)) + ", 99=" + d.format(intervalHistogram.getValueAtPercentile(99.0)) + ", 99.9=" + d.format(intervalHistogram.getValueAtPercentile(99.9)) + ", 99.99=" + d.format(intervalHistogram.getValueAtPercentile(99.99)) + "]";
    }

    private Histogram getIntervalHistogramAndAccumulate() {
        Histogram intervalHistogram = this.histogram.getIntervalHistogram();
        if (this.totalHistogram == null) {
            this.totalHistogram = intervalHistogram;
        } else {
            this.totalHistogram.add((AbstractHistogram)intervalHistogram);
        }
        return intervalHistogram;
    }

    private List<Double> getPercentileValues(String percentileString) {
        ArrayList<Double> percentileValues = new ArrayList<Double>();
        try {
            for (String rawPercentile : percentileString.split(",")) {
                percentileValues.add(Double.parseDouble(rawPercentile));
            }
        }
        catch (Exception e) {
            System.err.println("[WARN] Couldn't read hdrhistogram.percentiles value: '" + percentileString + "', the default of '" + PERCENTILES_PROPERTY_DEFAULT + "' will be used.");
            e.printStackTrace();
            return this.getPercentileValues(PERCENTILES_PROPERTY_DEFAULT);
        }
        return percentileValues;
    }

    private String ordinal(Double i) {
        String[] suffixes = new String[]{"th", "st", "nd", "rd", "th", "th", "th", "th", "th", "th"};
        Integer j = i.intValue();
        if (i % 1.0 == 0.0) {
            switch (j % 100) {
                case 11: 
                case 12: 
                case 13: {
                    return j + "th";
                }
            }
            return j + suffixes[j % 10];
        }
        return i.toString();
    }
}

