/*
 * Decompiled with CFR 0.152.
 */
package site.ycsb.measurements;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import site.ycsb.Status;
import site.ycsb.measurements.exporter.MeasurementsExporter;

public abstract class OneMeasurement {
    private final String name;
    private final ConcurrentHashMap<Status, AtomicInteger> returncodes;

    public String getName() {
        return this.name;
    }

    public OneMeasurement(String name) {
        this.name = name;
        this.returncodes = new ConcurrentHashMap();
    }

    public abstract void measure(int var1);

    public abstract String getSummary();

    public void reportStatus(Status status) {
        AtomicInteger other;
        AtomicInteger counter = this.returncodes.get(status);
        if (counter == null && (other = this.returncodes.putIfAbsent(status, counter = new AtomicInteger())) != null) {
            counter = other;
        }
        counter.incrementAndGet();
    }

    public abstract void exportMeasurements(MeasurementsExporter var1) throws IOException;

    protected final void exportStatusCounts(MeasurementsExporter exporter) throws IOException {
        for (Map.Entry<Status, AtomicInteger> entry : this.returncodes.entrySet()) {
            exporter.write(this.getName(), "Return=" + entry.getKey().getName(), entry.getValue().get());
        }
    }
}

