/*
 * Decompiled with CFR 0.152.
 */
package site.ycsb.measurements;

import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import site.ycsb.Status;
import site.ycsb.measurements.OneMeasurement;
import site.ycsb.measurements.OneMeasurementHdrHistogram;
import site.ycsb.measurements.OneMeasurementHistogram;
import site.ycsb.measurements.OneMeasurementRaw;
import site.ycsb.measurements.OneMeasurementTimeSeries;
import site.ycsb.measurements.TwoInOneMeasurement;
import site.ycsb.measurements.exporter.MeasurementsExporter;

public class Measurements {
    public static final String MEASUREMENT_TYPE_PROPERTY = "measurementtype";
    private static final String MEASUREMENT_TYPE_PROPERTY_DEFAULT = "hdrhistogram";
    public static final String MEASUREMENT_INTERVAL = "measurement.interval";
    private static final String MEASUREMENT_INTERVAL_DEFAULT = "op";
    public static final String MEASUREMENT_TRACK_JVM_PROPERTY = "measurement.trackjvm";
    public static final String MEASUREMENT_TRACK_JVM_PROPERTY_DEFAULT = "false";
    private static Measurements singleton = null;
    private static Properties measurementproperties = null;
    private final ConcurrentHashMap<String, OneMeasurement> opToMesurementMap;
    private final ConcurrentHashMap<String, OneMeasurement> opToIntendedMesurementMap;
    private final MeasurementType measurementType;
    private final int measurementInterval;
    private final Properties props;
    private final ThreadLocal<StartTimeHolder> tlIntendedStartTime = new ThreadLocal<StartTimeHolder>(){

        @Override
        protected StartTimeHolder initialValue() {
            return new StartTimeHolder();
        }
    };

    public static void setProperties(Properties props) {
        measurementproperties = props;
    }

    public static synchronized Measurements getMeasurements() {
        if (singleton == null) {
            singleton = new Measurements(measurementproperties);
        }
        return singleton;
    }

    public Measurements(Properties props) {
        String mIntervalString;
        String mTypeString;
        this.opToMesurementMap = new ConcurrentHashMap();
        this.opToIntendedMesurementMap = new ConcurrentHashMap();
        this.props = props;
        switch (mTypeString = this.props.getProperty(MEASUREMENT_TYPE_PROPERTY, MEASUREMENT_TYPE_PROPERTY_DEFAULT)) {
            case "histogram": {
                this.measurementType = MeasurementType.HISTOGRAM;
                break;
            }
            case "hdrhistogram": {
                this.measurementType = MeasurementType.HDRHISTOGRAM;
                break;
            }
            case "hdrhistogram+histogram": {
                this.measurementType = MeasurementType.HDRHISTOGRAM_AND_HISTOGRAM;
                break;
            }
            case "hdrhistogram+raw": {
                this.measurementType = MeasurementType.HDRHISTOGRAM_AND_RAW;
                break;
            }
            case "timeseries": {
                this.measurementType = MeasurementType.TIMESERIES;
                break;
            }
            case "raw": {
                this.measurementType = MeasurementType.RAW;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown measurementtype=" + mTypeString);
            }
        }
        switch (mIntervalString = this.props.getProperty(MEASUREMENT_INTERVAL, MEASUREMENT_INTERVAL_DEFAULT)) {
            case "op": {
                this.measurementInterval = 0;
                break;
            }
            case "intended": {
                this.measurementInterval = 1;
                break;
            }
            case "both": {
                this.measurementInterval = 2;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown measurement.interval=" + mIntervalString);
            }
        }
    }

    private OneMeasurement constructOneMeasurement(String name) {
        switch (this.measurementType) {
            case HISTOGRAM: {
                return new OneMeasurementHistogram(name, this.props);
            }
            case HDRHISTOGRAM: {
                return new OneMeasurementHdrHistogram(name, this.props);
            }
            case HDRHISTOGRAM_AND_HISTOGRAM: {
                return new TwoInOneMeasurement(name, new OneMeasurementHdrHistogram("Hdr" + name, this.props), new OneMeasurementHistogram("Bucket" + name, this.props));
            }
            case HDRHISTOGRAM_AND_RAW: {
                return new TwoInOneMeasurement(name, new OneMeasurementHdrHistogram("Hdr" + name, this.props), new OneMeasurementRaw("Raw" + name, this.props));
            }
            case TIMESERIES: {
                return new OneMeasurementTimeSeries(name, this.props);
            }
            case RAW: {
                return new OneMeasurementRaw(name, this.props);
            }
        }
        throw new AssertionError((Object)"Impossible to be here. Dead code reached. Bugs?");
    }

    public void setIntendedStartTimeNs(long time) {
        if (this.measurementInterval == 0) {
            return;
        }
        this.tlIntendedStartTime.get().time = time;
    }

    public long getIntendedtartTimeNs() {
        if (this.measurementInterval == 0) {
            return 0L;
        }
        return this.tlIntendedStartTime.get().startTime();
    }

    public void measure(String operation, int latency) {
        if (this.measurementInterval == 1) {
            return;
        }
        try {
            OneMeasurement m = this.getOpMeasurement(operation);
            m.measure(latency);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("ERROR: java.lang.ArrayIndexOutOfBoundsException - ignoring and continuing");
            e.printStackTrace();
            e.printStackTrace(System.out);
        }
    }

    public void measureIntended(String operation, int latency) {
        if (this.measurementInterval == 0) {
            return;
        }
        try {
            OneMeasurement m = this.getOpIntendedMeasurement(operation);
            m.measure(latency);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("ERROR: java.lang.ArrayIndexOutOfBoundsException - ignoring and continuing");
            e.printStackTrace();
            e.printStackTrace(System.out);
        }
    }

    private OneMeasurement getOpMeasurement(String operation) {
        OneMeasurement oldM;
        OneMeasurement m = this.opToMesurementMap.get(operation);
        if (m == null && (oldM = this.opToMesurementMap.putIfAbsent(operation, m = this.constructOneMeasurement(operation))) != null) {
            m = oldM;
        }
        return m;
    }

    private OneMeasurement getOpIntendedMeasurement(String operation) {
        String name;
        OneMeasurement oldM;
        OneMeasurement m = this.opToIntendedMesurementMap.get(operation);
        if (m == null && (oldM = this.opToIntendedMesurementMap.putIfAbsent(operation, m = this.constructOneMeasurement(name = this.measurementInterval == 1 ? operation : "Intended-" + operation))) != null) {
            m = oldM;
        }
        return m;
    }

    public void reportStatus(String operation, Status status) {
        OneMeasurement m = this.measurementInterval == 1 ? this.getOpIntendedMeasurement(operation) : this.getOpMeasurement(operation);
        m.reportStatus(status);
    }

    public void exportMeasurements(MeasurementsExporter exporter) throws IOException {
        for (OneMeasurement measurement : this.opToMesurementMap.values()) {
            measurement.exportMeasurements(exporter);
        }
        for (OneMeasurement measurement : this.opToIntendedMesurementMap.values()) {
            measurement.exportMeasurements(exporter);
        }
    }

    public synchronized String getSummary() {
        String ret = "";
        for (OneMeasurement m : this.opToMesurementMap.values()) {
            ret = ret + m.getSummary() + " ";
        }
        for (OneMeasurement m : this.opToIntendedMesurementMap.values()) {
            ret = ret + m.getSummary() + " ";
        }
        return ret;
    }

    static class StartTimeHolder {
        protected long time;

        StartTimeHolder() {
        }

        long startTime() {
            if (this.time == 0L) {
                return System.nanoTime();
            }
            return this.time;
        }
    }

    public static enum MeasurementType {
        HISTOGRAM,
        HDRHISTOGRAM,
        HDRHISTOGRAM_AND_HISTOGRAM,
        HDRHISTOGRAM_AND_RAW,
        TIMESERIES,
        RAW;

    }
}

