/*
 * Decompiled with CFR 0.152.
 */
package site.ycsb.generator;

import java.util.concurrent.ThreadLocalRandom;
import site.ycsb.generator.NumberGenerator;

public class ZipfianGenerator
extends NumberGenerator {
    public static final double ZIPFIAN_CONSTANT = 0.99;
    private final long items;
    private final long base;
    private final double zipfianconstant;
    private double alpha;
    private double zetan;
    private double eta;
    private double theta;
    private double zeta2theta;
    private long countforzeta;
    private boolean allowitemcountdecrease = false;

    public ZipfianGenerator(long items) {
        this(0L, items - 1L);
    }

    public ZipfianGenerator(long min, long max) {
        this(min, max, 0.99);
    }

    public ZipfianGenerator(long items, double zipfianconstant) {
        this(0L, items - 1L, zipfianconstant);
    }

    public ZipfianGenerator(long min, long max, double zipfianconstant) {
        this(min, max, zipfianconstant, ZipfianGenerator.zetastatic(max - min + 1L, zipfianconstant));
    }

    public ZipfianGenerator(long min, long max, double zipfianconstant, double zetan) {
        this.items = max - min + 1L;
        this.base = min;
        this.theta = this.zipfianconstant = zipfianconstant;
        this.zeta2theta = this.zeta(2L, this.theta);
        this.alpha = 1.0 / (1.0 - this.theta);
        this.zetan = zetan;
        this.countforzeta = this.items;
        this.eta = (1.0 - Math.pow(2.0 / (double)this.items, 1.0 - this.theta)) / (1.0 - this.zeta2theta / this.zetan);
        this.nextValue();
    }

    double zeta(long n, double thetaVal) {
        this.countforzeta = n;
        return ZipfianGenerator.zetastatic(n, thetaVal);
    }

    static double zetastatic(long n, double theta) {
        return ZipfianGenerator.zetastatic(0L, n, theta, 0.0);
    }

    double zeta(long st, long n, double thetaVal, double initialsum) {
        this.countforzeta = n;
        return ZipfianGenerator.zetastatic(st, n, thetaVal, initialsum);
    }

    static double zetastatic(long st, long n, double theta, double initialsum) {
        double sum = initialsum;
        for (long i = st; i < n; ++i) {
            sum += 1.0 / Math.pow(i + 1L, theta);
        }
        return sum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long nextLong(long itemcount) {
        double u;
        double uz;
        if (itemcount != this.countforzeta) {
            ZipfianGenerator zipfianGenerator = this;
            synchronized (zipfianGenerator) {
                if (itemcount > this.countforzeta) {
                    this.zetan = this.zeta(this.countforzeta, itemcount, this.theta, this.zetan);
                    this.eta = (1.0 - Math.pow(2.0 / (double)this.items, 1.0 - this.theta)) / (1.0 - this.zeta2theta / this.zetan);
                } else if (itemcount < this.countforzeta && this.allowitemcountdecrease) {
                    System.err.println("WARNING: Recomputing Zipfian distribtion. This is slow and should be avoided. (itemcount=" + itemcount + " countforzeta=" + this.countforzeta + ")");
                    this.zetan = this.zeta(itemcount, this.theta);
                    this.eta = (1.0 - Math.pow(2.0 / (double)this.items, 1.0 - this.theta)) / (1.0 - this.zeta2theta / this.zetan);
                }
            }
        }
        if ((uz = (u = ThreadLocalRandom.current().nextDouble()) * this.zetan) < 1.0) {
            return this.base;
        }
        if (uz < 1.0 + Math.pow(0.5, this.theta)) {
            return this.base + 1L;
        }
        long ret = this.base + (long)((double)itemcount * Math.pow(this.eta * u - this.eta + 1.0, this.alpha));
        this.setLastValue(ret);
        return ret;
    }

    @Override
    public Long nextValue() {
        return this.nextLong(this.items);
    }

    public static void main(String[] args) {
        new ZipfianGenerator(10000000000L);
    }

    @Override
    public double mean() {
        throw new UnsupportedOperationException("@todo implement ZipfianGenerator.mean()");
    }
}

