/*
 * Decompiled with CFR 0.152.
 */
package site.ycsb.generator;

import java.util.concurrent.TimeUnit;
import site.ycsb.generator.Generator;

public class UnixEpochTimestampGenerator
extends Generator<Long> {
    protected long startTimestamp;
    protected long currentTimestamp;
    protected long lastTimestamp;
    protected long interval;
    protected TimeUnit timeUnits;

    public UnixEpochTimestampGenerator() {
        this(60L, TimeUnit.SECONDS);
    }

    public UnixEpochTimestampGenerator(long interval, TimeUnit timeUnits) {
        this.interval = interval;
        this.timeUnits = timeUnits;
        this.initalizeTimestamp(-1L);
        this.currentTimestamp -= this.getOffset(1L);
        this.lastTimestamp = this.currentTimestamp;
    }

    public UnixEpochTimestampGenerator(long interval, TimeUnit timeUnits, long startTimestamp) {
        this.interval = interval;
        this.timeUnits = timeUnits;
        this.startTimestamp = this.currentTimestamp = startTimestamp - this.getOffset(1L);
        this.lastTimestamp = this.currentTimestamp - this.getOffset(1L);
    }

    public void initalizeTimestamp(long intervalOffset) {
        switch (this.timeUnits) {
            case NANOSECONDS: {
                this.currentTimestamp = System.nanoTime() + this.getOffset(intervalOffset);
                break;
            }
            case MICROSECONDS: {
                this.currentTimestamp = System.nanoTime() / 1000L + this.getOffset(intervalOffset);
                break;
            }
            case MILLISECONDS: {
                this.currentTimestamp = System.currentTimeMillis() + this.getOffset(intervalOffset);
                break;
            }
            case SECONDS: {
                this.currentTimestamp = System.currentTimeMillis() / 1000L + this.getOffset(intervalOffset);
                break;
            }
            case MINUTES: {
                this.currentTimestamp = System.currentTimeMillis() / 1000L + this.getOffset(intervalOffset);
                break;
            }
            case HOURS: {
                this.currentTimestamp = System.currentTimeMillis() / 1000L + this.getOffset(intervalOffset);
                break;
            }
            case DAYS: {
                this.currentTimestamp = System.currentTimeMillis() / 1000L + this.getOffset(intervalOffset);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unhandled time unit type: " + (Object)((Object)this.timeUnits));
            }
        }
        this.startTimestamp = this.currentTimestamp;
    }

    @Override
    public Long nextValue() {
        this.lastTimestamp = this.currentTimestamp;
        this.currentTimestamp += this.getOffset(1L);
        return this.currentTimestamp;
    }

    public long getOffset(long intervalOffset) {
        switch (this.timeUnits) {
            case NANOSECONDS: 
            case MICROSECONDS: 
            case MILLISECONDS: 
            case SECONDS: {
                return intervalOffset * this.interval;
            }
            case MINUTES: {
                return intervalOffset * this.interval * 60L;
            }
            case HOURS: {
                return intervalOffset * this.interval * 3600L;
            }
            case DAYS: {
                return intervalOffset * this.interval * 86400L;
            }
        }
        throw new IllegalArgumentException("Unhandled time unit type: " + (Object)((Object)this.timeUnits));
    }

    @Override
    public Long lastValue() {
        return this.lastTimestamp;
    }

    public long currentValue() {
        return this.currentTimestamp;
    }
}

