/*
 * Decompiled with CFR 0.152.
 */
package site.ycsb.generator;

import java.util.concurrent.atomic.AtomicLong;
import site.ycsb.generator.NumberGenerator;

public class SequentialGenerator
extends NumberGenerator {
    private final AtomicLong counter = new AtomicLong();
    private long interval;
    private long countstart;

    public SequentialGenerator(long countstart, long countend) {
        this.setLastValue(this.counter.get());
        this.countstart = countstart;
        this.interval = countend - countstart + 1L;
    }

    public long nextLong() {
        long ret = this.countstart + this.counter.getAndIncrement() % this.interval;
        this.setLastValue(ret);
        return ret;
    }

    @Override
    public Number nextValue() {
        long ret = this.countstart + this.counter.getAndIncrement() % this.interval;
        this.setLastValue(ret);
        return ret;
    }

    @Override
    public Number lastValue() {
        return this.counter.get() + 1L;
    }

    @Override
    public double mean() {
        throw new UnsupportedOperationException("Can't compute mean of non-stationary distribution!");
    }
}

