/*
 * Decompiled with CFR 0.152.
 */
package site.ycsb.generator;

import site.ycsb.Utils;
import site.ycsb.generator.NumberGenerator;
import site.ycsb.generator.ZipfianGenerator;

public class ScrambledZipfianGenerator
extends NumberGenerator {
    public static final double ZETAN = 26.46902820178302;
    public static final double USED_ZIPFIAN_CONSTANT = 0.99;
    public static final long ITEM_COUNT = 10000000000L;
    private ZipfianGenerator gen;
    private final long min;
    private final long max;
    private final long itemcount;

    public ScrambledZipfianGenerator(long items) {
        this(0L, items - 1L);
    }

    public ScrambledZipfianGenerator(long min, long max) {
        this(min, max, 0.99);
    }

    public ScrambledZipfianGenerator(long min, long max, double zipfianconstant) {
        this.min = min;
        this.max = max;
        this.itemcount = this.max - this.min + 1L;
        this.gen = zipfianconstant == 0.99 ? new ZipfianGenerator(0L, 10000000000L, zipfianconstant, 26.46902820178302) : new ZipfianGenerator(0L, 10000000000L, zipfianconstant);
    }

    @Override
    public Long nextValue() {
        long ret = this.gen.nextValue();
        ret = this.min + Utils.fnvhash64(ret) % this.itemcount;
        this.setLastValue(ret);
        return ret;
    }

    public static void main(String[] args) {
        double newzetan = ZipfianGenerator.zetastatic(10000000000L, 0.99);
        System.out.println("zetan: " + newzetan);
        System.exit(0);
        ScrambledZipfianGenerator gen = new ScrambledZipfianGenerator(10000L);
        for (int i = 0; i < 1000000; ++i) {
            System.out.println("" + gen.nextValue());
        }
    }

    @Override
    public double mean() {
        return (double)(this.min + this.max) / 2.0;
    }
}

