/*
 * Decompiled with CFR 0.152.
 */
package site.ycsb.generator;

import java.util.concurrent.TimeUnit;
import site.ycsb.Utils;
import site.ycsb.generator.UnixEpochTimestampGenerator;

public class RandomDiscreteTimestampGenerator
extends UnixEpochTimestampGenerator {
    public static final int MAX_INTERVALS = 0x1000000;
    private final int intervals;
    private final Integer[] offsets;
    private int offsetIndex;

    public RandomDiscreteTimestampGenerator(long interval, TimeUnit timeUnits, int intervals) {
        super(interval, timeUnits);
        this.intervals = intervals;
        this.offsets = new Integer[intervals];
        this.setup();
    }

    public RandomDiscreteTimestampGenerator(long interval, TimeUnit timeUnits, long startTimestamp, int intervals) {
        super(interval, timeUnits, startTimestamp);
        this.intervals = intervals;
        this.offsets = new Integer[intervals];
        this.setup();
    }

    private void setup() {
        if (this.intervals > 0x1000000) {
            throw new IllegalArgumentException("Too many intervals for the in-memory array. The limit is 16777216.");
        }
        this.offsetIndex = 0;
        for (int i = 0; i < this.intervals; ++i) {
            this.offsets[i] = i;
        }
        Utils.shuffleArray(this.offsets);
    }

    @Override
    public Long nextValue() {
        if (this.offsetIndex >= this.offsets.length) {
            throw new IllegalStateException("Reached the end of the random timestamp intervals: " + this.offsetIndex);
        }
        this.lastTimestamp = this.currentTimestamp;
        this.currentTimestamp = this.startTimestamp + (long)this.offsets[this.offsetIndex++].intValue() * this.getOffset(1L);
        return this.currentTimestamp;
    }
}

