/*
 * Decompiled with CFR 0.152.
 */
package site.ycsb.generator;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import site.ycsb.generator.Generator;

public class IncrementingPrintableStringGenerator
extends Generator<String> {
    public static final int DEFAULTSTRINGLENGTH = 8;
    public static final Set<Integer> CHAR_TYPES_ALL_BUT_CONTROL = new HashSet<Integer>(24);
    public static final Set<Integer> CHAR_TYPES_BASIC_ALPHA;
    public static final Set<Integer> CHAR_TYPES_BASIC_ALPHANUMERICS;
    public static final Set<Integer> CHAR_TYPE_EXTENDED_ALPHANUMERICS;
    private final int[] characterSet;
    private int[] indices;
    private final int length;
    private String lastValue;
    private boolean throwExceptionOnRollover;
    private boolean hasRolledOver;

    public IncrementingPrintableStringGenerator() {
        this(8, IncrementingPrintableStringGenerator.printableBasicAlphaASCIISet());
    }

    public IncrementingPrintableStringGenerator(int length) {
        this(length, IncrementingPrintableStringGenerator.printableBasicAlphaASCIISet());
    }

    public IncrementingPrintableStringGenerator(int length, int[] characterSet) {
        if (length < 1) {
            throw new IllegalArgumentException("Length must be greater than or equal to 1");
        }
        if (characterSet == null || characterSet.length < 1) {
            throw new IllegalArgumentException("Character set must have at least one character");
        }
        this.length = length;
        this.characterSet = characterSet;
        this.indices = new int[length];
    }

    @Override
    public String nextValue() {
        int i;
        if (this.hasRolledOver && this.throwExceptionOnRollover) {
            throw new NoSuchElementException("The generator has rolled over to the beginning");
        }
        StringBuilder buffer = new StringBuilder(this.length);
        for (i = 0; i < this.length; ++i) {
            buffer.append(Character.toChars(this.characterSet[this.indices[i]]));
        }
        for (i = this.length - 1; i >= 0; --i) {
            if (this.indices[i] >= this.characterSet.length - 1) {
                this.indices[i] = 0;
                if (i != 0 && (this.characterSet.length != 1 || this.lastValue == null)) continue;
                this.hasRolledOver = true;
                continue;
            }
            int n = i;
            this.indices[n] = this.indices[n] + 1;
            break;
        }
        this.lastValue = buffer.toString();
        return this.lastValue;
    }

    @Override
    public String lastValue() {
        return this.lastValue;
    }

    public void setThrowExceptionOnRollover(boolean exceptionOnRollover) {
        this.throwExceptionOnRollover = exceptionOnRollover;
    }

    public boolean getThrowExceptionOnRollover() {
        return this.throwExceptionOnRollover;
    }

    public static int[] printableBasicAlphaASCIISet() {
        List<Integer> validCharacters = IncrementingPrintableStringGenerator.generatePrintableCharacterSet(0, 127, null, false, CHAR_TYPES_BASIC_ALPHA);
        int[] characterSet = new int[validCharacters.size()];
        for (int i = 0; i < validCharacters.size(); ++i) {
            characterSet[i] = validCharacters.get(i);
        }
        return characterSet;
    }

    public static int[] printableBasicAlphaNumericASCIISet() {
        List<Integer> validCharacters = IncrementingPrintableStringGenerator.generatePrintableCharacterSet(0, 127, null, false, CHAR_TYPES_BASIC_ALPHANUMERICS);
        int[] characterSet = new int[validCharacters.size()];
        for (int i = 0; i < validCharacters.size(); ++i) {
            characterSet[i] = validCharacters.get(i);
        }
        return characterSet;
    }

    public static int[] fullPrintableBasicASCIISet() {
        List<Integer> validCharacters = IncrementingPrintableStringGenerator.generatePrintableCharacterSet(32, 127, null, false, null);
        int[] characterSet = new int[validCharacters.size()];
        for (int i = 0; i < validCharacters.size(); ++i) {
            characterSet[i] = validCharacters.get(i);
        }
        return characterSet;
    }

    public static int[] fullPrintableBasicASCIISetWithNewlines() {
        ArrayList<Integer> validCharacters = new ArrayList<Integer>();
        validCharacters.add(10);
        validCharacters.addAll(IncrementingPrintableStringGenerator.generatePrintableCharacterSet(32, 127, null, false, null));
        int[] characterSet = new int[validCharacters.size()];
        for (int i = 0; i < validCharacters.size(); ++i) {
            characterSet[i] = (Integer)validCharacters.get(i);
        }
        return characterSet;
    }

    public static int[] printableAlphaNumericPlaneZeroSet() {
        List<Integer> validCharacters = IncrementingPrintableStringGenerator.generatePrintableCharacterSet(0, 65535, null, false, CHAR_TYPES_BASIC_ALPHANUMERICS);
        int[] characterSet = new int[validCharacters.size()];
        for (int i = 0; i < validCharacters.size(); ++i) {
            characterSet[i] = validCharacters.get(i);
        }
        return characterSet;
    }

    public static int[] fullPrintablePlaneZeroSet() {
        List<Integer> validCharacters = IncrementingPrintableStringGenerator.generatePrintableCharacterSet(0, 65535, null, false, CHAR_TYPES_ALL_BUT_CONTROL);
        int[] characterSet = new int[validCharacters.size()];
        for (int i = 0; i < validCharacters.size(); ++i) {
            characterSet[i] = validCharacters.get(i);
        }
        return characterSet;
    }

    public static List<Integer> generatePrintableCharacterSet(int startCodePoint, int lastCodePoint, Set<Integer> characterTypesFilter, boolean isFilterAllowableList, Set<Integer> allowableTypes) {
        ArrayList<Integer> validCharacters = new ArrayList<Integer>(lastCodePoint);
        for (int codePoint = startCodePoint; codePoint <= lastCodePoint; ++codePoint) {
            int type;
            if (allowableTypes != null && !allowableTypes.contains(Character.getType(codePoint)) || (type = Character.getType(codePoint)) == 15 || type == 19 || type == 16 || type == 18 || type == 0 || characterTypesFilter != null && (isFilterAllowableList && !characterTypesFilter.contains(codePoint) || characterTypesFilter.contains(codePoint))) continue;
            validCharacters.add(codePoint);
        }
        return validCharacters;
    }

    static {
        CHAR_TYPES_ALL_BUT_CONTROL.add(9);
        CHAR_TYPES_ALL_BUT_CONTROL.add(10);
        CHAR_TYPES_ALL_BUT_CONTROL.add(11);
        CHAR_TYPES_ALL_BUT_CONTROL.add(1);
        CHAR_TYPES_ALL_BUT_CONTROL.add(2);
        CHAR_TYPES_ALL_BUT_CONTROL.add(3);
        CHAR_TYPES_ALL_BUT_CONTROL.add(5);
        CHAR_TYPES_ALL_BUT_CONTROL.add(8);
        CHAR_TYPES_ALL_BUT_CONTROL.add(6);
        CHAR_TYPES_ALL_BUT_CONTROL.add(7);
        CHAR_TYPES_ALL_BUT_CONTROL.add(23);
        CHAR_TYPES_ALL_BUT_CONTROL.add(20);
        CHAR_TYPES_ALL_BUT_CONTROL.add(21);
        CHAR_TYPES_ALL_BUT_CONTROL.add(22);
        CHAR_TYPES_ALL_BUT_CONTROL.add(29);
        CHAR_TYPES_ALL_BUT_CONTROL.add(30);
        CHAR_TYPES_ALL_BUT_CONTROL.add(24);
        CHAR_TYPES_ALL_BUT_CONTROL.add(25);
        CHAR_TYPES_ALL_BUT_CONTROL.add(26);
        CHAR_TYPES_ALL_BUT_CONTROL.add(27);
        CHAR_TYPES_ALL_BUT_CONTROL.add(28);
        CHAR_TYPES_ALL_BUT_CONTROL.add(12);
        CHAR_TYPES_ALL_BUT_CONTROL.add(13);
        CHAR_TYPES_ALL_BUT_CONTROL.add(14);
        CHAR_TYPES_BASIC_ALPHA = new HashSet<Integer>(2);
        CHAR_TYPES_BASIC_ALPHA.add(1);
        CHAR_TYPES_BASIC_ALPHA.add(2);
        CHAR_TYPES_BASIC_ALPHANUMERICS = new HashSet<Integer>(3);
        CHAR_TYPES_BASIC_ALPHANUMERICS.add(9);
        CHAR_TYPES_BASIC_ALPHANUMERICS.add(1);
        CHAR_TYPES_BASIC_ALPHANUMERICS.add(2);
        CHAR_TYPE_EXTENDED_ALPHANUMERICS = new HashSet<Integer>(8);
        CHAR_TYPE_EXTENDED_ALPHANUMERICS.add(9);
        CHAR_TYPE_EXTENDED_ALPHANUMERICS.add(10);
        CHAR_TYPE_EXTENDED_ALPHANUMERICS.add(11);
        CHAR_TYPE_EXTENDED_ALPHANUMERICS.add(1);
        CHAR_TYPE_EXTENDED_ALPHANUMERICS.add(2);
        CHAR_TYPE_EXTENDED_ALPHANUMERICS.add(3);
        CHAR_TYPE_EXTENDED_ALPHANUMERICS.add(4);
        CHAR_TYPE_EXTENDED_ALPHANUMERICS.add(5);
    }
}

