/*
 * Decompiled with CFR 0.152.
 */
package site.ycsb.generator;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ThreadLocalRandom;
import site.ycsb.generator.NumberGenerator;

public class HistogramGenerator
extends NumberGenerator {
    private final long blockSize;
    private final long[] buckets;
    private long area;
    private long weightedArea = 0L;
    private double meanSize = 0.0;

    public HistogramGenerator(String histogramfile) throws IOException {
        try (BufferedReader in = new BufferedReader(new FileReader(histogramfile));){
            ArrayList<Integer> a = new ArrayList<Integer>();
            String str = in.readLine();
            if (str == null) {
                throw new IOException("Empty input file!\n");
            }
            String[] line = str.split("\t");
            if (line[0].compareTo("BlockSize") != 0) {
                throw new IOException("First line of histogram is not the BlockSize!\n");
            }
            this.blockSize = Integer.parseInt(line[1]);
            while ((str = in.readLine()) != null) {
                line = str.split("\t");
                a.add(Integer.parseInt(line[0]), Integer.parseInt(line[1]));
            }
            this.buckets = new long[a.size()];
            for (int i = 0; i < a.size(); ++i) {
                this.buckets[i] = ((Integer)a.get(i)).intValue();
            }
        }
        this.init();
    }

    public HistogramGenerator(long[] buckets, int blockSize) {
        this.blockSize = blockSize;
        this.buckets = buckets;
        this.init();
    }

    private void init() {
        for (int i = 0; i < this.buckets.length; ++i) {
            this.area += this.buckets[i];
            this.weightedArea += (long)i * this.buckets[i];
        }
        this.meanSize = (double)this.blockSize * (double)this.weightedArea / (double)this.area;
    }

    @Override
    public Long nextValue() {
        int i;
        int number = ThreadLocalRandom.current().nextInt((int)this.area);
        for (i = 0; i < this.buckets.length - 1; ++i) {
            if ((number = (int)((long)number - this.buckets[i])) > 0) continue;
            return (long)(i + 1) * this.blockSize;
        }
        return (long)i * this.blockSize;
    }

    @Override
    public double mean() {
        return this.meanSize;
    }
}

