/*
 * Decompiled with CFR 0.152.
 */
package site.ycsb.generator;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import site.ycsb.generator.Generator;

public class FileGenerator
extends Generator<String> {
    private final String filename;
    private String current;
    private BufferedReader reader;

    public FileGenerator(String filename) {
        this.filename = filename;
        this.reloadFile();
    }

    @Override
    public synchronized String nextValue() {
        try {
            this.current = this.reader.readLine();
            return this.current;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String lastValue() {
        return this.current;
    }

    public synchronized void reloadFile() {
        try (BufferedReader r = this.reader;){
            System.err.println("Reload " + this.filename);
            this.reader = new BufferedReader(new FileReader(this.filename));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

