/*
 * Decompiled with CFR 0.152.
 */
package site.ycsb.generator;

import java.util.concurrent.ThreadLocalRandom;
import site.ycsb.generator.NumberGenerator;

public class ExponentialGenerator
extends NumberGenerator {
    public static final String EXPONENTIAL_PERCENTILE_PROPERTY = "exponential.percentile";
    public static final String EXPONENTIAL_PERCENTILE_DEFAULT = "95";
    public static final String EXPONENTIAL_FRAC_PROPERTY = "exponential.frac";
    public static final String EXPONENTIAL_FRAC_DEFAULT = "0.8571428571";
    private double gamma;

    public ExponentialGenerator(double mean) {
        this.gamma = 1.0 / mean;
    }

    public ExponentialGenerator(double percentile, double range) {
        this.gamma = -Math.log(1.0 - percentile / 100.0) / range;
    }

    @Override
    public Double nextValue() {
        return -Math.log(ThreadLocalRandom.current().nextDouble()) / this.gamma;
    }

    @Override
    public double mean() {
        return 1.0 / this.gamma;
    }

    public static void main(String[] args) {
        ExponentialGenerator e = new ExponentialGenerator(90.0, 100.0);
        int j = 0;
        for (int i = 0; i < 1000; ++i) {
            if (!(e.nextValue() < 100.0)) continue;
            ++j;
        }
        System.out.println("Got " + j + " hits.  Expect 900");
    }
}

