/*
 * Decompiled with CFR 0.152.
 */
package site.ycsb.generator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import site.ycsb.generator.Generator;

public class DiscreteGenerator
extends Generator<String> {
    private final Collection<Pair> values = new ArrayList<Pair>();
    private String lastvalue = null;

    @Override
    public String nextValue() {
        double sum = 0.0;
        for (Pair p : this.values) {
            sum += p.weight;
        }
        double val = ThreadLocalRandom.current().nextDouble();
        for (Pair p : this.values) {
            double pw = p.weight / sum;
            if (val < pw) {
                return p.value;
            }
            val -= pw;
        }
        throw new AssertionError((Object)"oops. should not get here.");
    }

    @Override
    public String lastValue() {
        if (this.lastvalue == null) {
            this.lastvalue = this.nextValue();
        }
        return this.lastvalue;
    }

    public void addValue(double weight, String value) {
        this.values.add(new Pair(weight, value));
    }

    private static class Pair {
        private double weight;
        private String value;

        Pair(double weight, String value) {
            this.weight = weight;
            this.value = Objects.requireNonNull(value);
        }
    }
}

