/*
 * Decompiled with CFR 0.152.
 */
package site.ycsb.generator;

import java.util.concurrent.locks.ReentrantLock;
import site.ycsb.generator.CounterGenerator;

public class AcknowledgedCounterGenerator
extends CounterGenerator {
    static final int WINDOW_SIZE = Integer.rotateLeft(1, 20);
    private static final int WINDOW_MASK = WINDOW_SIZE - 1;
    private final ReentrantLock lock = new ReentrantLock();
    private final boolean[] window = new boolean[WINDOW_SIZE];
    private volatile long limit;

    public AcknowledgedCounterGenerator(long countstart) {
        super(countstart);
        this.limit = countstart - 1L;
    }

    @Override
    public Long lastValue() {
        return this.limit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledge(long value) {
        int currentSlot = (int)(value & (long)WINDOW_MASK);
        if (this.window[currentSlot]) {
            throw new RuntimeException("Too many unacknowledged insertion keys.");
        }
        this.window[currentSlot] = true;
        if (this.lock.tryLock()) {
            try {
                int slot;
                long index;
                long beforeFirstSlot = this.limit & (long)WINDOW_MASK;
                for (index = this.limit + 1L; index != beforeFirstSlot && this.window[slot = (int)(index & (long)WINDOW_MASK)]; ++index) {
                    this.window[slot] = false;
                }
                this.limit = index - 1L;
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

