/*
 * Decompiled with CFR 0.152.
 */
package site.ycsb;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;

public final class Utils {
    public static final long FNV_OFFSET_BASIS_64 = -3750763034362895579L;
    public static final long FNV_PRIME_64 = 1099511628211L;

    private Utils() {
    }

    public static long hash(long val) {
        return Utils.fnvhash64(val);
    }

    public static long fnvhash64(long val) {
        long hashval = -3750763034362895579L;
        for (int i = 0; i < 8; ++i) {
            long octet = val & 0xFFL;
            val >>= 8;
            hashval ^= octet;
            hashval *= 1099511628211L;
        }
        return Math.abs(hashval);
    }

    public static long bytesToLong(byte[] bytes) {
        return ((long)bytes[0] & 0xFFL) << 56 | ((long)bytes[1] & 0xFFL) << 48 | ((long)bytes[2] & 0xFFL) << 40 | ((long)bytes[3] & 0xFFL) << 32 | ((long)bytes[4] & 0xFFL) << 24 | ((long)bytes[5] & 0xFFL) << 16 | ((long)bytes[6] & 0xFFL) << 8 | ((long)bytes[7] & 0xFFL) << 0;
    }

    public static byte[] longToBytes(long val) {
        byte[] bytes = new byte[]{(byte)(val >>> 56), (byte)(val >>> 48), (byte)(val >>> 40), (byte)(val >>> 32), (byte)(val >>> 24), (byte)(val >>> 16), (byte)(val >>> 8), (byte)(val >>> 0)};
        return bytes;
    }

    public static double bytesToDouble(byte[] bytes) {
        if (bytes.length < 8) {
            throw new IllegalArgumentException("Byte array must be 8 bytes wide.");
        }
        return Double.longBitsToDouble(Utils.bytesToLong(bytes));
    }

    public static byte[] doubleToBytes(double val) {
        return Utils.longToBytes(Double.doubleToRawLongBits(val));
    }

    public static int getActiveThreadCount() {
        return Thread.activeCount();
    }

    public static long getUsedMemoryBytes() {
        Runtime runtime = Runtime.getRuntime();
        return runtime.totalMemory() - runtime.freeMemory();
    }

    public static int getUsedMemoryMegaBytes() {
        return (int)(Utils.getUsedMemoryBytes() / 1024L / 1024L);
    }

    public static double getSystemLoadAverage() {
        OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
        return osBean.getSystemLoadAverage();
    }

    public static long getGCTotalCollectionCount() {
        List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
        long count = 0L;
        for (GarbageCollectorMXBean bean : gcBeans) {
            if (bean.getCollectionCount() < 0L) continue;
            count += bean.getCollectionCount();
        }
        return count;
    }

    public static long getGCTotalTime() {
        List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
        long time = 0L;
        for (GarbageCollectorMXBean bean : gcBeans) {
            if (bean.getCollectionTime() < 0L) continue;
            time += bean.getCollectionTime();
        }
        return time;
    }

    public static Map<String, Long[]> getGCStatst() {
        List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
        HashMap<String, Long[]> map = new HashMap<String, Long[]>(gcBeans.size());
        for (GarbageCollectorMXBean bean : gcBeans) {
            if (!bean.isValid() || bean.getCollectionCount() < 0L || bean.getCollectionTime() < 0L) continue;
            Long[] measurements = new Long[]{bean.getCollectionCount(), bean.getCollectionTime()};
            map.put(bean.getName().replace(" ", "_"), measurements);
        }
        return map;
    }

    public static <T> T[] shuffleArray(T[] array) {
        for (int i = array.length - 1; i > 0; --i) {
            int idx = ThreadLocalRandom.current().nextInt(i + 1);
            T temp = array[idx];
            array[idx] = array[i];
            array[i] = temp;
        }
        return array;
    }
}

