/*
 * Decompiled with CFR 0.152.
 */
package site.ycsb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import site.ycsb.ByteIterator;
import site.ycsb.DB;
import site.ycsb.DBException;
import site.ycsb.NumericByteIterator;
import site.ycsb.Status;
import site.ycsb.generator.Generator;
import site.ycsb.generator.IncrementingPrintableStringGenerator;

public abstract class TimeseriesDB
extends DB {
    private static final String DOWNSAMPLING_FUNCTION_PROPERTY_DEFAULT = "NONE";
    private static final String DOWNSAMPLING_INTERVAL_PROPERTY_DEFAULT = "0";
    private static final String DEBUG_PROPERTY = "debug";
    private static final String DEBUG_PROPERTY_DEFAULT = "false";
    private static final String TEST_PROPERTY = "test";
    private static final String TEST_PROPERTY_DEFAULT = "false";
    protected String timestampKey;
    protected String valueKey;
    protected String tagPairDelimiter;
    protected String queryTimeSpanDelimiter;
    protected String deleteDelimiter;
    protected TimeUnit timestampUnit;
    protected String groupByKey;
    protected String downsamplingKey;
    protected Integer downsamplingInterval;
    protected AggregationOperation downsamplingFunction;
    protected boolean debug;
    protected boolean test;

    @Override
    public void init() throws DBException {
        this.timestampKey = this.getProperties().getProperty("timestampkey", "YCSBTS");
        this.valueKey = this.getProperties().getProperty("valuekey", "YCSBV");
        this.tagPairDelimiter = this.getProperties().getProperty("tagpairdelimiter", "=");
        this.queryTimeSpanDelimiter = this.getProperties().getProperty("querytimespandelimiter", ",");
        this.deleteDelimiter = this.getProperties().getProperty("deletedelimiter", ":");
        this.timestampUnit = TimeUnit.valueOf(this.getProperties().getProperty("timestampunits", "SECONDS"));
        this.groupByKey = this.getProperties().getProperty("groupbykey", "YCSBGB");
        this.downsamplingKey = this.getProperties().getProperty("downsamplingkey", "YCSBDS");
        this.downsamplingFunction = AggregationOperation.valueOf(this.getProperties().getProperty("downsamplingfunction", DOWNSAMPLING_FUNCTION_PROPERTY_DEFAULT));
        this.downsamplingInterval = Integer.valueOf(this.getProperties().getProperty("downsamplinginterval", DOWNSAMPLING_INTERVAL_PROPERTY_DEFAULT));
        this.test = Boolean.parseBoolean(this.getProperties().getProperty(TEST_PROPERTY, "false"));
        this.debug = Boolean.parseBoolean(this.getProperties().getProperty(DEBUG_PROPERTY, "false"));
    }

    @Override
    public final Status read(String table, String key, Set<String> fields, Map<String, ByteIterator> result) {
        HashMap<String, List<String>> tagQueries = new HashMap<String, List<String>>();
        Long timestamp = null;
        for (String field : fields) {
            if (field.startsWith(this.timestampKey)) {
                String[] timestampParts = field.split(this.tagPairDelimiter);
                if (timestampParts[1].contains(this.queryTimeSpanDelimiter)) {
                    return Status.BAD_REQUEST;
                }
                timestamp = Long.valueOf(timestampParts[1]);
                continue;
            }
            String[] queryParts = field.split(this.tagPairDelimiter);
            tagQueries.computeIfAbsent(queryParts[0], k -> new ArrayList()).add(queryParts[1]);
        }
        if (timestamp == null) {
            return Status.BAD_REQUEST;
        }
        return this.read(table, timestamp, tagQueries);
    }

    protected abstract Status read(String var1, long var2, Map<String, List<String>> var4);

    @Override
    public final Status scan(String table, String startkey, int recordcount, Set<String> fields, Vector<HashMap<String, ByteIterator>> result) {
        HashMap<String, List<String>> tagQueries = new HashMap<String, List<String>>();
        AggregationOperation aggregationOperation = AggregationOperation.NONE;
        HashSet<String> groupByFields = new HashSet<String>();
        boolean rangeSet = false;
        long start = 0L;
        long end = 0L;
        for (String field : fields) {
            if (field.startsWith(this.timestampKey)) {
                String[] timestampParts = field.split(this.tagPairDelimiter);
                if (!timestampParts[1].contains(this.queryTimeSpanDelimiter)) {
                    return Status.NOT_IMPLEMENTED;
                }
                String[] rangeParts = timestampParts[1].split(this.queryTimeSpanDelimiter);
                rangeSet = true;
                start = Long.valueOf(rangeParts[0]);
                end = Long.valueOf(rangeParts[1]);
                continue;
            }
            if (field.startsWith(this.groupByKey)) {
                String groupBySpecifier = field.split(this.tagPairDelimiter)[1];
                aggregationOperation = AggregationOperation.valueOf(groupBySpecifier);
                continue;
            }
            if (field.startsWith(this.downsamplingKey)) {
                String downsamplingSpec = field.split(this.tagPairDelimiter)[1];
                if (downsamplingSpec.equals(this.downsamplingFunction.toString() + this.downsamplingInterval.toString())) continue;
                System.err.print("Downsampling specification for Scan did not match configured downsampling");
                return Status.BAD_REQUEST;
            }
            String[] queryParts = field.split(this.tagPairDelimiter);
            if (queryParts.length == 1) {
                System.err.println("Grouping by arbitrary series is currently not supported");
                groupByFields.add(field);
                continue;
            }
            tagQueries.computeIfAbsent(queryParts[0], k -> new ArrayList()).add(queryParts[1]);
        }
        if (!rangeSet) {
            return Status.BAD_REQUEST;
        }
        return this.scan(table, start, end, tagQueries, this.downsamplingFunction, this.downsamplingInterval, this.timestampUnit);
    }

    protected abstract Status scan(String var1, long var2, long var4, Map<String, List<String>> var6, AggregationOperation var7, int var8, TimeUnit var9);

    @Override
    public Status update(String table, String key, Map<String, ByteIterator> values) {
        return Status.NOT_IMPLEMENTED;
    }

    @Override
    public final Status insert(String table, String key, Map<String, ByteIterator> values) {
        NumericByteIterator tsContainer = (NumericByteIterator)values.remove(this.timestampKey);
        NumericByteIterator valueContainer = (NumericByteIterator)values.remove(this.valueKey);
        if (valueContainer.isFloatingPoint()) {
            return this.insert(table, tsContainer.getLong(), valueContainer.getDouble(), values);
        }
        return this.insert(table, tsContainer.getLong(), valueContainer.getLong(), values);
    }

    protected abstract Status insert(String var1, long var2, long var4, Map<String, ByteIterator> var6);

    protected abstract Status insert(String var1, long var2, double var4, Map<String, ByteIterator> var6);

    @Override
    public Status delete(String table, String key) {
        return Status.NOT_IMPLEMENTED;
    }

    protected static String[] getPossibleTagKeys(Properties properties) {
        int tagCount = Integer.parseInt(properties.getProperty("tagcount", "4"));
        int tagKeylength = Integer.parseInt(properties.getProperty("tagkeylength", "8"));
        IncrementingPrintableStringGenerator tagKeyGenerator = new IncrementingPrintableStringGenerator(tagKeylength);
        String[] tagNames = new String[tagCount];
        for (int i = 0; i < tagCount; ++i) {
            tagNames[i] = (String)((Generator)tagKeyGenerator).nextValue();
        }
        return tagNames;
    }

    public static enum AggregationOperation {
        NONE,
        SUM,
        AVERAGE,
        COUNT,
        MAX,
        MIN;

    }
}

