/*
 * Decompiled with CFR 0.152.
 */
package site.ycsb;

import java.util.Collection;
import site.ycsb.Workload;

public class TerminatorThread
extends Thread {
    private final Collection<? extends Thread> threads;
    private long maxExecutionTime;
    private Workload workload;
    private long waitTimeOutInMS;

    public TerminatorThread(long maxExecutionTime, Collection<? extends Thread> threads, Workload workload) {
        this.maxExecutionTime = maxExecutionTime;
        this.threads = threads;
        this.workload = workload;
        this.waitTimeOutInMS = 2000L;
        System.err.println("Maximum execution time specified as: " + maxExecutionTime + " secs");
    }

    @Override
    public void run() {
        try {
            Thread.sleep(this.maxExecutionTime * 1000L);
        }
        catch (InterruptedException e) {
            System.err.println("Could not wait until max specified time, TerminatorThread interrupted.");
            return;
        }
        System.err.println("Maximum time elapsed. Requesting stop for the workload.");
        this.workload.requestStop();
        System.err.println("Stop requested for workload. Now Joining!");
        for (Thread thread : this.threads) {
            while (thread.isAlive()) {
                try {
                    thread.join(this.waitTimeOutInMS);
                    if (!thread.isAlive()) continue;
                    System.out.println("Still waiting for thread " + thread.getName() + " to complete. Workload status: " + this.workload.isStopRequested());
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

