/*
 * Decompiled with CFR 0.152.
 */
package site.ycsb;

import java.util.HashMap;
import java.util.Map;
import site.ycsb.ByteIterator;

public class StringByteIterator
extends ByteIterator {
    private String str;
    private int off;

    public static void putAllAsByteIterators(Map<String, ByteIterator> out, Map<String, String> in) {
        for (Map.Entry<String, String> entry : in.entrySet()) {
            out.put(entry.getKey(), new StringByteIterator(entry.getValue()));
        }
    }

    public static void putAllAsStrings(Map<String, String> out, Map<String, ByteIterator> in) {
        for (Map.Entry<String, ByteIterator> entry : in.entrySet()) {
            out.put(entry.getKey(), entry.getValue().toString());
        }
    }

    public static Map<String, ByteIterator> getByteIteratorMap(Map<String, String> m) {
        HashMap<String, ByteIterator> ret = new HashMap<String, ByteIterator>();
        for (Map.Entry<String, String> entry : m.entrySet()) {
            ret.put(entry.getKey(), new StringByteIterator(entry.getValue()));
        }
        return ret;
    }

    public static Map<String, String> getStringMap(Map<String, ByteIterator> m) {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (Map.Entry<String, ByteIterator> entry : m.entrySet()) {
            ret.put(entry.getKey(), entry.getValue().toString());
        }
        return ret;
    }

    public StringByteIterator(String s) {
        this.str = s;
        this.off = 0;
    }

    @Override
    public boolean hasNext() {
        return this.off < this.str.length();
    }

    @Override
    public byte nextByte() {
        byte ret = (byte)this.str.charAt(this.off);
        ++this.off;
        return ret;
    }

    @Override
    public long bytesLeft() {
        return this.str.length() - this.off;
    }

    @Override
    public void reset() {
        this.off = 0;
    }

    @Override
    public byte[] toArray() {
        byte[] bytes = new byte[(int)this.bytesLeft()];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)this.str.charAt(this.off + i);
        }
        this.off = this.str.length();
        return bytes;
    }

    @Override
    public String toString() {
        if (this.off > 0) {
            return super.toString();
        }
        return this.str;
    }
}

