/*
 * Decompiled with CFR 0.152.
 */
package site.ycsb;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import site.ycsb.ClientThread;
import site.ycsb.RemainingFormatter;
import site.ycsb.Utils;
import site.ycsb.measurements.Measurements;

public class StatusThread
extends Thread {
    private final CountDownLatch completeLatch;
    private final Measurements measurements;
    private final boolean trackJVMStats;
    private final List<ClientThread> clients;
    private final String label;
    private final boolean standardstatus;
    private long sleeptimeNs;
    private int maxThreads;
    private int minThreads = Integer.MAX_VALUE;
    private long maxUsedMem;
    private long minUsedMem = Long.MAX_VALUE;
    private double maxLoadAvg;
    private double minLoadAvg = Double.MAX_VALUE;
    private long lastGCCount = 0L;
    private long lastGCTime = 0L;

    public StatusThread(CountDownLatch completeLatch, List<ClientThread> clients, String label, boolean standardstatus, int statusIntervalSeconds) {
        this(completeLatch, clients, label, standardstatus, statusIntervalSeconds, false);
    }

    public StatusThread(CountDownLatch completeLatch, List<ClientThread> clients, String label, boolean standardstatus, int statusIntervalSeconds, boolean trackJVMStats) {
        this.completeLatch = completeLatch;
        this.clients = clients;
        this.label = label;
        this.standardstatus = standardstatus;
        this.sleeptimeNs = TimeUnit.SECONDS.toNanos(statusIntervalSeconds);
        this.measurements = Measurements.getMeasurements();
        this.trackJVMStats = trackJVMStats;
    }

    @Override
    public void run() {
        boolean alldone;
        long startTimeMs = System.currentTimeMillis();
        long startTimeNanos = System.nanoTime();
        long deadline = startTimeNanos + this.sleeptimeNs;
        long startIntervalMs = startTimeMs;
        long lastTotalOps = 0L;
        do {
            long nowMs = System.currentTimeMillis();
            lastTotalOps = this.computeStats(startTimeMs, startIntervalMs, nowMs, lastTotalOps);
            if (this.trackJVMStats) {
                this.measureJVM();
            }
            alldone = this.waitForClientsUntil(deadline);
            startIntervalMs = nowMs;
            deadline += this.sleeptimeNs;
        } while (!alldone);
        if (this.trackJVMStats) {
            this.measureJVM();
        }
        this.computeStats(startTimeMs, startIntervalMs, System.currentTimeMillis(), lastTotalOps);
    }

    private long computeStats(long startTimeMs, long startIntervalMs, long endIntervalMs, long lastTotalOps) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
        long totalops = 0L;
        long todoops = 0L;
        for (ClientThread t : this.clients) {
            totalops += (long)t.getOpsDone();
            todoops += (long)t.getOpsTodo();
        }
        long interval = endIntervalMs - startTimeMs;
        double throughput = 1000.0 * ((double)totalops / (double)interval);
        double curthroughput = 1000.0 * ((double)(totalops - lastTotalOps) / (double)(endIntervalMs - startIntervalMs));
        long estremaining = (long)Math.ceil((double)todoops / throughput);
        DecimalFormat d = new DecimalFormat("#.##");
        String labelString = this.label + format.format(new Date());
        StringBuilder msg = new StringBuilder(labelString).append(" ").append(interval / 1000L).append(" sec: ");
        msg.append(totalops).append(" operations; ");
        if (totalops != 0L) {
            msg.append(d.format(curthroughput)).append(" current ops/sec; ");
        }
        if (todoops != 0L) {
            msg.append("est completion in ").append((CharSequence)RemainingFormatter.format(estremaining));
        }
        msg.append(Measurements.getMeasurements().getSummary());
        System.err.println(msg);
        if (this.standardstatus) {
            System.out.println(msg);
        }
        return totalops;
    }

    private boolean waitForClientsUntil(long deadline) {
        boolean alldone = false;
        long now = System.nanoTime();
        while (!alldone && now < deadline) {
            try {
                alldone = this.completeLatch.await(deadline - now, TimeUnit.NANOSECONDS);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                alldone = true;
            }
            now = System.nanoTime();
        }
        return alldone;
    }

    private void measureJVM() {
        int threads = Utils.getActiveThreadCount();
        if (threads < this.minThreads) {
            this.minThreads = threads;
        }
        if (threads > this.maxThreads) {
            this.maxThreads = threads;
        }
        this.measurements.measure("THREAD_COUNT", threads);
        int usedMem = Utils.getUsedMemoryMegaBytes();
        if ((long)usedMem < this.minUsedMem) {
            this.minUsedMem = usedMem;
        }
        if ((long)usedMem > this.maxUsedMem) {
            this.maxUsedMem = usedMem;
        }
        this.measurements.measure("USED_MEM_MB", usedMem);
        double systemLoad = Utils.getSystemLoadAverage();
        if (systemLoad >= 0.0) {
            this.measurements.measure("SYS_LOAD_AVG", (int)systemLoad);
            if (systemLoad > this.maxLoadAvg) {
                this.maxLoadAvg = systemLoad;
            }
            if (systemLoad < this.minLoadAvg) {
                this.minLoadAvg = systemLoad;
            }
        }
        long gcs = Utils.getGCTotalCollectionCount();
        this.measurements.measure("GCS", (int)(gcs - this.lastGCCount));
        long gcTime = Utils.getGCTotalTime();
        this.measurements.measure("GCS_TIME", (int)(gcTime - this.lastGCTime));
        this.lastGCCount = gcs;
        this.lastGCTime = gcTime;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public int getMinThreads() {
        return this.minThreads;
    }

    public long getMaxUsedMem() {
        return this.maxUsedMem;
    }

    public long getMinUsedMem() {
        return this.minUsedMem;
    }

    public double getMaxLoadAvg() {
        return this.maxLoadAvg;
    }

    public double getMinLoadAvg() {
        return this.minLoadAvg;
    }

    public boolean trackJVMStats() {
        return this.trackJVMStats;
    }
}

