/*
 * Decompiled with CFR 0.152.
 */
package site.ycsb;

public class Status {
    private final String name;
    private final String description;
    public static final Status OK = new Status("OK", "The operation completed successfully.");
    public static final Status ERROR = new Status("ERROR", "The operation failed.");
    public static final Status NOT_FOUND = new Status("NOT_FOUND", "The requested record was not found.");
    public static final Status NOT_IMPLEMENTED = new Status("NOT_IMPLEMENTED", "The operation is not implemented for the current binding.");
    public static final Status UNEXPECTED_STATE = new Status("UNEXPECTED_STATE", "The operation reported success, but the result was not as expected.");
    public static final Status BAD_REQUEST = new Status("BAD_REQUEST", "The request was not valid.");
    public static final Status FORBIDDEN = new Status("FORBIDDEN", "The operation is forbidden.");
    public static final Status SERVICE_UNAVAILABLE = new Status("SERVICE_UNAVAILABLE", "Dependant service for the current binding is not available.");
    public static final Status BATCHED_OK = new Status("BATCHED_OK", "The operation has been batched by the binding to be executed later.");

    public Status(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return "Status [name=" + this.name + ", description=" + this.description + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Status other = (Status)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public boolean isOk() {
        return this == OK || this == BATCHED_OK;
    }
}

