/*
 * Decompiled with CFR 0.152.
 */
package site.ycsb;

import java.util.concurrent.ThreadLocalRandom;
import site.ycsb.ByteIterator;

public class RandomByteIterator
extends ByteIterator {
    private final long len;
    private long off;
    private int bufOff;
    private final byte[] buf;

    @Override
    public boolean hasNext() {
        return this.off + (long)this.bufOff < this.len;
    }

    private void fillBytesImpl(byte[] buffer, int base) {
        int bytes = ThreadLocalRandom.current().nextInt();
        switch (buffer.length - base) {
            default: {
                buffer[base + 5] = (byte)((bytes >> 25 & 0x5F) + 32);
            }
            case 5: {
                buffer[base + 4] = (byte)((bytes >> 20 & 0x3F) + 32);
            }
            case 4: {
                buffer[base + 3] = (byte)((bytes >> 15 & 0x1F) + 32);
            }
            case 3: {
                buffer[base + 2] = (byte)((bytes >> 10 & 0x5F) + 32);
            }
            case 2: {
                buffer[base + 1] = (byte)((bytes >> 5 & 0x3F) + 32);
            }
            case 1: {
                buffer[base + 0] = (byte)((bytes & 0x1F) + 32);
            }
            case 0: 
        }
    }

    private void fillBytes() {
        if (this.bufOff == this.buf.length) {
            this.fillBytesImpl(this.buf, 0);
            this.bufOff = 0;
            this.off += (long)this.buf.length;
        }
    }

    public RandomByteIterator(long len) {
        this.len = len;
        this.buf = new byte[6];
        this.bufOff = this.buf.length;
        this.fillBytes();
        this.off = 0L;
    }

    @Override
    public byte nextByte() {
        this.fillBytes();
        ++this.bufOff;
        return this.buf[this.bufOff - 1];
    }

    @Override
    public int nextBuf(byte[] buffer, int bufOffset) {
        int ret = this.len - this.off < (long)(buffer.length - bufOffset) ? (int)(this.len - this.off) : buffer.length - bufOffset;
        for (int i = 0; i < ret; i += 6) {
            this.fillBytesImpl(buffer, i + bufOffset);
        }
        this.off += (long)ret;
        return ret + bufOffset;
    }

    @Override
    public long bytesLeft() {
        return this.len - this.off - (long)this.bufOff;
    }

    @Override
    public void reset() {
        this.off = 0L;
    }

    @Override
    public byte[] toArray() {
        long left = this.bytesLeft();
        if (left != (long)((int)left)) {
            throw new ArrayIndexOutOfBoundsException("Too much data to fit in one array!");
        }
        byte[] ret = new byte[(int)left];
        int bufOffset = 0;
        while (bufOffset < ret.length) {
            bufOffset = this.nextBuf(ret, bufOffset);
        }
        return ret;
    }
}

