/*
 * Decompiled with CFR 0.152.
 */
package site.ycsb;

import site.ycsb.ByteIterator;
import site.ycsb.Utils;

public class NumericByteIterator
extends ByteIterator {
    private final byte[] payload;
    private final boolean floatingPoint;
    private int off;

    public NumericByteIterator(long value) {
        this.floatingPoint = false;
        this.payload = Utils.longToBytes(value);
        this.off = 0;
    }

    public NumericByteIterator(double value) {
        this.floatingPoint = true;
        this.payload = Utils.doubleToBytes(value);
        this.off = 0;
    }

    @Override
    public boolean hasNext() {
        return this.off < this.payload.length;
    }

    @Override
    public byte nextByte() {
        return this.payload[this.off++];
    }

    @Override
    public long bytesLeft() {
        return this.payload.length - this.off;
    }

    @Override
    public void reset() {
        this.off = 0;
    }

    public long getLong() {
        if (this.floatingPoint) {
            throw new IllegalStateException("Byte iterator is of the type double");
        }
        return Utils.bytesToLong(this.payload);
    }

    public double getDouble() {
        if (!this.floatingPoint) {
            throw new IllegalStateException("Byte iterator is of the type long");
        }
        return Utils.bytesToDouble(this.payload);
    }

    public boolean isFloatingPoint() {
        return this.floatingPoint;
    }
}

