/*
 * Decompiled with CFR 0.152.
 */
package site.ycsb;

import java.io.IOException;
import java.io.InputStream;
import site.ycsb.ByteIterator;

public class InputStreamByteIterator
extends ByteIterator {
    private final long len;
    private final InputStream ins;
    private long off;
    private final boolean resetable;

    public InputStreamByteIterator(InputStream ins, long len) {
        this.len = len;
        this.ins = ins;
        this.off = 0L;
        this.resetable = ins.markSupported();
        if (this.resetable) {
            ins.mark((int)len);
        }
    }

    @Override
    public boolean hasNext() {
        return this.off < this.len;
    }

    @Override
    public byte nextByte() {
        int ret;
        try {
            ret = this.ins.read();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        if (ret == -1) {
            throw new IllegalStateException("Past EOF!");
        }
        ++this.off;
        return (byte)ret;
    }

    @Override
    public long bytesLeft() {
        return this.len - this.off;
    }

    @Override
    public byte[] toArray() {
        int size = (int)this.bytesLeft();
        byte[] bytes = new byte[size];
        try {
            if (this.ins.read(bytes) < size) {
                throw new IllegalStateException("Past EOF!");
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.off = this.len;
        return bytes;
    }

    @Override
    public void reset() {
        if (this.resetable) {
            try {
                this.ins.reset();
                this.ins.mark((int)this.len);
                this.off = 0L;
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to reset the input stream", e);
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }
}

