/*
 * Decompiled with CFR 0.152.
 */
package site.ycsb;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.apache.htrace.core.TraceScope;
import org.apache.htrace.core.Tracer;
import site.ycsb.ByteIterator;
import site.ycsb.DB;
import site.ycsb.DBException;
import site.ycsb.Status;
import site.ycsb.measurements.Measurements;

public class DBWrapper
extends DB {
    private final DB db;
    private final Measurements measurements;
    private final Tracer tracer;
    private boolean reportLatencyForEachError = false;
    private Set<String> latencyTrackedErrors = new HashSet<String>();
    private static final String REPORT_LATENCY_FOR_EACH_ERROR_PROPERTY = "reportlatencyforeacherror";
    private static final String REPORT_LATENCY_FOR_EACH_ERROR_PROPERTY_DEFAULT = "false";
    private static final String LATENCY_TRACKED_ERRORS_PROPERTY = "latencytrackederrors";
    private final String scopeStringCleanup;
    private final String scopeStringDelete;
    private final String scopeStringInit;
    private final String scopeStringInsert;
    private final String scopeStringRead;
    private final String scopeStringScan;
    private final String scopeStringUpdate;

    public DBWrapper(DB db, Tracer tracer) {
        this.db = db;
        this.measurements = Measurements.getMeasurements();
        this.tracer = tracer;
        String simple = db.getClass().getSimpleName();
        this.scopeStringCleanup = simple + "#cleanup";
        this.scopeStringDelete = simple + "#delete";
        this.scopeStringInit = simple + "#init";
        this.scopeStringInsert = simple + "#insert";
        this.scopeStringRead = simple + "#read";
        this.scopeStringScan = simple + "#scan";
        this.scopeStringUpdate = simple + "#update";
    }

    @Override
    public void setProperties(Properties p) {
        this.db.setProperties(p);
    }

    @Override
    public Properties getProperties() {
        return this.db.getProperties();
    }

    @Override
    public void init() throws DBException {
        try (TraceScope span = this.tracer.newScope(this.scopeStringInit);){
            String latencyTrackedErrorsProperty;
            this.db.init();
            this.reportLatencyForEachError = Boolean.parseBoolean(this.getProperties().getProperty(REPORT_LATENCY_FOR_EACH_ERROR_PROPERTY, REPORT_LATENCY_FOR_EACH_ERROR_PROPERTY_DEFAULT));
            if (!this.reportLatencyForEachError && (latencyTrackedErrorsProperty = this.getProperties().getProperty(LATENCY_TRACKED_ERRORS_PROPERTY, null)) != null) {
                this.latencyTrackedErrors = new HashSet<String>(Arrays.asList(latencyTrackedErrorsProperty.split(",")));
            }
            System.err.println("DBWrapper: report latency for each error is " + this.reportLatencyForEachError + " and specific error codes to track for latency are: " + this.latencyTrackedErrors.toString());
        }
    }

    @Override
    public void cleanup() throws DBException {
        try (TraceScope span = this.tracer.newScope(this.scopeStringCleanup);){
            long ist = this.measurements.getIntendedtartTimeNs();
            long st = System.nanoTime();
            this.db.cleanup();
            long en = System.nanoTime();
            this.measure("CLEANUP", Status.OK, ist, st, en);
        }
    }

    @Override
    public Status read(String table, String key, Set<String> fields, Map<String, ByteIterator> result) {
        try (TraceScope span = this.tracer.newScope(this.scopeStringRead);){
            long ist = this.measurements.getIntendedtartTimeNs();
            long st = System.nanoTime();
            Status res = this.db.read(table, key, fields, result);
            long en = System.nanoTime();
            this.measure("READ", res, ist, st, en);
            this.measurements.reportStatus("READ", res);
            Status status = res;
            return status;
        }
    }

    @Override
    public Status scan(String table, String startkey, int recordcount, Set<String> fields, Vector<HashMap<String, ByteIterator>> result) {
        try (TraceScope span = this.tracer.newScope(this.scopeStringScan);){
            long ist = this.measurements.getIntendedtartTimeNs();
            long st = System.nanoTime();
            Status res = this.db.scan(table, startkey, recordcount, fields, result);
            long en = System.nanoTime();
            this.measure("SCAN", res, ist, st, en);
            this.measurements.reportStatus("SCAN", res);
            Status status = res;
            return status;
        }
    }

    private void measure(String op, Status result, long intendedStartTimeNanos, long startTimeNanos, long endTimeNanos) {
        String measurementName = op;
        if (result == null || !result.isOk()) {
            measurementName = this.reportLatencyForEachError || this.latencyTrackedErrors.contains(result.getName()) ? op + "-" + result.getName() : op + "-FAILED";
        }
        this.measurements.measure(measurementName, (int)((endTimeNanos - startTimeNanos) / 1000L));
        this.measurements.measureIntended(measurementName, (int)((endTimeNanos - intendedStartTimeNanos) / 1000L));
    }

    @Override
    public Status update(String table, String key, Map<String, ByteIterator> values) {
        try (TraceScope span = this.tracer.newScope(this.scopeStringUpdate);){
            long ist = this.measurements.getIntendedtartTimeNs();
            long st = System.nanoTime();
            Status res = this.db.update(table, key, values);
            long en = System.nanoTime();
            this.measure("UPDATE", res, ist, st, en);
            this.measurements.reportStatus("UPDATE", res);
            Status status = res;
            return status;
        }
    }

    @Override
    public Status insert(String table, String key, Map<String, ByteIterator> values) {
        try (TraceScope span = this.tracer.newScope(this.scopeStringInsert);){
            long ist = this.measurements.getIntendedtartTimeNs();
            long st = System.nanoTime();
            Status res = this.db.insert(table, key, values);
            long en = System.nanoTime();
            this.measure("INSERT", res, ist, st, en);
            this.measurements.reportStatus("INSERT", res);
            Status status = res;
            return status;
        }
    }

    @Override
    public Status delete(String table, String key) {
        try (TraceScope span = this.tracer.newScope(this.scopeStringDelete);){
            long ist = this.measurements.getIntendedtartTimeNs();
            long st = System.nanoTime();
            Status res = this.db.delete(table, key);
            long en = System.nanoTime();
            this.measure("DELETE", res, ist, st, en);
            this.measurements.reportStatus("DELETE", res);
            Status status = res;
            return status;
        }
    }
}

