/*
 * Decompiled with CFR 0.152.
 */
package site.ycsb;

import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.locks.LockSupport;
import site.ycsb.DB;
import site.ycsb.DBException;
import site.ycsb.Workload;
import site.ycsb.WorkloadException;
import site.ycsb.measurements.Measurements;

public class ClientThread
implements Runnable {
    private final CountDownLatch completeLatch;
    private static boolean spinSleep;
    private DB db;
    private boolean dotransactions;
    private Workload workload;
    private int opcount;
    private double targetOpsPerMs;
    private int opsdone;
    private int threadid;
    private int threadcount;
    private Object workloadstate;
    private Properties props;
    private long targetOpsTickNs;
    private final Measurements measurements;

    public ClientThread(DB db, boolean dotransactions, Workload workload, Properties props, int opcount, double targetperthreadperms, CountDownLatch completeLatch) {
        this.db = db;
        this.dotransactions = dotransactions;
        this.workload = workload;
        this.opcount = opcount;
        this.opsdone = 0;
        if (targetperthreadperms > 0.0) {
            this.targetOpsPerMs = targetperthreadperms;
            this.targetOpsTickNs = (long)(1000000.0 / this.targetOpsPerMs);
        }
        this.props = props;
        this.measurements = Measurements.getMeasurements();
        spinSleep = Boolean.valueOf(this.props.getProperty("spin.sleep", "false"));
        this.completeLatch = completeLatch;
    }

    public void setThreadId(int threadId) {
        this.threadid = threadId;
    }

    public void setThreadCount(int threadCount) {
        this.threadcount = threadCount;
    }

    public int getOpsDone() {
        return this.opsdone;
    }

    @Override
    public void run() {
        try {
            this.db.init();
        }
        catch (DBException e) {
            e.printStackTrace();
            e.printStackTrace(System.out);
            return;
        }
        try {
            this.workloadstate = this.workload.initThread(this.props, this.threadid, this.threadcount);
        }
        catch (WorkloadException e) {
            e.printStackTrace();
            e.printStackTrace(System.out);
            return;
        }
        if (this.targetOpsPerMs > 0.0 && this.targetOpsPerMs <= 1.0) {
            long randomMinorDelay = ThreadLocalRandom.current().nextInt((int)this.targetOpsTickNs);
            ClientThread.sleepUntil(System.nanoTime() + randomMinorDelay);
        }
        try {
            long startTimeNanos;
            if (this.dotransactions) {
                startTimeNanos = System.nanoTime();
                while ((this.opcount == 0 || this.opsdone < this.opcount) && !this.workload.isStopRequested() && this.workload.doTransaction(this.db, this.workloadstate)) {
                    ++this.opsdone;
                    this.throttleNanos(startTimeNanos);
                }
            } else {
                startTimeNanos = System.nanoTime();
                while ((this.opcount == 0 || this.opsdone < this.opcount) && !this.workload.isStopRequested() && this.workload.doInsert(this.db, this.workloadstate)) {
                    ++this.opsdone;
                    this.throttleNanos(startTimeNanos);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            e.printStackTrace(System.out);
            System.exit(0);
        }
        try {
            this.measurements.setIntendedStartTimeNs(0L);
            this.db.cleanup();
        }
        catch (DBException e) {
            e.printStackTrace();
            e.printStackTrace(System.out);
        }
        finally {
            this.completeLatch.countDown();
        }
    }

    private static void sleepUntil(long deadline) {
        while (System.nanoTime() < deadline) {
            if (spinSleep) continue;
            LockSupport.parkNanos(deadline - System.nanoTime());
        }
    }

    private void throttleNanos(long startTimeNanos) {
        if (this.targetOpsPerMs > 0.0) {
            long deadline = startTimeNanos + (long)this.opsdone * this.targetOpsTickNs;
            ClientThread.sleepUntil(deadline);
            this.measurements.setIntendedStartTimeNs(deadline);
        }
    }

    int getOpsTodo() {
        int todo = this.opcount - this.opsdone;
        return todo < 0 ? 0 : todo;
    }
}

