/*
 * Decompiled with CFR 0.152.
 */
package site.ycsb;

import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import org.apache.htrace.core.HTraceConfiguration;
import org.apache.htrace.core.TraceScope;
import org.apache.htrace.core.Tracer;
import site.ycsb.ClientThread;
import site.ycsb.DB;
import site.ycsb.DBFactory;
import site.ycsb.StatusThread;
import site.ycsb.TerminatorThread;
import site.ycsb.UnknownDBException;
import site.ycsb.Utils;
import site.ycsb.Workload;
import site.ycsb.WorkloadException;
import site.ycsb.measurements.Measurements;
import site.ycsb.measurements.exporter.MeasurementsExporter;
import site.ycsb.measurements.exporter.TextMeasurementsExporter;

public final class Client {
    public static final String DEFAULT_RECORD_COUNT = "0";
    public static final String OPERATION_COUNT_PROPERTY = "operationcount";
    public static final String RECORD_COUNT_PROPERTY = "recordcount";
    public static final String WORKLOAD_PROPERTY = "workload";
    public static final String DB_PROPERTY = "db";
    public static final String EXPORTER_PROPERTY = "exporter";
    public static final String EXPORT_FILE_PROPERTY = "exportfile";
    public static final String THREAD_COUNT_PROPERTY = "threadcount";
    public static final String INSERT_COUNT_PROPERTY = "insertcount";
    public static final String TARGET_PROPERTY = "target";
    public static final String MAX_EXECUTION_TIME = "maxexecutiontime";
    public static final String DO_TRANSACTIONS_PROPERTY = "dotransactions";
    public static final String STATUS_PROPERTY = "status";
    public static final String LABEL_PROPERTY = "label";
    private static StatusThread statusthread = null;
    private static final String HTRACE_KEY_PREFIX = "htrace.";
    private static final String CLIENT_WORKLOAD_INIT_SPAN = "Client#workload_init";
    private static final String CLIENT_INIT_SPAN = "Client#init";
    private static final String CLIENT_WORKLOAD_SPAN = "Client#workload";
    private static final String CLIENT_CLEANUP_SPAN = "Client#cleanup";
    private static final String CLIENT_EXPORT_MEASUREMENTS_SPAN = "Client#export_measurements";

    private Client() {
    }

    public static void usageMessage() {
        System.out.println("Usage: java site.ycsb.Client [options]");
        System.out.println("Options:");
        System.out.println("  -threads n: execute using n threads (default: 1) - can also be specified as the \n        \"threadcount\" property using -p");
        System.out.println("  -target n: attempt to do n operations per second (default: unlimited) - can also\n       be specified as the \"target\" property using -p");
        System.out.println("  -load:  run the loading phase of the workload");
        System.out.println("  -t:  run the transactions phase of the workload (default)");
        System.out.println("  -db dbname: specify the name of the DB to use (default: site.ycsb.BasicDB) - \n        can also be specified as the \"db\" property using -p");
        System.out.println("  -P propertyfile: load properties from the given file. Multiple files can");
        System.out.println("           be specified, and will be processed in the order specified");
        System.out.println("  -p name=value:  specify a property to be passed to the DB and workloads;");
        System.out.println("          multiple properties can be specified, and override any");
        System.out.println("          values in the propertyfile");
        System.out.println("  -s:  show status during run (default: no status)");
        System.out.println("  -l label:  use label for status (e.g. to label one experiment out of a whole batch)");
        System.out.println("");
        System.out.println("Required properties:");
        System.out.println("  workload: the name of the workload class to use (e.g. site.ycsb.workloads.CoreWorkload)");
        System.out.println("");
        System.out.println("To run the transaction phase from multiple servers, start a separate client on each.");
        System.out.println("To run the load phase from multiple servers, start a separate client on each; additionally,");
        System.out.println("use the \"insertcount\" and \"insertstart\" properties to divide up the records to be inserted");
    }

    public static boolean checkRequiredProperties(Properties props) {
        if (props.getProperty(WORKLOAD_PROPERTY) == null) {
            System.out.println("Missing property: workload");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void exportMeasurements(Properties props, int opcount, long runtime) throws IOException {
        try (Closeable exporter = null;){
            String exportFile = props.getProperty(EXPORT_FILE_PROPERTY);
            OutputStream out = exportFile == null ? System.out : new FileOutputStream(exportFile);
            String exporterStr = props.getProperty(EXPORTER_PROPERTY, "site.ycsb.measurements.exporter.TextMeasurementsExporter");
            try {
                exporter = (MeasurementsExporter)Class.forName(exporterStr).getConstructor(OutputStream.class).newInstance(out);
            }
            catch (Exception e) {
                System.err.println("Could not find exporter " + exporterStr + ", will use default text reporter.");
                e.printStackTrace();
                exporter = new TextMeasurementsExporter(out);
            }
            exporter.write("OVERALL", "RunTime(ms)", runtime);
            double throughput = 1000.0 * (double)opcount / (double)runtime;
            exporter.write("OVERALL", "Throughput(ops/sec)", throughput);
            Map<String, Long[]> gcs = Utils.getGCStatst();
            long totalGCCount = 0L;
            long totalGCTime = 0L;
            for (Map.Entry<String, Long[]> entry : gcs.entrySet()) {
                exporter.write("TOTAL_GCS_" + entry.getKey(), "Count", entry.getValue()[0]);
                exporter.write("TOTAL_GC_TIME_" + entry.getKey(), "Time(ms)", entry.getValue()[1]);
                exporter.write("TOTAL_GC_TIME_%_" + entry.getKey(), "Time(%)", (double)entry.getValue()[1].longValue() / (double)runtime * 100.0);
                totalGCCount += entry.getValue()[0].longValue();
                totalGCTime += entry.getValue()[1].longValue();
            }
            exporter.write("TOTAL_GCs", "Count", totalGCCount);
            exporter.write("TOTAL_GC_TIME", "Time(ms)", totalGCTime);
            exporter.write("TOTAL_GC_TIME_%", "Time(%)", (double)totalGCTime / (double)runtime * 100.0);
            if (statusthread != null && statusthread.trackJVMStats()) {
                exporter.write("MAX_MEM_USED", "MBs", statusthread.getMaxUsedMem());
                exporter.write("MIN_MEM_USED", "MBs", statusthread.getMinUsedMem());
                exporter.write("MAX_THREADS", "Count", statusthread.getMaxThreads());
                exporter.write("MIN_THREADS", "Count", statusthread.getMinThreads());
                exporter.write("MAX_SYS_LOAD_AVG", "Load", statusthread.getMaxLoadAvg());
                exporter.write("MIN_SYS_LOAD_AVG", "Load", statusthread.getMinLoadAvg());
            }
            Measurements.getMeasurements().exportMeasurements((MeasurementsExporter)exporter);
        }
    }

    public static void main(String[] args) {
        long en;
        int opsDone;
        long st;
        Properties props = Client.parseArguments(args);
        boolean status = Boolean.valueOf(props.getProperty(STATUS_PROPERTY, String.valueOf(false)));
        String label = props.getProperty(LABEL_PROPERTY, "");
        long maxExecutionTime = Integer.parseInt(props.getProperty(MAX_EXECUTION_TIME, DEFAULT_RECORD_COUNT));
        int threadcount = Integer.parseInt(props.getProperty(THREAD_COUNT_PROPERTY, "1"));
        String dbname = props.getProperty(DB_PROPERTY, "site.ycsb.BasicDB");
        int target = Integer.parseInt(props.getProperty(TARGET_PROPERTY, DEFAULT_RECORD_COUNT));
        double targetperthreadperms = -1.0;
        if (target > 0) {
            double targetperthread = (double)target / (double)threadcount;
            targetperthreadperms = targetperthread / 1000.0;
        }
        Thread warningthread = Client.setupWarningThread();
        warningthread.start();
        Measurements.setProperties(props);
        Workload workload = Client.getWorkload(props);
        Tracer tracer = Client.getTracer(props, workload);
        Client.initWorkload(props, warningthread, workload, tracer);
        System.err.println("Starting test.");
        CountDownLatch completeLatch = new CountDownLatch(threadcount);
        List<ClientThread> clients = Client.initDb(dbname, props, threadcount, targetperthreadperms, workload, tracer, completeLatch);
        if (status) {
            boolean standardstatus = false;
            if (props.getProperty("measurementtype", "").compareTo("timeseries") == 0) {
                standardstatus = true;
            }
            int statusIntervalSeconds = Integer.parseInt(props.getProperty("status.interval", "10"));
            boolean trackJVMStats = props.getProperty("measurement.trackjvm", "false").equals("true");
            statusthread = new StatusThread(completeLatch, clients, label, standardstatus, statusIntervalSeconds, trackJVMStats);
            statusthread.start();
        }
        TerminatorThread terminator = null;
        try (TraceScope span = tracer.newScope(CLIENT_WORKLOAD_SPAN);){
            HashMap<Thread, ClientThread> threads = new HashMap<Thread, ClientThread>(threadcount);
            for (ClientThread clientThread : clients) {
                threads.put(new Thread(tracer.wrap((Runnable)clientThread, "ClientThread")), clientThread);
            }
            st = System.currentTimeMillis();
            for (Thread thread : threads.keySet()) {
                thread.start();
            }
            if (maxExecutionTime > 0L) {
                terminator = new TerminatorThread(maxExecutionTime, threads.keySet(), workload);
                terminator.start();
            }
            opsDone = 0;
            for (Map.Entry entry : threads.entrySet()) {
                try {
                    ((Thread)entry.getKey()).join();
                    opsDone += ((ClientThread)entry.getValue()).getOpsDone();
                }
                catch (InterruptedException interruptedException) {}
            }
            en = System.currentTimeMillis();
        }
        try {
            span = tracer.newScope(CLIENT_CLEANUP_SPAN);
            var23_23 = null;
            try {
                if (terminator != null && !terminator.isInterrupted()) {
                    terminator.interrupt();
                }
                if (status) {
                    statusthread.interrupt();
                    try {
                        statusthread.join();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                workload.cleanup();
            }
            catch (Throwable throwable) {
                var23_23 = throwable;
                throw throwable;
            }
            finally {
                if (span != null) {
                    if (var23_23 != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable) {
                            var23_23.addSuppressed(throwable);
                        }
                    } else {
                        span.close();
                    }
                }
            }
        }
        catch (WorkloadException e) {
            e.printStackTrace();
            e.printStackTrace(System.out);
            System.exit(0);
        }
        try {
            span = tracer.newScope(CLIENT_EXPORT_MEASUREMENTS_SPAN);
            var23_23 = null;
            try {
                Client.exportMeasurements(props, opsDone, en - st);
            }
            catch (Throwable throwable) {
                var23_23 = throwable;
                throw throwable;
            }
            finally {
                if (span != null) {
                    if (var23_23 != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable) {
                            var23_23.addSuppressed(throwable);
                        }
                    } else {
                        span.close();
                    }
                }
            }
        }
        catch (IOException e) {
            System.err.println("Could not export measurements, error: " + e.getMessage());
            e.printStackTrace();
            System.exit(-1);
        }
        System.exit(0);
    }

    private static List<ClientThread> initDb(String dbname, Properties props, int threadcount, double targetperthreadperms, Workload workload, Tracer tracer, CountDownLatch completeLatch) {
        boolean initFailed = false;
        boolean dotransactions = Boolean.valueOf(props.getProperty(DO_TRANSACTIONS_PROPERTY, String.valueOf(true)));
        ArrayList<ClientThread> clients = new ArrayList<ClientThread>(threadcount);
        try (TraceScope span = tracer.newScope(CLIENT_INIT_SPAN);){
            int opcount = dotransactions ? Integer.parseInt(props.getProperty(OPERATION_COUNT_PROPERTY, DEFAULT_RECORD_COUNT)) : (props.containsKey(INSERT_COUNT_PROPERTY) ? Integer.parseInt(props.getProperty(INSERT_COUNT_PROPERTY, DEFAULT_RECORD_COUNT)) : Integer.parseInt(props.getProperty(RECORD_COUNT_PROPERTY, DEFAULT_RECORD_COUNT)));
            if (threadcount > opcount) {
                threadcount = opcount;
                System.out.println("Warning: the threadcount is bigger than recordcount, the threadcount will be recordcount!");
            }
            for (int threadid = 0; threadid < threadcount; ++threadid) {
                DB db;
                try {
                    db = DBFactory.newDB(dbname, props, tracer);
                }
                catch (UnknownDBException e) {
                    System.out.println("Unknown DB " + dbname);
                    initFailed = true;
                    break;
                }
                int threadopcount = opcount / threadcount;
                if (threadid < opcount % threadcount) {
                    ++threadopcount;
                }
                ClientThread t = new ClientThread(db, dotransactions, workload, props, threadopcount, targetperthreadperms, completeLatch);
                t.setThreadId(threadid);
                t.setThreadCount(threadcount);
                clients.add(t);
            }
            if (initFailed) {
                System.err.println("Error initializing datastore bindings.");
                System.exit(0);
            }
        }
        return clients;
    }

    private static Tracer getTracer(Properties props, Workload workload) {
        return new Tracer.Builder("YCSB " + workload.getClass().getSimpleName()).conf(Client.getHTraceConfiguration(props)).build();
    }

    private static void initWorkload(Properties props, Thread warningthread, Workload workload, Tracer tracer) {
        try (TraceScope span = tracer.newScope(CLIENT_WORKLOAD_INIT_SPAN);){
            workload.init(props);
            warningthread.interrupt();
        }
        catch (WorkloadException e) {
            e.printStackTrace();
            e.printStackTrace(System.out);
            System.exit(0);
        }
    }

    private static HTraceConfiguration getHTraceConfiguration(Properties props) {
        HashMap<String, String> filteredProperties = new HashMap<String, String>();
        for (String key : props.stringPropertyNames()) {
            if (!key.startsWith(HTRACE_KEY_PREFIX)) continue;
            filteredProperties.put(key.substring(HTRACE_KEY_PREFIX.length()), props.getProperty(key));
        }
        return HTraceConfiguration.fromMap(filteredProperties);
    }

    private static Thread setupWarningThread() {
        return new Thread(){

            @Override
            public void run() {
                try {
                    1.sleep(2000L);
                }
                catch (InterruptedException e) {
                    return;
                }
                System.err.println(" (might take a few minutes for large data sets)");
            }
        };
    }

    private static Workload getWorkload(Properties props) {
        ClassLoader classLoader = Client.class.getClassLoader();
        try {
            Properties projectProp = new Properties();
            projectProp.load(classLoader.getResourceAsStream("project.properties"));
            System.err.println("YCSB Client " + projectProp.getProperty("version"));
        }
        catch (IOException e) {
            System.err.println("Unable to retrieve client version.");
        }
        System.err.println();
        System.err.println("Loading workload...");
        try {
            Class<?> workloadclass = classLoader.loadClass(props.getProperty(WORKLOAD_PROPERTY));
            return (Workload)workloadclass.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            e.printStackTrace(System.out);
            System.exit(0);
            return null;
        }
    }

    private static Properties parseArguments(String[] args) {
        Properties props = new Properties();
        System.err.print("Command line:");
        for (String arg : args) {
            System.err.print(" " + arg);
        }
        System.err.println();
        Properties fileprops = new Properties();
        int argindex = 0;
        if (args.length == 0) {
            Client.usageMessage();
            System.out.println("At least one argument specifying a workload is required.");
            System.exit(0);
        }
        while (args[argindex].startsWith("-")) {
            if (args[argindex].compareTo("-threads") == 0) {
                if (++argindex >= args.length) {
                    Client.usageMessage();
                    System.out.println("Missing argument value for -threads.");
                    System.exit(0);
                }
                int tcount = Integer.parseInt(args[argindex]);
                props.setProperty(THREAD_COUNT_PROPERTY, String.valueOf(tcount));
                ++argindex;
            } else if (args[argindex].compareTo("-target") == 0) {
                if (++argindex >= args.length) {
                    Client.usageMessage();
                    System.out.println("Missing argument value for -target.");
                    System.exit(0);
                }
                int ttarget = Integer.parseInt(args[argindex]);
                props.setProperty(TARGET_PROPERTY, String.valueOf(ttarget));
                ++argindex;
            } else if (args[argindex].compareTo("-load") == 0) {
                props.setProperty(DO_TRANSACTIONS_PROPERTY, String.valueOf(false));
                ++argindex;
            } else if (args[argindex].compareTo("-t") == 0) {
                props.setProperty(DO_TRANSACTIONS_PROPERTY, String.valueOf(true));
                ++argindex;
            } else if (args[argindex].compareTo("-s") == 0) {
                props.setProperty(STATUS_PROPERTY, String.valueOf(true));
                ++argindex;
            } else if (args[argindex].compareTo("-db") == 0) {
                if (++argindex >= args.length) {
                    Client.usageMessage();
                    System.out.println("Missing argument value for -db.");
                    System.exit(0);
                }
                props.setProperty(DB_PROPERTY, args[argindex]);
                ++argindex;
            } else if (args[argindex].compareTo("-l") == 0) {
                if (++argindex >= args.length) {
                    Client.usageMessage();
                    System.out.println("Missing argument value for -l.");
                    System.exit(0);
                }
                props.setProperty(LABEL_PROPERTY, args[argindex]);
                ++argindex;
            } else if (args[argindex].compareTo("-P") == 0) {
                if (++argindex >= args.length) {
                    Client.usageMessage();
                    System.out.println("Missing argument value for -P.");
                    System.exit(0);
                }
                String propfile = args[argindex];
                ++argindex;
                Properties myfileprops = new Properties();
                try {
                    myfileprops.load(new FileInputStream(propfile));
                }
                catch (IOException e) {
                    System.out.println("Unable to open the properties file " + propfile);
                    System.out.println(e.getMessage());
                    System.exit(0);
                }
                Enumeration<?> e = myfileprops.propertyNames();
                while (e.hasMoreElements()) {
                    String prop = (String)e.nextElement();
                    fileprops.setProperty(prop, myfileprops.getProperty(prop));
                }
            } else if (args[argindex].compareTo("-p") == 0) {
                int eq;
                if (++argindex >= args.length) {
                    Client.usageMessage();
                    System.out.println("Missing argument value for -p");
                    System.exit(0);
                }
                if ((eq = args[argindex].indexOf(61)) < 0) {
                    Client.usageMessage();
                    System.out.println("Argument '-p' expected to be in key=value format (e.g., -p operationcount=99999)");
                    System.exit(0);
                }
                String name = args[argindex].substring(0, eq);
                String value = args[argindex].substring(eq + 1);
                props.put(name, value);
                ++argindex;
            } else {
                Client.usageMessage();
                System.out.println("Unknown option " + args[argindex]);
                System.exit(0);
            }
            if (argindex < args.length) continue;
        }
        if (argindex != args.length) {
            Client.usageMessage();
            if (argindex < args.length) {
                System.out.println("An argument value without corresponding argument specifier (e.g., -p, -s) was found. We expected an argument specifier and instead found " + args[argindex]);
            } else {
                System.out.println("An argument specifier without corresponding value was found at the end of the supplied command line arguments.");
            }
            System.exit(0);
        }
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String prop = (String)e.nextElement();
            fileprops.setProperty(prop, props.getProperty(prop));
        }
        props = fileprops;
        if (!Client.checkRequiredProperties(props)) {
            System.out.println("Failed check required properties.");
            System.exit(0);
        }
        return props;
    }
}

