/*
 * Decompiled with CFR 0.152.
 */
package site.ycsb;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Iterator;

public abstract class ByteIterator
implements Iterator<Byte> {
    @Override
    public abstract boolean hasNext();

    @Override
    public Byte next() {
        throw new UnsupportedOperationException();
    }

    public abstract byte nextByte();

    public int nextBuf(byte[] buf, int bufOff) {
        int sz;
        for (sz = bufOff; sz < buf.length && this.hasNext(); ++sz) {
            buf[sz] = this.nextByte();
        }
        return sz;
    }

    public abstract long bytesLeft();

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void reset() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        Charset cset = Charset.forName("UTF-8");
        CharBuffer cb = cset.decode(ByteBuffer.wrap(this.toArray()));
        return cb.toString();
    }

    public byte[] toArray() {
        long left = this.bytesLeft();
        if (left != (long)((int)left)) {
            throw new ArrayIndexOutOfBoundsException("Too much data to fit in one array!");
        }
        byte[] ret = new byte[(int)left];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.nextByte();
        }
        return ret;
    }
}

