/*
 * Decompiled with CFR 0.152.
 */
package site.ycsb;

import site.ycsb.ByteIterator;

public class ByteArrayByteIterator
extends ByteIterator {
    private final int originalOffset;
    private final byte[] str;
    private int off;
    private final int len;

    public ByteArrayByteIterator(byte[] s) {
        this.str = s;
        this.off = 0;
        this.len = s.length;
        this.originalOffset = 0;
    }

    public ByteArrayByteIterator(byte[] s, int off, int len) {
        this.str = s;
        this.off = off;
        this.len = off + len;
        this.originalOffset = off;
    }

    @Override
    public boolean hasNext() {
        return this.off < this.len;
    }

    @Override
    public byte nextByte() {
        byte ret = this.str[this.off];
        ++this.off;
        return ret;
    }

    @Override
    public long bytesLeft() {
        return this.len - this.off;
    }

    @Override
    public void reset() {
        this.off = this.originalOffset;
    }

    @Override
    public byte[] toArray() {
        int size = (int)this.bytesLeft();
        byte[] bytes = new byte[size];
        System.arraycopy(this.str, this.off, bytes, 0, size);
        this.off = this.len;
        return bytes;
    }
}

