/*
 * Decompiled with CFR 0.152.
 */
package site.ycsb;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import site.ycsb.BasicDB;
import site.ycsb.ByteIterator;
import site.ycsb.NumericByteIterator;
import site.ycsb.Status;
import site.ycsb.Utils;

public class BasicTSDB
extends BasicDB {
    protected static Map<Long, Integer> timestamps;
    protected static Map<Integer, Integer> floats;
    protected static Map<Integer, Integer> integers;
    private String timestampKey;
    private String valueKey;
    private String tagPairDelimiter;
    private String queryTimeSpanDelimiter;
    private long lastTimestamp;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        super.init();
        Object object = MUTEX;
        synchronized (object) {
            if (timestamps == null) {
                timestamps = new HashMap<Long, Integer>();
                floats = new HashMap<Integer, Integer>();
                integers = new HashMap<Integer, Integer>();
            }
        }
        this.timestampKey = this.getProperties().getProperty("timestampkey", "YCSBTS");
        this.valueKey = this.getProperties().getProperty("valuekey", "YCSBV");
        this.tagPairDelimiter = this.getProperties().getProperty("tagpairdelimiter", "=");
        this.queryTimeSpanDelimiter = this.getProperties().getProperty("querytimespandelimiter", ",");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Status read(String table, String key, Set<String> fields, Map<String, ByteIterator> result) {
        this.delay();
        if (this.verbose) {
            StringBuilder sb = BasicTSDB.getStringBuilder();
            sb.append("READ ").append(table).append(" ").append(key).append(" [ ");
            if (fields != null) {
                for (String f : fields) {
                    sb.append(f).append(" ");
                }
            } else {
                sb.append("<all fields>");
            }
            sb.append("]");
            System.out.println(sb);
        }
        if (this.count) {
            HashSet<String> filtered = null;
            if (fields != null) {
                filtered = new HashSet<String>();
                for (String field : fields) {
                    if (field.startsWith(this.timestampKey)) {
                        String[] parts = field.split(this.tagPairDelimiter);
                        if (parts[1].contains(this.queryTimeSpanDelimiter)) {
                            parts = parts[1].split(this.queryTimeSpanDelimiter);
                            this.lastTimestamp = Long.parseLong(parts[0]);
                        } else {
                            this.lastTimestamp = Long.parseLong(parts[1]);
                        }
                        Map<Long, Integer> map = timestamps;
                        synchronized (map) {
                            Integer ctr = timestamps.get(this.lastTimestamp);
                            if (ctr == null) {
                                timestamps.put(this.lastTimestamp, 1);
                            } else {
                                timestamps.put(this.lastTimestamp, ctr + 1);
                            }
                            continue;
                        }
                    }
                    filtered.add(field);
                }
            }
            this.incCounter(reads, this.hash(table, key, filtered));
        }
        return Status.OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Status update(String table, String key, Map<String, ByteIterator> values) {
        this.delay();
        boolean isFloat = false;
        if (this.verbose) {
            StringBuilder sb = BasicTSDB.getStringBuilder();
            sb.append("UPDATE ").append(table).append(" ").append(key).append(" [ ");
            if (values != null) {
                TreeMap<String, ByteIterator> tree = new TreeMap<String, ByteIterator>(values);
                for (Map.Entry<String, ByteIterator> entry : tree.entrySet()) {
                    if (entry.getKey().equals(this.timestampKey)) {
                        sb.append(entry.getKey()).append("=").append(Utils.bytesToLong(entry.getValue().toArray())).append(" ");
                        continue;
                    }
                    if (entry.getKey().equals(this.valueKey)) {
                        NumericByteIterator it = (NumericByteIterator)entry.getValue();
                        isFloat = it.isFloatingPoint();
                        sb.append(entry.getKey()).append("=").append(isFloat ? it.getDouble() : (double)it.getLong()).append(" ");
                        continue;
                    }
                    sb.append(entry.getKey()).append("=").append(entry.getValue()).append(" ");
                }
            }
            sb.append("]");
            System.out.println(sb);
        }
        if (this.count) {
            if (!this.verbose) {
                isFloat = ((NumericByteIterator)values.get(this.valueKey)).isFloatingPoint();
            }
            int hash = this.hash(table, key, values);
            this.incCounter(updates, hash);
            Map<Long, Integer> map = timestamps;
            synchronized (map) {
                Integer ctr = timestamps.get(this.lastTimestamp);
                if (ctr == null) {
                    timestamps.put(this.lastTimestamp, 1);
                } else {
                    timestamps.put(this.lastTimestamp, ctr + 1);
                }
            }
            if (isFloat) {
                this.incCounter(floats, hash);
            } else {
                this.incCounter(integers, hash);
            }
        }
        return Status.OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Status insert(String table, String key, Map<String, ByteIterator> values) {
        this.delay();
        boolean isFloat = false;
        if (this.verbose) {
            StringBuilder sb = BasicTSDB.getStringBuilder();
            sb.append("INSERT ").append(table).append(" ").append(key).append(" [ ");
            if (values != null) {
                TreeMap<String, ByteIterator> tree = new TreeMap<String, ByteIterator>(values);
                for (Map.Entry<String, ByteIterator> entry : tree.entrySet()) {
                    if (entry.getKey().equals(this.timestampKey)) {
                        sb.append(entry.getKey()).append("=").append(Utils.bytesToLong(entry.getValue().toArray())).append(" ");
                        continue;
                    }
                    if (entry.getKey().equals(this.valueKey)) {
                        NumericByteIterator it = (NumericByteIterator)entry.getValue();
                        isFloat = it.isFloatingPoint();
                        sb.append(entry.getKey()).append("=").append(isFloat ? it.getDouble() : (double)it.getLong()).append(" ");
                        continue;
                    }
                    sb.append(entry.getKey()).append("=").append(entry.getValue()).append(" ");
                }
            }
            sb.append("]");
            System.out.println(sb);
        }
        if (this.count) {
            if (!this.verbose) {
                isFloat = ((NumericByteIterator)values.get(this.valueKey)).isFloatingPoint();
            }
            int hash = this.hash(table, key, values);
            this.incCounter(inserts, hash);
            Map<Long, Integer> map = timestamps;
            synchronized (map) {
                Integer ctr = timestamps.get(this.lastTimestamp);
                if (ctr == null) {
                    timestamps.put(this.lastTimestamp, 1);
                } else {
                    timestamps.put(this.lastTimestamp, ctr + 1);
                }
            }
            if (isFloat) {
                this.incCounter(floats, hash);
            } else {
                this.incCounter(integers, hash);
            }
        }
        return Status.OK;
    }

    @Override
    public void cleanup() {
        super.cleanup();
        if (this.count && counter < 1) {
            System.out.println("[TIMESTAMPS], Unique, " + timestamps.size());
            System.out.println("[FLOATS], Unique series, " + floats.size());
            System.out.println("[INTEGERS], Unique series, " + integers.size());
            long minTs = Long.MAX_VALUE;
            long maxTs = Long.MIN_VALUE;
            for (long ts : timestamps.keySet()) {
                if (ts > maxTs) {
                    maxTs = ts;
                }
                if (ts >= minTs) continue;
                minTs = ts;
            }
            System.out.println("[TIMESTAMPS], Min, " + minTs);
            System.out.println("[TIMESTAMPS], Max, " + maxTs);
        }
    }

    @Override
    protected int hash(String table, String key, Map<String, ByteIterator> values) {
        TreeMap<String, ByteIterator> sorted = new TreeMap<String, ByteIterator>();
        for (Map.Entry<String, ByteIterator> entry : values.entrySet()) {
            if (entry.getKey().equals(this.valueKey)) continue;
            if (entry.getKey().equals(this.timestampKey)) {
                this.lastTimestamp = ((NumericByteIterator)entry.getValue()).getLong();
                entry.getValue().reset();
                continue;
            }
            sorted.put(entry.getKey(), entry.getValue());
        }
        StringBuilder buf = new StringBuilder().append(table).append(key);
        for (Map.Entry entry : sorted.entrySet()) {
            ((ByteIterator)entry.getValue()).reset();
            buf.append((String)entry.getKey()).append(((ByteIterator)entry.getValue()).toString());
        }
        return buf.toString().hashCode();
    }
}

