/*
 * Decompiled with CFR 0.152.
 */
package site.ycsb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import site.ycsb.ByteIterator;
import site.ycsb.DB;
import site.ycsb.Status;

public class BasicDB
extends DB {
    public static final String COUNT = "basicdb.count";
    public static final String COUNT_DEFAULT = "false";
    public static final String VERBOSE = "basicdb.verbose";
    public static final String VERBOSE_DEFAULT = "true";
    public static final String SIMULATE_DELAY = "basicdb.simulatedelay";
    public static final String SIMULATE_DELAY_DEFAULT = "0";
    public static final String RANDOMIZE_DELAY = "basicdb.randomizedelay";
    public static final String RANDOMIZE_DELAY_DEFAULT = "true";
    protected static final Object MUTEX = new Object();
    protected static int counter = 0;
    protected static Map<Integer, Integer> reads;
    protected static Map<Integer, Integer> scans;
    protected static Map<Integer, Integer> updates;
    protected static Map<Integer, Integer> inserts;
    protected static Map<Integer, Integer> deletes;
    protected boolean verbose;
    protected boolean randomizedelay;
    protected int todelay = 0;
    protected boolean count;
    protected static final ThreadLocal<StringBuilder> TL_STRING_BUILDER;

    protected void delay() {
        if (this.todelay > 0) {
            long delayNs;
            if (this.randomizedelay) {
                delayNs = TimeUnit.MILLISECONDS.toNanos(ThreadLocalRandom.current().nextInt(this.todelay));
                if (delayNs == 0L) {
                    return;
                }
            } else {
                delayNs = TimeUnit.MILLISECONDS.toNanos(this.todelay);
            }
            long deadline = System.nanoTime() + delayNs;
            do {
                LockSupport.parkNanos(deadline - System.nanoTime());
            } while (System.nanoTime() < deadline && !Thread.interrupted());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        Object object;
        this.verbose = Boolean.parseBoolean(this.getProperties().getProperty(VERBOSE, "true"));
        this.todelay = Integer.parseInt(this.getProperties().getProperty(SIMULATE_DELAY, SIMULATE_DELAY_DEFAULT));
        this.randomizedelay = Boolean.parseBoolean(this.getProperties().getProperty(RANDOMIZE_DELAY, "true"));
        this.count = Boolean.parseBoolean(this.getProperties().getProperty(COUNT, COUNT_DEFAULT));
        if (this.verbose) {
            object = System.out;
            synchronized (object) {
                System.out.println("***************** properties *****************");
                Properties p = this.getProperties();
                if (p != null) {
                    Enumeration<?> e = p.propertyNames();
                    while (e.hasMoreElements()) {
                        String k = (String)e.nextElement();
                        System.out.println("\"" + k + "\"=\"" + p.getProperty(k) + "\"");
                    }
                }
                System.out.println("**********************************************");
            }
        }
        object = MUTEX;
        synchronized (object) {
            if (counter == 0 && this.count) {
                reads = new HashMap<Integer, Integer>();
                scans = new HashMap<Integer, Integer>();
                updates = new HashMap<Integer, Integer>();
                inserts = new HashMap<Integer, Integer>();
                deletes = new HashMap<Integer, Integer>();
            }
            ++counter;
        }
    }

    protected static StringBuilder getStringBuilder() {
        StringBuilder sb = TL_STRING_BUILDER.get();
        sb.setLength(0);
        return sb;
    }

    @Override
    public Status read(String table, String key, Set<String> fields, Map<String, ByteIterator> result) {
        this.delay();
        if (this.verbose) {
            StringBuilder sb = BasicDB.getStringBuilder();
            sb.append("READ ").append(table).append(" ").append(key).append(" [ ");
            if (fields != null) {
                for (String f : fields) {
                    sb.append(f).append(" ");
                }
            } else {
                sb.append("<all fields>");
            }
            sb.append("]");
            System.out.println(sb);
        }
        if (this.count) {
            this.incCounter(reads, this.hash(table, key, fields));
        }
        return Status.OK;
    }

    @Override
    public Status scan(String table, String startkey, int recordcount, Set<String> fields, Vector<HashMap<String, ByteIterator>> result) {
        this.delay();
        if (this.verbose) {
            StringBuilder sb = BasicDB.getStringBuilder();
            sb.append("SCAN ").append(table).append(" ").append(startkey).append(" ").append(recordcount).append(" [ ");
            if (fields != null) {
                for (String f : fields) {
                    sb.append(f).append(" ");
                }
            } else {
                sb.append("<all fields>");
            }
            sb.append("]");
            System.out.println(sb);
        }
        if (this.count) {
            this.incCounter(scans, this.hash(table, startkey, fields));
        }
        return Status.OK;
    }

    @Override
    public Status update(String table, String key, Map<String, ByteIterator> values) {
        this.delay();
        if (this.verbose) {
            StringBuilder sb = BasicDB.getStringBuilder();
            sb.append("UPDATE ").append(table).append(" ").append(key).append(" [ ");
            if (values != null) {
                for (Map.Entry<String, ByteIterator> entry : values.entrySet()) {
                    sb.append(entry.getKey()).append("=").append(entry.getValue()).append(" ");
                }
            }
            sb.append("]");
            System.out.println(sb);
        }
        if (this.count) {
            this.incCounter(updates, this.hash(table, key, values));
        }
        return Status.OK;
    }

    @Override
    public Status insert(String table, String key, Map<String, ByteIterator> values) {
        this.delay();
        if (this.verbose) {
            StringBuilder sb = BasicDB.getStringBuilder();
            sb.append("INSERT ").append(table).append(" ").append(key).append(" [ ");
            if (values != null) {
                for (Map.Entry<String, ByteIterator> entry : values.entrySet()) {
                    sb.append(entry.getKey()).append("=").append(entry.getValue()).append(" ");
                }
            }
            sb.append("]");
            System.out.println(sb);
        }
        if (this.count) {
            this.incCounter(inserts, this.hash(table, key, values));
        }
        return Status.OK;
    }

    @Override
    public Status delete(String table, String key) {
        this.delay();
        if (this.verbose) {
            StringBuilder sb = BasicDB.getStringBuilder();
            sb.append("DELETE ").append(table).append(" ").append(key);
            System.out.println(sb);
        }
        if (this.count) {
            this.incCounter(deletes, (table + key).hashCode());
        }
        return Status.OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanup() {
        Object object = MUTEX;
        synchronized (object) {
            int countDown = --counter;
            if (this.count && countDown < 1) {
                System.out.println("[READS], Uniques, " + reads.size());
                System.out.println("[SCANS], Uniques, " + scans.size());
                System.out.println("[UPDATES], Uniques, " + updates.size());
                System.out.println("[INSERTS], Uniques, " + inserts.size());
                System.out.println("[DELETES], Uniques, " + deletes.size());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incCounter(Map<Integer, Integer> map, int hash) {
        Map<Integer, Integer> map2 = map;
        synchronized (map2) {
            Integer ctr = map.get(hash);
            if (ctr == null) {
                map.put(hash, 1);
            } else {
                map.put(hash, ctr + 1);
            }
        }
    }

    protected int hash(String table, String key, Set<String> fields) {
        if (fields == null) {
            return (table + key).hashCode();
        }
        StringBuilder buf = BasicDB.getStringBuilder().append(table).append(key);
        ArrayList<String> sorted = new ArrayList<String>(fields);
        Collections.sort(sorted);
        for (String field : sorted) {
            buf.append(field);
        }
        return buf.toString().hashCode();
    }

    protected int hash(String table, String key, Map<String, ByteIterator> values) {
        if (values == null) {
            return (table + key).hashCode();
        }
        TreeMap<String, ByteIterator> sorted = new TreeMap<String, ByteIterator>(values);
        StringBuilder buf = BasicDB.getStringBuilder().append(table).append(key);
        for (Map.Entry<String, ByteIterator> entry : sorted.entrySet()) {
            entry.getValue().reset();
            buf.append(entry.getKey()).append(entry.getValue().toString());
        }
        return buf.toString().hashCode();
    }

    static {
        TL_STRING_BUILDER = new ThreadLocal<StringBuilder>(){

            @Override
            protected StringBuilder initialValue() {
                return new StringBuilder();
            }
        };
    }
}

