/*
 * Decompiled with CFR 0.152.
 */
package site.gemus.openingstartanimation;

import android.graphics.Bitmap;
import android.graphics.Camera;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import site.gemus.openingstartanimation.DrawStrategy;
import site.gemus.openingstartanimation.WidthAndHeightOfView;

public class RotationDrawStrategy
implements DrawStrategy {
    @Override
    public void drawAppName(Canvas canvas, float fraction, String name, int colorOfAppName, WidthAndHeightOfView widthAndHeightOfView) {
        canvas.save();
        int width = widthAndHeightOfView.getWidth();
        int height = widthAndHeightOfView.getHeight();
        canvas.clipRect((float)(width / 2 - 150), (float)(height / 2 - 80), (float)(width / 2) + 150.0f * fraction, (float)(height / 2) + 65.0f * fraction);
        Paint paint = new Paint();
        paint.setColor(colorOfAppName);
        paint.setTextAlign(Paint.Align.CENTER);
        paint.setTextSize(50.0f);
        canvas.drawText(name, (float)(width / 2), (float)(height / 2 + 50), paint);
        canvas.restore();
    }

    @Override
    public void drawAppIcon(Canvas canvas, float fraction, Drawable icon, int colorOfIcon, WidthAndHeightOfView widthAndHeightOfView) {
        this.drawIcon(canvas, (int)(fraction * 540.0f), ((BitmapDrawable)icon).getBitmap(), widthAndHeightOfView.getWidth(), widthAndHeightOfView.getHeight());
    }

    @Override
    public void drawAppStatement(Canvas canvas, float fraction, String statement, int colorOfStatement, WidthAndHeightOfView widthAndHeightOfView) {
        canvas.save();
        int width = widthAndHeightOfView.getWidth();
        int height = widthAndHeightOfView.getHeight();
        Paint paint = new Paint(1);
        paint.setColor(colorOfStatement);
        paint.setStyle(Paint.Style.STROKE);
        paint.setTextSize(45.0f);
        paint.setTextSkewX(-0.2f);
        paint.setTextAlign(Paint.Align.CENTER);
        RectF rectF = new RectF((float)(width / 4 - statement.length()), (float)(height * 7 / 8), (float)(width * 3), (float)height);
        if (fraction <= 0.6f) {
            Path path = new Path();
            path.addArc(rectF, 193.0f, 40.0f * fraction * 1.67f);
            canvas.drawPath(path, paint);
        } else {
            Path path = new Path();
            path.addArc(rectF, 193.0f, 40.0f);
            canvas.drawPath(path, paint);
            canvas.drawTextOnPath(statement, path, 0.0f, 0.0f, paint);
        }
        canvas.restore();
    }

    private void drawIcon(Canvas canvas, int degree, Bitmap icon, int width, int height) {
        if (degree <= 180) {
            this.drawIconOne(canvas, (float)degree / 180.0f, icon, width, height);
        }
        if (degree > 180 && degree <= 360) {
            this.drawIconTwo(canvas, degree - 180, icon, width, height);
        }
        if (degree > 360 && degree <= 540) {
            this.drawIconThree(canvas, degree - 360, icon, width, height);
        }
    }

    private void drawIconOne(Canvas canvas, float fraction, Bitmap icon, int width, int height) {
        Camera camera = new Camera();
        Paint paint = new Paint(1);
        canvas.save();
        int centerX = width / 2;
        int centerY = height / 2 - 200;
        int x = centerX - icon.getWidth() / 2;
        int y = centerY - icon.getHeight() / 2;
        Matrix matrix = new Matrix();
        matrix.postScale(1.7f, 1.7f, (float)centerX, (float)centerY);
        canvas.concat(matrix);
        canvas.clipRect((float)x, (float)y, (float)x + (float)icon.getWidth() * fraction * 0.5f, (float)y + (float)icon.getHeight() * fraction * 0.5f);
        canvas.translate((float)centerX, (float)centerY);
        camera.save();
        camera.rotateX(180.0f);
        camera.rotateY(-180.0f);
        camera.applyToCanvas(canvas);
        camera.restore();
        canvas.translate((float)(-centerX), (float)(-centerY));
        canvas.drawBitmap(icon, (float)x, (float)y, paint);
        canvas.restore();
    }

    private void drawIconTwo(Canvas canvas, int degree, Bitmap icon, int width, int height) {
        Camera camera = new Camera();
        Paint paint = new Paint(1);
        int centerX = width / 2;
        int centerY = height / 2 - 200;
        int x = centerX - icon.getWidth() / 2;
        int y = centerY - icon.getHeight() / 2;
        Matrix matrix = new Matrix();
        matrix.postScale(1.7f, 1.7f, (float)centerX, (float)centerY);
        canvas.save();
        canvas.concat(matrix);
        canvas.clipRect(x, y, x + icon.getWidth() / 2, y + icon.getHeight() / 2);
        canvas.translate((float)centerX, (float)centerY);
        camera.save();
        camera.rotateX(180.0f);
        camera.applyToCanvas(canvas);
        camera.restore();
        canvas.translate((float)(-centerX), (float)(-centerY));
        canvas.drawBitmap(icon, (float)x, (float)y, paint);
        canvas.restore();
        canvas.save();
        canvas.concat(matrix);
        if (degree <= 90) {
            canvas.clipRect(x, y, x + icon.getWidth() / 2, y + icon.getHeight() / 2);
        } else {
            canvas.clipRect(x + icon.getWidth() / 2, y, x + icon.getWidth(), y + icon.getHeight() / 2);
        }
        canvas.translate((float)centerX, (float)centerY);
        camera.save();
        camera.rotateX(180.0f);
        camera.rotateY((float)(180 - degree));
        camera.applyToCanvas(canvas);
        camera.restore();
        canvas.translate((float)(-centerX), (float)(-centerY));
        canvas.drawBitmap(icon, (float)x, (float)y, paint);
        canvas.restore();
    }

    private void drawIconThree(Canvas canvas, int degree, Bitmap icon, int width, int height) {
        Camera camera = new Camera();
        Paint paint = new Paint(1);
        int centerX = width / 2;
        int centerY = height / 2 - 200;
        int x = centerX - icon.getWidth() / 2;
        int y = centerY - icon.getHeight() / 2;
        Matrix matrix = new Matrix();
        matrix.postScale(1.7f, 1.7f, (float)centerX, (float)centerY);
        canvas.save();
        canvas.concat(matrix);
        canvas.clipRect(x, y, x + icon.getWidth(), y + icon.getHeight() / 2);
        canvas.drawBitmap(icon, (float)x, (float)y, paint);
        canvas.restore();
        canvas.save();
        canvas.concat(matrix);
        if (degree <= 90) {
            canvas.clipRect(x, y, x + icon.getWidth(), y + icon.getHeight() / 2);
        } else {
            canvas.clipRect(x, y + icon.getHeight() / 2, x + icon.getWidth(), y + icon.getHeight());
        }
        canvas.translate((float)centerX, (float)centerY);
        camera.save();
        camera.rotateX((float)(180 - degree));
        camera.applyToCanvas(canvas);
        camera.restore();
        canvas.translate((float)(-centerX), (float)(-centerY));
        canvas.drawBitmap(icon, (float)x, (float)y, paint);
        canvas.restore();
    }
}

