/*
 * Decompiled with CFR 0.152.
 */
package site.gemus.openingstartanimation;

import android.animation.ObjectAnimator;
import android.app.ActionBar;
import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageManager;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Message;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import java.lang.ref.SoftReference;
import java.util.Timer;
import java.util.TimerTask;
import site.gemus.openingstartanimation.DelegateRecycleView;
import site.gemus.openingstartanimation.DrawStrategy;
import site.gemus.openingstartanimation.NormalDrawStrategy;
import site.gemus.openingstartanimation.WidthAndHeightOfView;

public class OpeningStartAnimation
extends View {
    private long animationInterval = 1500L;
    private long animationFinishTime = 350L;
    private WidthAndHeightOfView mWidthAndHeightOfView;
    private int colorOfBackground = -1;
    private float fraction;
    private Drawable mDrawable = null;
    private int colorOfAppIcon = Color.parseColor((String)"#00897b");
    private String appName = "";
    private int colorOfAppName = Color.parseColor((String)"#00897b");
    private String appStatement = "";
    private int colorOfAppStatement = Color.parseColor((String)"#607D8B");
    private DelegateRecycleView mDelegateRecycleView;
    private DrawStrategy mDrawStrategy = new NormalDrawStrategy();
    private static final int FINISHANIMATION = 1;

    private OpeningStartAnimation(Context context) {
        super(context);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
        this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.mWidthAndHeightOfView = new WidthAndHeightOfView();
        PackageManager packageManager = context.getPackageManager();
        this.mDrawable = context.getApplicationInfo().loadIcon(packageManager);
        this.appName = (String)packageManager.getApplicationLabel(context.getApplicationInfo());
        this.appStatement = "Sample Statement";
    }

    private void setFraction(float fraction) {
        this.fraction = fraction;
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        canvas.drawColor(this.colorOfBackground);
        super.onDraw(canvas);
        this.mWidthAndHeightOfView.setHeight(this.getHeight());
        this.mWidthAndHeightOfView.setWidth(this.getWidth());
        this.mDrawStrategy.drawAppIcon(canvas, this.fraction, this.mDrawable, this.colorOfAppIcon, this.mWidthAndHeightOfView);
        this.mDrawStrategy.drawAppName(canvas, this.fraction, this.appName, this.colorOfAppName, this.mWidthAndHeightOfView);
        this.mDrawStrategy.drawAppStatement(canvas, this.fraction, this.appStatement, this.colorOfAppStatement, this.mWidthAndHeightOfView);
    }

    public void show(Activity mactivity) {
        ActionBar actionBar;
        SoftReference<Activity> softReference = new SoftReference<Activity>(mactivity);
        final Activity activity = softReference.get();
        View decorView = activity.getWindow().getDecorView();
        decorView.setSystemUiVisibility(4);
        if (activity instanceof AppCompatActivity) {
            actionBar = ((AppCompatActivity)activity).getSupportActionBar();
            if (actionBar != null) {
                actionBar.hide();
            }
        } else {
            actionBar = activity.getActionBar();
            if (actionBar != null) {
                actionBar.hide();
            }
        }
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-1, -1);
        activity.addContentView((View)this, layoutParams);
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"fraction", (float[])new float[]{0.0f, 1.0f});
        objectAnimator.setDuration(this.animationInterval - 50L);
        objectAnimator.start();
        final Handler handler = new Handler(new Handler.Callback(){

            public boolean handleMessage(Message message) {
                if (message.what == 1) {
                    OpeningStartAnimation.this.moveAnimation(activity);
                }
                return false;
            }
        });
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                Message message = new Message();
                message.what = 1;
                handler.sendMessage(message);
            }
        }, this.animationInterval);
    }

    private void moveAnimation(Activity activity) {
        View decorView = activity.getWindow().getDecorView();
        decorView.setSystemUiVisibility(0);
        if (activity instanceof AppCompatActivity) {
            android.support.v7.app.ActionBar actionBar = ((AppCompatActivity)activity).getSupportActionBar();
            if (actionBar != null) {
                actionBar.show();
            }
        } else {
            ActionBar actionBar = activity.getActionBar();
            if (actionBar != null) {
                actionBar.show();
            }
        }
        this.animate().scaleX(0.0f).scaleY(0.0f).withLayer().alpha(0.0f).setDuration(this.animationFinishTime);
        this.mDelegateRecycleView.finishAnimation();
    }

    public static final class Builder
    implements DelegateRecycleView {
        OpeningStartAnimation mOpeningStartAnimation;

        public Builder(Context context) {
            this.mOpeningStartAnimation = new OpeningStartAnimation(context);
            this.mOpeningStartAnimation.mDelegateRecycleView = this;
        }

        public Builder setAnimationInterval(long animationInterval) {
            this.mOpeningStartAnimation.animationInterval = animationInterval;
            return this;
        }

        public Builder setAnimationFinishTime(long animationFinishTime) {
            this.mOpeningStartAnimation.animationFinishTime = animationFinishTime;
            return this;
        }

        public Builder setAppIcon(Drawable drawable) {
            this.mOpeningStartAnimation.mDrawable = drawable;
            return this;
        }

        public Builder setColorOfAppIcon(int colorOfAppIcon) {
            this.mOpeningStartAnimation.colorOfAppIcon = colorOfAppIcon;
            return this;
        }

        public Builder setAppName(String appName) {
            this.mOpeningStartAnimation.appName = appName;
            return this;
        }

        public Builder setColorOfAppName(int colorOfAppName) {
            this.mOpeningStartAnimation.colorOfAppName = colorOfAppName;
            return this;
        }

        public Builder setAppStatement(String appStatement) {
            this.mOpeningStartAnimation.appStatement = appStatement;
            return this;
        }

        public Builder setColorOfAppStatement(int colorOfAppStatement) {
            this.mOpeningStartAnimation.colorOfAppStatement = colorOfAppStatement;
            return this;
        }

        public Builder setColorOfBackground(int colorOfBackground) {
            this.mOpeningStartAnimation.colorOfBackground = colorOfBackground;
            return this;
        }

        public Builder setDrawStategy(DrawStrategy drawStrategy) {
            this.mOpeningStartAnimation.mDrawStrategy = drawStrategy;
            return this;
        }

        public OpeningStartAnimation create() {
            return this.mOpeningStartAnimation;
        }

        @Override
        public void finishAnimation() {
            this.mOpeningStartAnimation = null;
        }
    }
}

