/*
 * Decompiled with CFR 0.152.
 */
package site.gemus.openingstartanimation;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import site.gemus.openingstartanimation.DrawStrategy;
import site.gemus.openingstartanimation.WidthAndHeightOfView;

public class NormalDrawStrategy
implements DrawStrategy {
    @Override
    public void drawAppName(Canvas canvas, float fraction, String name, int colorOfAppName, WidthAndHeightOfView widthAndHeightOfView) {
        canvas.save();
        int width = widthAndHeightOfView.getWidth();
        int height = widthAndHeightOfView.getHeight();
        Paint paint = new Paint();
        paint.setColor(colorOfAppName);
        paint.setTextAlign(Paint.Align.CENTER);
        paint.setTextSize(50.0f);
        canvas.drawText(name, (float)(width / 2), (float)(height / 2 + 50), paint);
        canvas.restore();
    }

    @Override
    public void drawAppIcon(Canvas canvas, float fraction, Drawable icon, int colorOfIcon, WidthAndHeightOfView widthAndHeightOfView) {
        canvas.save();
        int width = widthAndHeightOfView.getWidth();
        int height = widthAndHeightOfView.getHeight();
        Paint paint = new Paint(1);
        BitmapDrawable bitmapDrawable = (BitmapDrawable)icon;
        Bitmap bitmap = bitmapDrawable.getBitmap();
        int bitmapWidth = bitmap.getWidth();
        int bitmapHeight = bitmap.getHeight();
        int radius = bitmapWidth * 3 / 2;
        int centerX = width / 2 + bitmapWidth / 2;
        int centerY = height / 2 - 100;
        if ((double)fraction <= 0.6) {
            Path path = new Path();
            Matrix matrix = new Matrix();
            matrix.postScale(1.2f, 1.2f, (float)(centerX - bitmapWidth / 2), (float)(centerY - bitmapHeight / 2));
            path.addCircle((float)centerX, (float)centerY, (float)radius * (fraction - 0.1f) * 2.0f, Path.Direction.CW);
            canvas.concat(matrix);
            canvas.clipPath(path);
            canvas.drawBitmap(bitmap, (float)(centerX - bitmapWidth), (float)(centerY - bitmapHeight), paint);
        } else {
            Matrix matrix = new Matrix();
            matrix.postScale(1.2f + 0.5f * (fraction - 0.6f) * 2.5f, 1.2f + 0.5f * (fraction - 0.6f) * 2.5f, (float)(centerX - bitmapWidth / 2), (float)(centerY - bitmapHeight / 2));
            canvas.concat(matrix);
            canvas.drawBitmap(bitmap, (float)(centerX - bitmapWidth), (float)(centerY - bitmapHeight), paint);
        }
        canvas.restore();
    }

    @Override
    public void drawAppStatement(Canvas canvas, float fraction, String statement, int colorOfStatement, WidthAndHeightOfView widthAndHeightOfView) {
        canvas.save();
        int width = widthAndHeightOfView.getWidth();
        int height = widthAndHeightOfView.getHeight();
        Paint paint = new Paint(1);
        paint.setColor(colorOfStatement);
        paint.setStyle(Paint.Style.STROKE);
        paint.setTextSize(45.0f);
        paint.setTextSkewX(-0.2f);
        paint.setTextAlign(Paint.Align.CENTER);
        RectF rectF = new RectF((float)(width / 4 - statement.length()), (float)(height * 7 / 8), (float)(width * 3), (float)height);
        if (fraction <= 0.6f) {
            Path path = new Path();
            path.addArc(rectF, 193.0f, 40.0f * fraction * 1.67f);
            canvas.drawPath(path, paint);
        } else {
            Path path = new Path();
            path.addArc(rectF, 193.0f, 40.0f);
            canvas.drawPath(path, paint);
            canvas.drawTextOnPath(statement, path, 0.0f, 0.0f, paint);
        }
        canvas.restore();
    }
}

