/*
 * Decompiled with CFR 0.152.
 */
package site.gemus.openingstartanimation;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import site.gemus.openingstartanimation.DrawStrategy;
import site.gemus.openingstartanimation.WidthAndHeightOfView;

public class LineDrawStrategy
implements DrawStrategy {
    @Override
    public void drawAppName(Canvas canvas, float fraction, String name, int colorOfAppName, WidthAndHeightOfView widthAndHeightOfView) {
        canvas.save();
        Paint paint = new Paint(1);
        paint.setColor(colorOfAppName);
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeWidth(5.0f);
        paint.setTextSize(50.0f);
        paint.setStrokeJoin(Paint.Join.ROUND);
        paint.setTextAlign(Paint.Align.LEFT);
        float x = widthAndHeightOfView.getWidth() / 2;
        int centerY = widthAndHeightOfView.getHeight() / 2;
        float y = centerY - 275;
        Path path = new Path();
        path.moveTo(x, y);
        if ((double)fraction <= 0.5) {
            path.lineTo(x, y + (float)(25 + name.length() + 250) * (fraction / 0.5f));
            canvas.drawPath(path, paint);
        } else {
            path.lineTo(x, y + (float)(25 + name.length() + 250) * ((1.0f - fraction) / 0.5f));
            canvas.drawPath(path, paint);
            paint.setStyle(Paint.Style.FILL);
            canvas.drawText(name, x + 20.0f, y + 150.0f, paint);
        }
        canvas.restore();
    }

    @Override
    public void drawAppIcon(Canvas canvas, float fraction, Drawable icon, int colorOfIcon, WidthAndHeightOfView widthAndHeightOfView) {
        int centerX = widthAndHeightOfView.getWidth() / 2;
        int centerY = widthAndHeightOfView.getHeight() / 2;
        Bitmap bitmap = ((BitmapDrawable)icon).getBitmap();
        Paint paint = new Paint(1);
        paint.setColor(colorOfIcon);
        paint.setStrokeWidth(3.0f);
        paint.setStrokeJoin(Paint.Join.ROUND);
        paint.setStyle(Paint.Style.STROKE);
        float bitmapLeft = centerX - 250;
        float bitmapRight = bitmapLeft + (float)bitmap.getWidth() * 1.7f;
        float bitmapTop = centerY - 250;
        float bitmapBottom = bitmapTop + (float)bitmap.getHeight() * 1.7f;
        canvas.save();
        if ((double)fraction <= 0.75) {
            float newfraction = fraction / 0.75f;
            if ((double)newfraction <= 0.25) {
                canvas.drawLine(bitmapLeft, bitmapBottom, bitmapLeft, bitmapBottom - (bitmapBottom - bitmapTop) * (newfraction / 0.25f), paint);
            } else {
                canvas.drawLine(bitmapLeft, bitmapBottom, bitmapLeft, bitmapTop, paint);
            }
            if ((double)newfraction > 0.25) {
                if ((double)newfraction <= 0.5) {
                    canvas.drawLine(bitmapLeft, bitmapTop, bitmapLeft + (bitmapRight - bitmapLeft) * ((newfraction - 0.25f) / 0.25f), bitmapTop, paint);
                } else {
                    canvas.drawLine(bitmapLeft, bitmapTop, bitmapRight, bitmapTop, paint);
                }
            }
            if ((double)newfraction > 0.5) {
                if ((double)newfraction <= 0.75) {
                    canvas.drawLine(bitmapRight, bitmapTop, bitmapRight, bitmapTop + (bitmapBottom - bitmapTop) * ((newfraction - 0.5f) / 0.25f), paint);
                } else {
                    canvas.drawLine(bitmapRight, bitmapTop, bitmapRight, bitmapBottom, paint);
                }
            }
            if ((double)newfraction > 0.75) {
                if (newfraction <= 1.0f) {
                    canvas.drawLine(bitmapRight, bitmapBottom, bitmapRight - (bitmapRight - bitmapLeft) * ((newfraction - 0.75f) / 0.25f), bitmapBottom, paint);
                } else {
                    canvas.drawLine(bitmapRight, bitmapBottom, bitmapLeft, bitmapBottom, paint);
                }
            }
        }
        canvas.restore();
        canvas.save();
        if ((double)fraction > 0.75) {
            canvas.clipRect(bitmapLeft + (float)bitmap.getWidth() / 2.0f * ((1.0f - fraction) / 0.25f), bitmapTop + (float)bitmap.getHeight() / 2.0f * ((1.0f - fraction) / 0.25f), bitmapRight - (float)bitmap.getWidth() / 2.0f * ((1.0f - fraction) / 0.25f), bitmapBottom - (float)bitmap.getHeight() / 2.0f * ((1.0f - fraction) / 0.25f));
            Matrix matrix = new Matrix();
            matrix.postScale(1.7f, 1.7f, (bitmapLeft + bitmapRight) * 0.5f, (bitmapTop + bitmapBottom) * 0.5f);
            canvas.concat(matrix);
            canvas.drawBitmap(bitmap, (bitmapLeft + bitmapRight) / 2.0f - (float)(bitmap.getWidth() / 2), (bitmapTop + bitmapBottom) / 2.0f - (float)(bitmap.getHeight() / 2), paint);
        }
        canvas.restore();
    }

    @Override
    public void drawAppStatement(Canvas canvas, float fraction, String statement, int colorOfStatement, WidthAndHeightOfView widthAndHeightOfView) {
        canvas.save();
        int width = widthAndHeightOfView.getWidth();
        int height = widthAndHeightOfView.getHeight();
        Paint paint = new Paint(1);
        paint.setColor(colorOfStatement);
        paint.setStyle(Paint.Style.STROKE);
        paint.setTextSize(45.0f);
        paint.setTextSkewX(-0.2f);
        paint.setTextAlign(Paint.Align.CENTER);
        RectF rectF = new RectF((float)(width / 4 - statement.length()), (float)(height * 7 / 8), (float)(width * 3), (float)height);
        if (fraction <= 0.6f) {
            Path path = new Path();
            path.addArc(rectF, 193.0f, 40.0f * fraction * 1.67f);
            canvas.drawPath(path, paint);
        } else {
            Path path = new Path();
            path.addArc(rectF, 193.0f, 40.0f);
            canvas.drawPath(path, paint);
            canvas.drawTextOnPath(statement, path, 0.0f, 0.0f, paint);
        }
        canvas.restore();
    }
}

