/*
 * Decompiled with CFR 0.152.
 */
package sing.widget;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.support.v7.widget.TintTypedArray;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;
import sing.switchpage.R;

public class SwitchPage
extends LinearLayout {
    private OnClickListener listener;
    private LayoutInflater inflater;
    private LinearLayout parent;
    private LinearLayout view;
    private List<TextView> list = new ArrayList<TextView>();
    private String titles = "1,1";
    private int fillColor = Color.parseColor((String)"#00000000");
    private int pressColor = Color.parseColor((String)"#FFFFFF");
    private int radius = 8;
    private int strokeWidth = 1;
    private int strokeColor = Color.parseColor((String)"#FFFFFF");
    private int textColor = Color.parseColor((String)"#FFFFFF");
    private int textSelectColor = Color.parseColor((String)"#000000");
    private int textSize = 14;

    public SwitchPage(Context context, Builder b) {
        super(context);
        this.inflater = LayoutInflater.from((Context)context);
        this.titles = b.titles;
        this.fillColor = b.fillColor;
        this.pressColor = b.pressColor;
        this.radius = b.radius;
        this.strokeWidth = b.strokeWidth;
        this.strokeColor = b.strokeColor;
        this.textColor = b.textColor;
        this.textSelectColor = b.textSelectColor;
        this.textSize = b.textSize;
        this.initView(context);
    }

    public SwitchPage(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SwitchPage(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.inflater = LayoutInflater.from((Context)context);
        if (attrs != null) {
            TintTypedArray a = TintTypedArray.obtainStyledAttributes((Context)context, (AttributeSet)attrs, (int[])R.styleable.SwitchPage, (int)defStyleAttr, (int)0);
            this.titles = a.getString(R.styleable.SwitchPage_sp_titles);
            this.fillColor = a.getColor(R.styleable.SwitchPage_sp_fill_color, Color.parseColor((String)"#00000000"));
            this.pressColor = a.getColor(R.styleable.SwitchPage_sp_press_color, Color.parseColor((String)"#FFFFFF"));
            this.radius = a.getDimensionPixelSize(R.styleable.SwitchPage_sp_radius, 8);
            this.strokeWidth = a.getDimensionPixelSize(R.styleable.SwitchPage_sp_stroke_width, 1);
            this.strokeColor = a.getColor(R.styleable.SwitchPage_sp_stroke_color, Color.parseColor((String)"#FFFFFF"));
            this.textColor = a.getColor(R.styleable.SwitchPage_sp_text_color, Color.parseColor((String)"#FFFFFF"));
            this.textSelectColor = a.getColor(R.styleable.SwitchPage_sp_text_select_color, Color.parseColor((String)"#000000"));
            this.textSize = a.getDimensionPixelSize(R.styleable.SwitchPage_sp_text_size, 14);
            a.recycle();
            this.initView(context);
        }
    }

    private void initView(final Context context) {
        this.view = (LinearLayout)this.inflater.inflate(R.layout.switch_page, (ViewGroup)this, true);
        this.parent = (LinearLayout)this.view.findViewById(R.id.ll);
        this.view.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                SwitchPage.this.view.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                SwitchPage.this.show(context, SwitchPage.this.view.getWidth(), SwitchPage.this.view.getHeight());
            }
        });
        this.view.setBackground((Drawable)this.getParentBackground());
    }

    public void show(Context context, int width, int height) {
        if (TextUtils.isEmpty((CharSequence)this.titles)) {
            return;
        }
        String[] title = this.titles.split(",");
        int size = title.length;
        for (int i = 0; i < size; ++i) {
            TextView tv = (TextView)this.inflater.inflate(R.layout.child_view, null);
            tv.setPadding(15, 0, 15, 0);
            tv.setLayoutParams(new ViewGroup.LayoutParams(-2, height));
            tv.setText((CharSequence)title[i]);
            tv.setTextColor(this.textColor);
            tv.setTextSize(2, (float)this.textSize);
            if (i == 0) {
                tv.setBackground((Drawable)this.getLeftBackground());
            } else if (i == size - 1) {
                tv.setBackground((Drawable)this.getRightBackground());
            } else {
                tv.setBackground((Drawable)this.getCenterBackground());
            }
            final int position = i;
            tv.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    SwitchPage.this.setClick(position);
                }
            });
            this.list.add(tv);
            this.parent.addView((View)tv);
            if (i == size - 1) continue;
            View line = new View(context);
            line.setLayoutParams(new ViewGroup.LayoutParams(this.strokeWidth, -1));
            line.setBackgroundColor(this.strokeColor);
            this.parent.addView(line);
        }
        this.list.get(0).setSelected(true);
        this.list.get(0).setTextColor(this.textSelectColor);
    }

    public void setClick(int position) {
        for (int i = 0; i < this.list.size(); ++i) {
            this.list.get(i).setSelected(false);
            this.list.get(i).setTextColor(this.textColor);
        }
        this.list.get(position).setSelected(true);
        this.list.get(position).setTextColor(this.textSelectColor);
        if (this.listener != null) {
            this.listener.selected(position, this.list.get(position).getText().toString());
        }
    }

    public void setOnClickListener(OnClickListener listener) {
        this.listener = listener;
    }

    private GradientDrawable getParentBackground() {
        GradientDrawable parentBackground = new GradientDrawable();
        parentBackground.setColor(this.fillColor);
        parentBackground.setCornerRadius((float)this.radius);
        parentBackground.setStroke(this.strokeWidth, this.strokeColor);
        return parentBackground;
    }

    private StateListDrawable getLeftBackground() {
        GradientDrawable background = new GradientDrawable();
        background.setColor(this.fillColor);
        background.setCornerRadii(new float[]{this.radius, this.radius, 0.0f, 0.0f, 0.0f, 0.0f, this.radius, this.radius});
        background.setStroke(0, this.strokeColor);
        GradientDrawable backgroundPress = new GradientDrawable();
        backgroundPress.setColor(this.pressColor);
        backgroundPress.setCornerRadii(new float[]{this.radius, this.radius, 0.0f, 0.0f, 0.0f, 0.0f, this.radius, this.radius});
        backgroundPress.setStroke(0, this.strokeColor);
        StateListDrawable leftBackground = new StateListDrawable();
        leftBackground.addState(new int[]{16842919}, (Drawable)backgroundPress);
        leftBackground.addState(new int[]{0x10100A1}, (Drawable)backgroundPress);
        leftBackground.addState(new int[]{-16842913}, (Drawable)background);
        leftBackground.addState(new int[]{-16842919}, (Drawable)background);
        return leftBackground;
    }

    private StateListDrawable getRightBackground() {
        GradientDrawable background = new GradientDrawable();
        background.setColor(this.fillColor);
        background.setCornerRadii(new float[]{0.0f, 0.0f, this.radius, this.radius, this.radius, this.radius, 0.0f, 0.0f});
        background.setStroke(0, this.strokeColor);
        GradientDrawable backgroundPress = new GradientDrawable();
        backgroundPress.setColor(this.pressColor);
        backgroundPress.setCornerRadii(new float[]{0.0f, 0.0f, this.radius, this.radius, this.radius, this.radius, 0.0f, 0.0f});
        backgroundPress.setStroke(0, this.strokeColor);
        StateListDrawable rightBackground = new StateListDrawable();
        rightBackground.addState(new int[]{16842919}, (Drawable)backgroundPress);
        rightBackground.addState(new int[]{0x10100A1}, (Drawable)backgroundPress);
        rightBackground.addState(new int[]{-16842913}, (Drawable)background);
        rightBackground.addState(new int[]{-16842919}, (Drawable)background);
        return rightBackground;
    }

    private StateListDrawable getCenterBackground() {
        GradientDrawable background = new GradientDrawable();
        background.setColor(this.fillColor);
        background.setCornerRadii(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f});
        background.setStroke(0, this.strokeColor);
        GradientDrawable backgroundPress = new GradientDrawable();
        backgroundPress.setColor(this.pressColor);
        backgroundPress.setCornerRadii(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f});
        backgroundPress.setStroke(0, this.strokeColor);
        StateListDrawable centerBackground = new StateListDrawable();
        centerBackground.addState(new int[]{16842919}, (Drawable)backgroundPress);
        centerBackground.addState(new int[]{0x10100A1}, (Drawable)backgroundPress);
        centerBackground.addState(new int[]{-16842913}, (Drawable)background);
        centerBackground.addState(new int[]{-16842919}, (Drawable)background);
        return centerBackground;
    }

    public static interface OnClickListener {
        public void selected(int var1, String var2);
    }

    public static class Builder {
        private Activity context;
        private String titles;
        private int fillColor;
        private int pressColor;
        private int radius;
        private int strokeWidth;
        private int strokeColor;
        private int textColor;
        private int textSelectColor;
        private int textSize;

        public Builder(Activity context) {
            this.context = context;
        }

        public Builder setTitles(String titles) {
            this.titles = titles;
            return this;
        }

        public Builder setFillColor(String fillColor) {
            this.fillColor = Color.parseColor((String)fillColor);
            return this;
        }

        public Builder setPressColor(String pressColor) {
            this.pressColor = Color.parseColor((String)pressColor);
            return this;
        }

        public Builder setRadius(int radius) {
            this.radius = radius;
            return this;
        }

        public Builder setStrokeWidth(int strokeWidth) {
            this.strokeWidth = strokeWidth;
            return this;
        }

        public Builder setStrokeColor(String strokeColor) {
            this.strokeColor = Color.parseColor((String)strokeColor);
            return this;
        }

        public Builder setTextColor(String textColor) {
            this.textColor = Color.parseColor((String)textColor);
            return this;
        }

        public Builder setTextSelectColor(String textSelectColor) {
            this.textSelectColor = Color.parseColor((String)textSelectColor);
            return this;
        }

        public Builder setTextSize(int textSize) {
            this.textSize = textSize;
            return this;
        }

        public SwitchPage build() {
            return new SwitchPage((Context)this.context, this);
        }
    }
}

