/*
 * Decompiled with CFR 0.152.
 */
package sing.widget;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.support.v7.widget.TintTypedArray;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;
import sing.switchpage.R;

public class SwitchPage
extends LinearLayout
implements View.OnClickListener {
    private OnClickListener listener;
    private LayoutInflater inflater;
    private LinearLayout parent;
    private LinearLayout view;
    private List<TextView> list = new ArrayList<TextView>();
    private int selectedPosition = 0;
    private String titles = "1,1";
    private int fillColor = Color.parseColor((String)"#00000000");
    private int pressColor = Color.parseColor((String)"#FFFFFF");
    private int radius = 8;
    private int strokeWidth = 1;
    private int strokeColor = Color.parseColor((String)"#FFFFFF");
    private int textColor = Color.parseColor((String)"#FFFFFF");
    private int textSelectColor = Color.parseColor((String)"#000000");
    private int textSize = 14;

    public SwitchPage(Context context, Builder b) {
        super(context);
        this.inflater = LayoutInflater.from((Context)context);
        this.titles = b.titles;
        this.fillColor = b.fillColor;
        this.pressColor = b.pressColor;
        this.radius = b.radius;
        this.strokeWidth = b.strokeWidth;
        this.strokeColor = b.strokeColor;
        this.textColor = b.textColor;
        this.textSelectColor = b.textSelectColor;
        this.textSize = b.textSize;
        this.initView();
    }

    public SwitchPage(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SwitchPage(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.inflater = LayoutInflater.from((Context)context);
        if (attrs != null) {
            TintTypedArray a = TintTypedArray.obtainStyledAttributes((Context)context, (AttributeSet)attrs, (int[])R.styleable.SwitchPage, (int)defStyleAttr, (int)0);
            this.titles = a.getString(R.styleable.SwitchPage_titles);
            this.fillColor = a.getColor(R.styleable.SwitchPage_fill_color, Color.parseColor((String)"#00000000"));
            this.pressColor = a.getColor(R.styleable.SwitchPage_press_color, Color.parseColor((String)"#FFFFFF"));
            this.radius = a.getDimensionPixelSize(R.styleable.SwitchPage_radius, 8);
            this.strokeWidth = a.getDimensionPixelSize(R.styleable.SwitchPage_stroke_width, 1);
            this.strokeColor = a.getColor(R.styleable.SwitchPage_stroke_color, Color.parseColor((String)"#FFFFFF"));
            this.textColor = a.getColor(R.styleable.SwitchPage_text_color, Color.parseColor((String)"#FFFFFF"));
            this.textSelectColor = a.getColor(R.styleable.SwitchPage_text_select_color, Color.parseColor((String)"#000000"));
            this.textSize = a.getDimensionPixelSize(R.styleable.SwitchPage_text_size, 14);
            a.recycle();
            this.initView();
        }
    }

    private void initView() {
        this.view = (LinearLayout)this.inflater.inflate(R.layout.switch_page, (ViewGroup)this, true);
        this.parent = (LinearLayout)this.view.findViewById(R.id.ll);
        this.view.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                SwitchPage.this.view.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                SwitchPage.this.show(SwitchPage.this.view.getWidth(), SwitchPage.this.view.getHeight());
            }
        });
        this.view.setBackground((Drawable)this.getParentBackground());
    }

    public void show(int width, int height) {
        if (TextUtils.isEmpty((CharSequence)this.titles)) {
            return;
        }
        String[] title = this.titles.split(",");
        int size = title.length;
        for (int i = 0; i < size; ++i) {
            TextView tv = (TextView)this.inflater.inflate(R.layout.child_view, null);
            tv.setLayoutParams(new ViewGroup.LayoutParams(width / size, height));
            tv.setText((CharSequence)title[i]);
            tv.setTextColor(this.textColor);
            tv.setTextSize(0, (float)this.textSize);
            if (i == 0) {
                tv.setBackground((Drawable)this.getLeftBackground());
            } else if (i == size - 1) {
                tv.setBackground((Drawable)this.getRightBackground());
            } else {
                tv.setBackground((Drawable)this.getCenterBackground());
            }
            tv.setOnClickListener((View.OnClickListener)this);
            this.list.add(tv);
            this.parent.addView((View)tv);
        }
        this.list.get(this.selectedPosition).setSelected(true);
        this.list.get(this.selectedPosition).setTextColor(this.textSelectColor);
    }

    public void onClick(View v) {
        this.list.get(this.selectedPosition).setSelected(false);
        this.list.get(this.selectedPosition).setTextColor(this.textColor);
        for (int i = 0; i < this.list.size(); ++i) {
            if (this.list.get(i) != v) continue;
            this.selectedPosition = i;
        }
        this.list.get(this.selectedPosition).setSelected(true);
        this.list.get(this.selectedPosition).setTextColor(this.textSelectColor);
        if (this.listener != null) {
            this.listener.selected(this.selectedPosition, this.list.get(this.selectedPosition).getText().toString());
        }
    }

    public void setOnClickListener(OnClickListener listener) {
        this.listener = listener;
    }

    private GradientDrawable getParentBackground() {
        GradientDrawable parentBackground = new GradientDrawable();
        parentBackground.setColor(this.fillColor);
        parentBackground.setCornerRadius((float)this.radius);
        parentBackground.setStroke(this.strokeWidth, this.strokeColor);
        return parentBackground;
    }

    private StateListDrawable getLeftBackground() {
        GradientDrawable background = new GradientDrawable();
        background.setColor(this.fillColor);
        background.setCornerRadii(new float[]{this.radius, this.radius, 0.0f, 0.0f, 0.0f, 0.0f, this.radius, this.radius});
        background.setStroke(0, this.strokeColor);
        GradientDrawable backgroundPress = new GradientDrawable();
        backgroundPress.setColor(this.pressColor);
        backgroundPress.setCornerRadii(new float[]{this.radius, this.radius, 0.0f, 0.0f, 0.0f, 0.0f, this.radius, this.radius});
        backgroundPress.setStroke(0, this.strokeColor);
        StateListDrawable leftBackground = new StateListDrawable();
        leftBackground.addState(new int[]{16842919}, (Drawable)backgroundPress);
        leftBackground.addState(new int[]{0x10100A1}, (Drawable)backgroundPress);
        leftBackground.addState(new int[]{-16842913}, (Drawable)background);
        leftBackground.addState(new int[]{-16842919}, (Drawable)background);
        return leftBackground;
    }

    private StateListDrawable getRightBackground() {
        GradientDrawable background = new GradientDrawable();
        background.setColor(this.fillColor);
        background.setCornerRadii(new float[]{0.0f, 0.0f, this.radius, this.radius, this.radius, this.radius, 0.0f, 0.0f});
        background.setStroke(0, this.strokeColor);
        GradientDrawable backgroundPress = new GradientDrawable();
        backgroundPress.setColor(this.pressColor);
        backgroundPress.setCornerRadii(new float[]{0.0f, 0.0f, this.radius, this.radius, this.radius, this.radius, 0.0f, 0.0f});
        backgroundPress.setStroke(0, this.strokeColor);
        StateListDrawable rightBackground = new StateListDrawable();
        rightBackground.addState(new int[]{16842919}, (Drawable)backgroundPress);
        rightBackground.addState(new int[]{0x10100A1}, (Drawable)backgroundPress);
        rightBackground.addState(new int[]{-16842913}, (Drawable)background);
        rightBackground.addState(new int[]{-16842919}, (Drawable)background);
        return rightBackground;
    }

    private StateListDrawable getCenterBackground() {
        GradientDrawable background = new GradientDrawable();
        background.setColor(this.fillColor);
        background.setCornerRadii(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f});
        background.setStroke(0, this.strokeColor);
        GradientDrawable backgroundPress = new GradientDrawable();
        backgroundPress.setColor(this.pressColor);
        backgroundPress.setCornerRadii(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f});
        backgroundPress.setStroke(0, this.strokeColor);
        StateListDrawable centerBackground = new StateListDrawable();
        centerBackground.addState(new int[]{16842919}, (Drawable)backgroundPress);
        centerBackground.addState(new int[]{0x10100A1}, (Drawable)backgroundPress);
        centerBackground.addState(new int[]{-16842913}, (Drawable)background);
        centerBackground.addState(new int[]{-16842919}, (Drawable)background);
        return centerBackground;
    }

    public static interface OnClickListener {
        public void selected(int var1, String var2);
    }

    public static class Builder {
        private Activity context;
        private String titles;
        private int fillColor;
        private int pressColor;
        private int radius;
        private int strokeWidth;
        private int strokeColor;
        private int textColor;
        private int textSelectColor;
        private int textSize;

        public Builder(Activity context) {
            this.context = context;
        }

        public Builder setTitles(String titles) {
            this.titles = titles;
            return this;
        }

        public Builder setFillColor(String fillColor) {
            this.fillColor = Color.parseColor((String)fillColor);
            return this;
        }

        public Builder setPressColor(String pressColor) {
            this.pressColor = Color.parseColor((String)pressColor);
            return this;
        }

        public Builder setRadius(int radius) {
            this.radius = radius;
            return this;
        }

        public Builder setStrokeWidth(int strokeWidth) {
            this.strokeWidth = strokeWidth;
            return this;
        }

        public Builder setStrokeColor(String strokeColor) {
            this.strokeColor = Color.parseColor((String)strokeColor);
            return this;
        }

        public Builder setTextColor(String textColor) {
            this.textColor = Color.parseColor((String)textColor);
            return this;
        }

        public Builder setTextSelectColor(String textSelectColor) {
            this.textSelectColor = Color.parseColor((String)textSelectColor);
            return this;
        }

        public Builder setTextSize(int textSize) {
            this.textSize = textSize;
            return this;
        }

        public SwitchPage build() {
            return new SwitchPage((Context)this.context, this);
        }
    }
}

