/*
 * Decompiled with CFR 0.152.
 */
package sing.sticky;

import android.support.v7.widget.RecyclerView;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import sing.sticky.StickyRecyclerHeadersAdapter;
import sing.sticky.StickyRecyclerHeadersDecoration;

public class StickyRecyclerHeadersTouchListener
implements RecyclerView.OnItemTouchListener {
    private final GestureDetector mTapDetector;
    private final RecyclerView mRecyclerView;
    private final StickyRecyclerHeadersDecoration mDecor;
    private OnHeaderClickListener mOnHeaderClickListener;

    public StickyRecyclerHeadersTouchListener(RecyclerView recyclerView, StickyRecyclerHeadersDecoration decor) {
        this.mTapDetector = new GestureDetector(recyclerView.getContext(), (GestureDetector.OnGestureListener)new SingleTapDetector());
        this.mRecyclerView = recyclerView;
        this.mDecor = decor;
    }

    public StickyRecyclerHeadersAdapter getAdapter() {
        if (this.mRecyclerView.getAdapter() instanceof StickyRecyclerHeadersAdapter) {
            return (StickyRecyclerHeadersAdapter)this.mRecyclerView.getAdapter();
        }
        throw new IllegalStateException("A RecyclerView with " + StickyRecyclerHeadersTouchListener.class.getSimpleName() + " requires a " + StickyRecyclerHeadersAdapter.class.getSimpleName());
    }

    public void setOnHeaderClickListener(OnHeaderClickListener listener) {
        this.mOnHeaderClickListener = listener;
    }

    public boolean onInterceptTouchEvent(RecyclerView view, MotionEvent e) {
        if (this.mOnHeaderClickListener != null) {
            boolean tapDetectorResponse = this.mTapDetector.onTouchEvent(e);
            if (tapDetectorResponse) {
                return true;
            }
            if (e.getAction() == 0) {
                int position = this.mDecor.findHeaderPositionUnder((int)e.getX(), (int)e.getY());
                return position != -1;
            }
        }
        return false;
    }

    public void onTouchEvent(RecyclerView view, MotionEvent e) {
    }

    public void onRequestDisallowInterceptTouchEvent(boolean disallowIntercept) {
    }

    private class SingleTapDetector
    extends GestureDetector.SimpleOnGestureListener {
        private SingleTapDetector() {
        }

        public boolean onSingleTapUp(MotionEvent e) {
            int position = StickyRecyclerHeadersTouchListener.this.mDecor.findHeaderPositionUnder((int)e.getX(), (int)e.getY());
            if (position != -1) {
                View headerView = StickyRecyclerHeadersTouchListener.this.mDecor.getHeaderView(StickyRecyclerHeadersTouchListener.this.mRecyclerView, position);
                long headerId = StickyRecyclerHeadersTouchListener.this.getAdapter().getHeaderId(position);
                StickyRecyclerHeadersTouchListener.this.mOnHeaderClickListener.onHeaderClick(headerView, position, headerId);
                StickyRecyclerHeadersTouchListener.this.mRecyclerView.playSoundEffect(0);
                headerView.onTouchEvent(e);
                return true;
            }
            return false;
        }

        public boolean onDoubleTap(MotionEvent e) {
            return true;
        }
    }

    public static interface OnHeaderClickListener {
        public void onHeaderClick(View var1, int var2, long var3);
    }
}

