package sing.widget;

import android.animation.LayoutTransition;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.support.constraint.ConstraintLayout;
import android.support.constraint.ConstraintSet;
import android.support.v4.content.ContextCompat;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.transition.TransitionManager;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import java.util.Timer;
import java.util.TimerTask;

import sing.searchlayuot.R;

/**
 * LiangYX
 * SearchLayout
 * 2017/7/10 下午2:29
 * 自定义搜索框
 */
public class SearchLayout extends LinearLayout {

    private int searchTextColor;// 搜索框文字的颜色
    private int searchTextSize;// 搜索框文字的大小
    private int searchTextColorHint;// 搜索框提示文字的颜色
    private int searchButtonColor;// 按钮文字的颜色
    private int searchButtonTextSize;// 按钮文字的大小
    private int searchBackgroundColor;//最外层父控件的背景颜色
    private Drawable searchTextBackground;//搜索框的背景
    private Drawable searchDrawableLeftIcon;// 左边的图标
    private int searchDrawablePadding;// 左边的图标的距离
    private String searchHint = "搜索";// 提示文字
    private boolean searchSingleLine;// 搜索框是否单行显示
    private String searchButtonEmptyTxt = "取消";// 搜索按钮为空字符
    private String searchButtonTxt = "搜索";// 搜索按钮为空字符
    private int searchPadding;// 搜索框距离最外层的距离,若有值，以下4个属性无效
    private int searchPaddingLeft;
    private int searchPaddingTop;
    private int searchPaddingRight;
    private int searchPaddingBottom;
    private int searchHeight;// 搜索框高度
    private int searchImeOption;// 键盘的选项
    private int searchButtonWidth;// 按钮宽度

    public SearchLayout(Context context) {
        this(context, null);
    }

    public SearchLayout(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SearchLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        initAttr(context, attrs, defStyleAttr);
    }

    private ConstraintLayout constraintLayout;
    private EditText et;// 输入框
    private Button bt;// 搜索按钮
    private ConstraintSet constraintSet;
    private LinearLayout parent;// 最外层父控件
    private ImageView ivClear;// 清空
    private boolean isShowButton;// 是否显示右侧的搜索按钮

    private void initAttr(Context context, AttributeSet attrs, int defStyleAttr) {
        LinearLayout.inflate(context, R.layout.search_layout, this);

        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.SearchLayout, defStyleAttr, 0);

        searchTextBackground = array.getDrawable(R.styleable.SearchLayout_search_text_background);
        searchDrawableLeftIcon = array.getDrawable(R.styleable.SearchLayout_search_drawable_left_icon);
        searchBackgroundColor = array.getColor(R.styleable.SearchLayout_search_background_color, Color.parseColor("#f0eff5"));
        searchPadding = array.getDimensionPixelSize(R.styleable.SearchLayout_search_padding, -1);
        searchPaddingLeft = array.getDimensionPixelSize(R.styleable.SearchLayout_search_padding_left, 16);
        searchPaddingTop = array.getDimensionPixelSize(R.styleable.SearchLayout_search_padding_top, 16);
        searchPaddingRight = array.getDimensionPixelSize(R.styleable.SearchLayout_search_padding_right, 16);
        searchPaddingBottom = array.getDimensionPixelSize(R.styleable.SearchLayout_search_padding_bottom, 16);
        searchTextColor = array.getColor(R.styleable.SearchLayout_search_text_color, Color.parseColor("#313131"));
        searchTextSize = array.getDimensionPixelSize(R.styleable.SearchLayout_search_text_size, 28);
        searchTextColorHint = array.getColor(R.styleable.SearchLayout_search_text_color_hint, Color.parseColor("#9a9a9c"));
        searchSingleLine = array.getBoolean(R.styleable.SearchLayout_search_single_line, true);
        searchHint = array.getString(R.styleable.SearchLayout_search_hint);
        searchDrawablePadding = array.getDimensionPixelSize(R.styleable.SearchLayout_search_drawable_padding, 10);
        searchHeight = array.getDimensionPixelSize(R.styleable.SearchLayout_search_height, 70);
        searchButtonColor = array.getColor(R.styleable.SearchLayout_search_button_color, Color.parseColor("#313131"));
        searchButtonTextSize = array.getDimensionPixelSize(R.styleable.SearchLayout_search_button_text_size, 28);
        searchButtonEmptyTxt = array.getString(R.styleable.SearchLayout_search_button_empty_txt);
        searchButtonTxt = array.getString(R.styleable.SearchLayout_search_button_txt);
        searchImeOption = array.getInt(R.styleable.SearchLayout_search_imeOption, -1);
        searchButtonWidth = array.getDimensionPixelSize(R.styleable.SearchLayout_search_button_width, 90);
        isShowButton = array.getBoolean(R.styleable.SearchLayout_search_show_button, true);

        if (searchTextBackground == null)
            searchTextBackground = ContextCompat.getDrawable(context, R.drawable.bg_search);
        if (searchDrawableLeftIcon == null)
            searchDrawableLeftIcon = ContextCompat.getDrawable(context, R.drawable.ic_search);
        if (TextUtils.isEmpty(searchHint))
            searchHint = "搜索";
        if (TextUtils.isEmpty(searchButtonEmptyTxt))
            searchButtonEmptyTxt = "取消";
        if (TextUtils.isEmpty(searchButtonTxt))
            searchButtonTxt = "搜索";

        array.recycle();

        initView();
    }

    private void initView() {
        parent = (LinearLayout) findViewById(R.id.parent);
        et = (EditText) findViewById(R.id.et);

        constraintLayout = (ConstraintLayout) findViewById(R.id.constraint_layout);
        bt = (Button) findViewById(R.id.bt);
        ivClear = (ImageView) findViewById(R.id.iv_clear);

        bt.setVisibility(isShowButton?VISIBLE:GONE);
        setValue();
    }

    private void setValue() {
        et.setTextColor(searchTextColor);
        et.setTextSize(TypedValue.COMPLEX_UNIT_PX,searchTextSize);
        et.setHintTextColor(searchTextColorHint);
        et.setSingleLine(searchSingleLine);
        et.setHint(searchHint);
        if (searchImeOption != -1){
            et.setImeOptions(searchImeOption);
        }
        searchDrawableLeftIcon.setBounds(0, 0, searchHeight/3*2, searchHeight/3*2);
        et.setCompoundDrawablePadding(searchDrawablePadding);
        et.setCompoundDrawables(searchDrawableLeftIcon, null, null, null);

        constraintLayout.setBackground(searchTextBackground);
        constraintLayout.getLayoutParams().height = searchHeight;

        bt.setTextColor(searchButtonColor);
        bt.setTextSize(TypedValue.COMPLEX_UNIT_PX,searchButtonTextSize);
        bt.getLayoutParams().width = searchButtonWidth;

        parent.setBackgroundColor(searchBackgroundColor);
        if (searchPadding != -1){
            parent.setPadding(searchPadding, searchPadding, searchPadding, searchPadding);
        }else{
            parent.setPadding(searchPaddingLeft, searchPaddingTop, searchPaddingRight, searchPaddingBottom);
        }

        ivClear.setVisibility(GONE);

        constraintSet = new ConstraintSet();
        constraintSet.clone(constraintLayout);

        initListener();
    }

    private void initListener() {
        et.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                bt.setText(searchButtonEmptyTxt);
                changeLayout(true);
            }
        });
        constraintLayout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                bt.setText(searchButtonEmptyTxt);
                changeLayout(true);
            }
        });

        bt.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (onSearchListener != null) {
                    String str = bt.getText().toString().trim();
                    onSearchListener.onClick(et.getText().toString().trim(), str.equals(searchButtonTxt));
                }
                if (bt.getText().toString().equals(searchButtonEmptyTxt)) {
                    changeLayout(false);
                    et.setText("");
                } else {
                    setSoftInput(false);
                }
            }
        });

        et.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
                if (textChangeListener != null) {
                    String str = et.getText().toString().trim();
                    textChangeListener.onChange(str);
                }
            }

            @Override
            public void afterTextChanged(Editable s) {
                if (TextUtils.isEmpty(s.toString())) {
                    bt.setText(searchButtonEmptyTxt);
                    ivClear.setVisibility(GONE);
                } else {
                    bt.setText(searchButtonTxt);
                    ivClear.setVisibility(VISIBLE);
                }
            }
        });

        addEditorActionListener();

        ivClear.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                et.setText("");
            }
        });

        setEditTextState(false);
    }

    // 添加键盘回车键监听器
    private void addEditorActionListener() {
        if (searchImeOption != -1){
            et.setOnEditorActionListener(new TextView.OnEditorActionListener() {
                public boolean onEditorAction(TextView v, int actionId, KeyEvent event)  {
                    if (onEditorActionListener != null){
                        onEditorActionListener.onEditorAction(v,actionId,event);
                    }
                    return false;
                }
            });
        }
    }

    // 设置输入框状态，canInput为true是输入框移至左侧，自动弹出键盘，否则反之
    public void changeLayout(boolean canInput) {
        TransitionManager.beginDelayedTransition(constraintLayout);
        parent.setLayoutTransition(canInput ? new LayoutTransition() : null);
        constraintSet.constrainWidth(R.id.et, canInput ? constraintLayout.getLayoutParams().width : LayoutParams.WRAP_CONTENT);
        constraintSet.applyTo(constraintLayout);

        setEditTextState(canInput);
    }

    private void setEditTextState(final boolean isFocusable){
        bt.setVisibility((isFocusable&&isShowButton)?View.VISIBLE:View.GONE);
        et.setFocusable(isFocusable);//可以通过键盘得到焦点
        et.setFocusableInTouchMode(isFocusable);//可以通过触摸得到焦点
        if (isFocusable){
            et.requestFocus();//获取焦点 光标出现
        }else{
            et.clearFocus();
        }

        setSoftInput(isFocusable);
    }

    // 设置键盘弹出、收起
    public void setSoftInput(final boolean isFocusable) {
        new Timer().schedule(new TimerTask() {
            @Override
            public void run() {
                InputMethodManager m = (InputMethodManager)et.getContext().getSystemService(Context.INPUT_METHOD_SERVICE);
                if (isFocusable) {
                    m.showSoftInput(et, InputMethodManager.SHOW_FORCED);
                } else {
                    m.hideSoftInputFromWindow(et.getWindowToken(), 0);
                }
            }
        }, 300);
    }

    // 设置键盘回车键事件
    public void setImeOptions(int imeOptions){
        et.setImeOptions(imeOptions);
        addEditorActionListener();
    }

    private OnSearchListener onSearchListener;// 右边按钮的点击监听
    public void setOnSearchListener(OnSearchListener onSearchListener) {
        this.onSearchListener = onSearchListener;
    }

    private OnTextChangeListener textChangeListener;
    public void setOnTextChangeListener(OnTextChangeListener textChangeListener) {
        this.textChangeListener = textChangeListener;
    }

    private OnEditorActionListener onEditorActionListener;// 键盘回车键
    public void setOnEditorActionListener(OnEditorActionListener onEditorActionListener){
        this.onEditorActionListener = onEditorActionListener;
    }

    public interface OnSearchListener {
        void onClick(String str, boolean isSearch);
    }

    public interface OnTextChangeListener {
        void onChange(String str);
    }

    public interface OnEditorActionListener{
        boolean onEditorAction(TextView v, int actionId, KeyEvent event);
    }
}