/*
 * Decompiled with CFR 0.152.
 */
package sing.widget;

import android.animation.LayoutTransition;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.support.constraint.ConstraintLayout;
import android.support.constraint.ConstraintSet;
import android.support.v4.content.ContextCompat;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.transition.TransitionManager;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.util.Timer;
import java.util.TimerTask;
import sing.searchlayuot.R;

public class SearchLayout
extends LinearLayout {
    private int searchTextColor;
    private int searchTextSize;
    private int searchTextColorHint;
    private int searchButtonColor;
    private int searchButtonTextSize;
    private int searchBackgroundColor;
    private Drawable searchTextBackground;
    private Drawable searchDrawableLeftIcon;
    private int searchDrawablePadding;
    private String searchHint = "\u641c\u7d22";
    private boolean searchSingleLine;
    private String searchButtonEmptyTxt = "\u53d6\u6d88";
    private String searchButtonTxt = "\u641c\u7d22";
    private int searchPadding;
    private int searchPaddingLeft;
    private int searchPaddingTop;
    private int searchPaddingRight;
    private int searchPaddingBottom;
    private int searchHeight;
    private int searchImeOption;
    private int searchButtonWidth;
    private ConstraintLayout constraintLayout;
    private EditText et;
    private Button bt;
    private ConstraintSet constraintSet;
    private LinearLayout parent;
    private ImageView ivClear;
    private OnSearchListener onSearchListener;
    private OnEditorActionListener onEditorActionListener;

    public SearchLayout(Context context) {
        this(context, null);
    }

    public SearchLayout(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SearchLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttr(context, attrs, defStyleAttr);
    }

    private void initAttr(Context context, AttributeSet attrs, int defStyleAttr) {
        LinearLayout.inflate((Context)context, (int)R.layout.search_layout, (ViewGroup)this);
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.SearchLayout, defStyleAttr, 0);
        this.searchTextBackground = array.getDrawable(R.styleable.SearchLayout_search_text_background);
        this.searchDrawableLeftIcon = array.getDrawable(R.styleable.SearchLayout_search_drawable_left_icon);
        this.searchBackgroundColor = array.getColor(R.styleable.SearchLayout_search_background_color, Color.parseColor((String)"#f0eff5"));
        this.searchPadding = array.getDimensionPixelSize(R.styleable.SearchLayout_search_padding, -1);
        this.searchPaddingLeft = array.getDimensionPixelSize(R.styleable.SearchLayout_search_padding_left, 16);
        this.searchPaddingTop = array.getDimensionPixelSize(R.styleable.SearchLayout_search_padding_top, 16);
        this.searchPaddingRight = array.getDimensionPixelSize(R.styleable.SearchLayout_search_padding_right, 16);
        this.searchPaddingBottom = array.getDimensionPixelSize(R.styleable.SearchLayout_search_padding_bottom, 16);
        this.searchTextColor = array.getColor(R.styleable.SearchLayout_search_text_color, Color.parseColor((String)"#313131"));
        this.searchTextSize = array.getDimensionPixelSize(R.styleable.SearchLayout_search_text_size, 28);
        this.searchTextColorHint = array.getColor(R.styleable.SearchLayout_search_text_color_hint, Color.parseColor((String)"#9a9a9c"));
        this.searchSingleLine = array.getBoolean(R.styleable.SearchLayout_search_single_line, true);
        this.searchHint = array.getString(R.styleable.SearchLayout_search_hint);
        this.searchDrawablePadding = array.getDimensionPixelSize(R.styleable.SearchLayout_search_drawable_padding, 10);
        this.searchHeight = array.getDimensionPixelSize(R.styleable.SearchLayout_search_height, 70);
        this.searchButtonColor = array.getColor(R.styleable.SearchLayout_search_button_color, Color.parseColor((String)"#313131"));
        this.searchButtonTextSize = array.getDimensionPixelSize(R.styleable.SearchLayout_search_button_text_size, 28);
        this.searchButtonEmptyTxt = array.getString(R.styleable.SearchLayout_search_button_empty_txt);
        this.searchButtonTxt = array.getString(R.styleable.SearchLayout_search_button_txt);
        this.searchImeOption = array.getInt(R.styleable.SearchLayout_search_imeOption, -1);
        this.searchButtonWidth = array.getDimensionPixelSize(R.styleable.SearchLayout_search_button_width, 90);
        if (this.searchTextBackground == null) {
            this.searchTextBackground = ContextCompat.getDrawable((Context)context, (int)R.drawable.bg_search);
        }
        if (this.searchDrawableLeftIcon == null) {
            this.searchDrawableLeftIcon = ContextCompat.getDrawable((Context)context, (int)R.drawable.ic_search);
        }
        if (TextUtils.isEmpty((CharSequence)this.searchHint)) {
            this.searchHint = "\u641c\u7d22";
        }
        if (TextUtils.isEmpty((CharSequence)this.searchButtonEmptyTxt)) {
            this.searchButtonEmptyTxt = "\u53d6\u6d88";
        }
        if (TextUtils.isEmpty((CharSequence)this.searchButtonTxt)) {
            this.searchButtonTxt = "\u641c\u7d22";
        }
        array.recycle();
        this.initView();
    }

    private void initView() {
        this.parent = (LinearLayout)this.findViewById(R.id.parent);
        this.et = (EditText)this.findViewById(R.id.et);
        this.constraintLayout = (ConstraintLayout)this.findViewById(R.id.constraint_layout);
        this.bt = (Button)this.findViewById(R.id.bt);
        this.ivClear = (ImageView)this.findViewById(R.id.iv_clear);
        this.setValue();
    }

    private void setValue() {
        this.et.setTextColor(this.searchTextColor);
        this.et.setTextSize(0, (float)this.searchTextSize);
        this.et.setHintTextColor(this.searchTextColorHint);
        this.et.setSingleLine(this.searchSingleLine);
        this.et.setHint((CharSequence)this.searchHint);
        if (this.searchImeOption != -1) {
            this.et.setImeOptions(this.searchImeOption);
        }
        this.searchDrawableLeftIcon.setBounds(0, 0, this.searchHeight / 3 * 2, this.searchHeight / 3 * 2);
        this.et.setCompoundDrawablePadding(this.searchDrawablePadding);
        this.et.setCompoundDrawables(this.searchDrawableLeftIcon, null, null, null);
        this.constraintLayout.setBackground(this.searchTextBackground);
        this.constraintLayout.getLayoutParams().height = this.searchHeight;
        this.bt.setTextColor(this.searchButtonColor);
        this.bt.setTextSize(0, (float)this.searchButtonTextSize);
        this.bt.getLayoutParams().width = this.searchButtonWidth;
        this.parent.setBackgroundColor(this.searchBackgroundColor);
        if (this.searchPadding != -1) {
            this.parent.setPadding(this.searchPadding, this.searchPadding, this.searchPadding, this.searchPadding);
        } else {
            this.parent.setPadding(this.searchPaddingLeft, this.searchPaddingTop, this.searchPaddingRight, this.searchPaddingBottom);
        }
        this.ivClear.setVisibility(8);
        this.constraintSet = new ConstraintSet();
        this.constraintSet.clone(this.constraintLayout);
        this.initListener();
    }

    private void initListener() {
        this.et.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SearchLayout.this.bt.setText((CharSequence)SearchLayout.this.searchButtonEmptyTxt);
                SearchLayout.this.changeLayout(true);
            }
        });
        this.constraintLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SearchLayout.this.bt.setText((CharSequence)SearchLayout.this.searchButtonEmptyTxt);
                SearchLayout.this.changeLayout(true);
            }
        });
        this.bt.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (SearchLayout.this.onSearchListener != null) {
                    String str = SearchLayout.this.bt.getText().toString().trim();
                    SearchLayout.this.onSearchListener.onClick(SearchLayout.this.et.getText().toString().trim(), str.equals(SearchLayout.this.searchButtonTxt));
                }
                if (SearchLayout.this.bt.getText().toString().equals(SearchLayout.this.searchButtonEmptyTxt)) {
                    SearchLayout.this.changeLayout(false);
                    SearchLayout.this.et.setText((CharSequence)"");
                } else {
                    SearchLayout.this.setSoftInput(false);
                }
            }
        });
        this.et.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                if (TextUtils.isEmpty((CharSequence)s.toString())) {
                    SearchLayout.this.bt.setText((CharSequence)SearchLayout.this.searchButtonEmptyTxt);
                    SearchLayout.this.ivClear.setVisibility(8);
                } else {
                    SearchLayout.this.bt.setText((CharSequence)SearchLayout.this.searchButtonTxt);
                    SearchLayout.this.ivClear.setVisibility(0);
                }
            }
        });
        this.addEditorActionListener();
        this.ivClear.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SearchLayout.this.et.setText((CharSequence)"");
            }
        });
        this.setEditTextState(false);
    }

    private void addEditorActionListener() {
        if (this.searchImeOption != -1) {
            this.et.setOnEditorActionListener(new TextView.OnEditorActionListener(){

                public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                    if (SearchLayout.this.onEditorActionListener != null) {
                        SearchLayout.this.onEditorActionListener.onEditorAction(v, actionId, event);
                    }
                    return false;
                }
            });
        }
    }

    public void changeLayout(boolean canInput) {
        TransitionManager.beginDelayedTransition((ViewGroup)this.constraintLayout);
        this.parent.setLayoutTransition(canInput ? new LayoutTransition() : null);
        this.constraintSet.constrainWidth(R.id.et, canInput ? this.constraintLayout.getLayoutParams().width : -2);
        this.constraintSet.applyTo(this.constraintLayout);
        this.setEditTextState(canInput);
    }

    private void setEditTextState(boolean isFocusable) {
        this.bt.setVisibility(isFocusable ? 0 : 8);
        this.et.setFocusable(isFocusable);
        this.et.setFocusableInTouchMode(isFocusable);
        if (isFocusable) {
            this.et.requestFocus();
        } else {
            this.et.clearFocus();
        }
        this.setSoftInput(isFocusable);
    }

    public void setSoftInput(final boolean isFocusable) {
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                InputMethodManager m = (InputMethodManager)SearchLayout.this.et.getContext().getSystemService("input_method");
                if (isFocusable) {
                    m.showSoftInput((View)SearchLayout.this.et, 2);
                } else {
                    m.hideSoftInputFromWindow(SearchLayout.this.et.getWindowToken(), 0);
                }
            }
        }, 300L);
    }

    public void setImeOptions(int imeOptions) {
        this.et.setImeOptions(imeOptions);
        this.addEditorActionListener();
    }

    public void setOnSearchListener(OnSearchListener onSearchListener) {
        this.onSearchListener = onSearchListener;
    }

    public void setOnEditorActionListener(OnEditorActionListener onEditorActionListener) {
        this.onEditorActionListener = onEditorActionListener;
    }

    public static interface OnEditorActionListener {
        public boolean onEditorAction(TextView var1, int var2, KeyEvent var3);
    }

    public static interface OnSearchListener {
        public void onClick(String var1, boolean var2);
    }
}

