/*
 * Decompiled with CFR 0.152.
 */
package sing;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.DrawFilter;
import android.graphics.Paint;
import android.graphics.PaintFlagsDrawFilter;
import android.graphics.Rect;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;

public class SunLineView
extends View {
    private static final String Tag = SunLineView.class.getSimpleName();
    private int mHeight;
    private int mWidth;
    private Paint mLinePaint;
    private int mLineLeft;
    private int mLineTop;
    private int mLineHeight;
    private int mLineWidth;
    private int mFixLineHeight;
    private int mLineBottom;
    private int mSunRadius;
    private Rect debugRect;
    private RectF mouthRect;
    private DrawFilter mDrawFilter;
    private int mLineColor;
    private int mLineLevel;

    public SunLineView(Context context) {
        this(context, null);
    }

    public SunLineView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SunLineView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        Log.i((String)Tag, (String)"init");
        this.mLineWidth = this.changeDp(1);
        this.mLineHeight = this.changeDp(3);
        this.mFixLineHeight = this.changeDp(6);
        this.mSunRadius = this.changeDp(12);
        this.mLineColor = -65536;
        this.mLineLevel = 30;
        this.mLinePaint = new Paint(1);
        this.mLinePaint.setColor(this.mLineColor);
        this.mLinePaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mLinePaint.setStrokeWidth((float)this.mLineWidth);
        this.mDrawFilter = new PaintFlagsDrawFilter(0, 3);
        this.debugRect = new Rect();
        this.mouthRect = new RectF();
    }

    public void setLineColor(int lineColor) {
        this.mLineColor = lineColor;
        this.invalidate();
    }

    public void setLineWidth(int lineWidth) {
        this.mLineWidth = this.changeDp(lineWidth);
        this.invalidate();
    }

    public void setLineHeight(int lineHeight) {
        this.mLineHeight = this.changeDp(lineHeight);
        this.mFixLineHeight = this.mLineHeight * 2;
        this.invalidate();
    }

    public void setSunRadius(int sunRadius) {
        this.mSunRadius = this.changeDp(sunRadius);
        this.invalidate();
    }

    public void setLineLevel(int level) {
        this.mLineLevel = level;
        this.invalidate();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        Log.i((String)Tag, (String)("w---->" + w + "  -------  h----->" + h));
        this.mWidth = w;
        this.mHeight = h;
        this.mLineLeft = this.mWidth / 2 - this.mLineWidth / 2;
        this.mLineTop = h / 2 - this.mSunRadius - this.mFixLineHeight;
        this.mLineBottom = this.mLineTop + this.mLineHeight;
        this.debugRect.left = this.mWidth / 2 - this.mSunRadius - this.mFixLineHeight;
        this.debugRect.right = this.mWidth / 2 + this.mSunRadius + this.mFixLineHeight;
        this.debugRect.top = this.mHeight / 2 - this.mSunRadius - this.mFixLineHeight;
        this.debugRect.bottom = this.mHeight / 2 + this.mSunRadius + this.mFixLineHeight;
        this.mouthRect.left = this.mWidth / 2 - this.mSunRadius / 2;
        this.mouthRect.right = this.mWidth / 2 + this.mSunRadius / 2;
        this.mouthRect.top = this.mHeight / 2 - this.mSunRadius / 2;
        this.mouthRect.bottom = this.mHeight / 2 + this.mSunRadius / 2;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        Log.i((String)Tag, (String)"onMeasure");
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int width = widthMode == 0x40000000 ? widthSize : (this.mSunRadius + this.mFixLineHeight + this.mLineHeight) * 2 + this.getPaddingRight() + this.getPaddingLeft();
        int height = heightMode == 0x40000000 ? heightSize : (this.mSunRadius + this.mFixLineHeight + this.mLineHeight) * 2 + this.getPaddingTop() + this.getPaddingBottom();
        this.setMeasuredDimension(width, height);
    }

    protected void onDraw(Canvas canvas) {
        canvas.setDrawFilter(this.mDrawFilter);
        super.onDraw(canvas);
        this.drawLines(canvas);
    }

    private void drawLines(Canvas canvas) {
        for (int i = 0; i <= 360; ++i) {
            if (i % this.mLineLevel != 0) continue;
            canvas.save();
            canvas.rotate((float)i, (float)(this.mWidth / 2), (float)(this.mHeight / 2));
            canvas.drawLine((float)this.mLineLeft, (float)this.mLineTop, (float)this.mLineLeft, (float)this.mLineBottom, this.mLinePaint);
            canvas.restore();
        }
    }

    public int changeDp(int value) {
        return (int)TypedValue.applyDimension((int)1, (float)value, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }
}

